/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.facet.taxonomy.writercache;

import org.apache.lucene.facet.taxonomy.FacetLabel;
import org.apache.lucene.facet.taxonomy.writercache.NameHashIntCacheLRU;
import org.apache.lucene.facet.taxonomy.writercache.NameIntCacheLRU;
import org.apache.lucene.facet.taxonomy.writercache.TaxonomyWriterCache;

public class LruTaxonomyWriterCache
implements TaxonomyWriterCache {
    private NameIntCacheLRU cache;

    public LruTaxonomyWriterCache(int cacheSize) {
        this(cacheSize, LRUType.LRU_HASHED);
    }

    public LruTaxonomyWriterCache(int cacheSize, LRUType lruType) {
        this.cache = lruType == LRUType.LRU_HASHED ? new NameHashIntCacheLRU(cacheSize) : new NameIntCacheLRU(cacheSize);
    }

    @Override
    public synchronized boolean isFull() {
        return this.cache.getSize() == this.cache.getMaxSize();
    }

    @Override
    public synchronized void clear() {
        this.cache.clear();
    }

    @Override
    public synchronized void close() {
        this.cache.clear();
        this.cache = null;
    }

    @Override
    public synchronized int get(FacetLabel categoryPath) {
        Integer res = this.cache.get(categoryPath);
        if (res == null) {
            return -1;
        }
        return res;
    }

    @Override
    public synchronized boolean put(FacetLabel categoryPath, int ordinal) {
        boolean ret = this.cache.put(categoryPath, new Integer(ordinal));
        if (ret) {
            this.cache.makeRoomLRU();
        }
        return ret;
    }

    public static enum LRUType {
        LRU_HASHED,
        LRU_STRING;

    }
}

