/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.query.internal;

import java.util.HashMap;
import java.util.Map;
import org.hibernate.engine.query.spi.NamedParameterDescriptor;
import org.hibernate.engine.query.spi.NativeQueryInterpreter;
import org.hibernate.engine.query.spi.NativeSQLQueryPlan;
import org.hibernate.engine.query.spi.OrdinalParameterDescriptor;
import org.hibernate.engine.query.spi.ParamLocationRecognizer;
import org.hibernate.engine.query.spi.ParameterMetadata;
import org.hibernate.engine.query.spi.sql.NativeSQLQuerySpecification;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.loader.custom.sql.SQLCustomQuery;

public class NativeQueryInterpreterStandardImpl
implements NativeQueryInterpreter {
    public static final NativeQueryInterpreterStandardImpl INSTANCE = new NativeQueryInterpreterStandardImpl();

    @Override
    public ParameterMetadata getParameterMetadata(String nativeQuery) {
        ParamLocationRecognizer recognizer = ParamLocationRecognizer.parseLocations(nativeQuery);
        int size = recognizer.getOrdinalParameterLocationList().size();
        OrdinalParameterDescriptor[] ordinalDescriptors = new OrdinalParameterDescriptor[size];
        for (int i = 0; i < size; ++i) {
            Integer position = recognizer.getOrdinalParameterLocationList().get(i);
            ordinalDescriptors[i] = new OrdinalParameterDescriptor(i, null, position);
        }
        HashMap<String, NamedParameterDescriptor> namedParamDescriptorMap = new HashMap<String, NamedParameterDescriptor>();
        Map<String, ParamLocationRecognizer.NamedParameterDescription> map = recognizer.getNamedParameterDescriptionMap();
        for (String name : map.keySet()) {
            ParamLocationRecognizer.NamedParameterDescription description = map.get(name);
            namedParamDescriptorMap.put(name, new NamedParameterDescriptor(name, null, description.buildPositionsArray(), description.isJpaStyle()));
        }
        return new ParameterMetadata(ordinalDescriptors, namedParamDescriptorMap);
    }

    @Override
    public NativeSQLQueryPlan createQueryPlan(NativeSQLQuerySpecification specification, SessionFactoryImplementor sessionFactory) {
        SQLCustomQuery customQuery = new SQLCustomQuery(specification.getQueryString(), specification.getQueryReturns(), specification.getQuerySpaces(), sessionFactory);
        return new NativeSQLQueryPlan(specification.getQueryString(), customQuery);
    }
}

