/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.hotrod;

import io.netty.buffer.ByteBuf;
import io.netty.util.CharsetUtil;
import org.infinispan.server.core.transport.ExtendedByteBufJava;
import org.infinispan.server.hotrod.Constants$;
import org.infinispan.server.hotrod.ExpirationParam;
import org.infinispan.server.hotrod.HotRodHeader;
import org.infinispan.server.hotrod.HotRodOperation;
import org.infinispan.server.hotrod.HotRodUnknownOperationException;
import org.infinispan.server.hotrod.ProtocolFlag;
import org.infinispan.server.hotrod.RequestParameters;
import org.infinispan.server.hotrod.TimeUnitValue;
import scala.Enumeration;

public class Decoder2xJava {
    private static final long EXPIRATION_NONE = -1L;
    private static final long EXPIRATION_DEFAULT = -2L;
    private static final ExpirationParam DEFAULT_EXPIRATION = new ExpirationParam(-1L, TimeUnitValue.SECONDS());

    static boolean readHeader(ByteBuf buffer, byte version, long messageId, HotRodHeader header) throws HotRodUnknownOperationException {
        int flag;
        if (header.op() == null) {
            int readableBytes = buffer.readableBytes();
            if (readableBytes < 2) {
                return false;
            }
            byte streamOp = buffer.readByte();
            int length = ExtendedByteBufJava.readMaybeVInt((ByteBuf)buffer);
            if (length == Integer.MIN_VALUE || length > buffer.readableBytes()) {
                return false;
            }
            if (length == 0) {
                header.cacheName_$eq("");
            } else {
                byte[] bytes = new byte[length];
                buffer.readBytes(bytes);
                header.cacheName_$eq(new String(bytes, CharsetUtil.UTF_8));
            }
            switch (streamOp) {
                case 1: {
                    header.op_$eq(HotRodOperation.PutRequest);
                    break;
                }
                case 3: {
                    header.op_$eq(HotRodOperation.GetRequest);
                    break;
                }
                case 5: {
                    header.op_$eq(HotRodOperation.PutIfAbsentRequest);
                    break;
                }
                case 7: {
                    header.op_$eq(HotRodOperation.ReplaceRequest);
                    break;
                }
                case 9: {
                    header.op_$eq(HotRodOperation.ReplaceIfUnmodifiedRequest);
                    break;
                }
                case 11: {
                    header.op_$eq(HotRodOperation.RemoveRequest);
                    break;
                }
                case 13: {
                    header.op_$eq(HotRodOperation.RemoveIfUnmodifiedRequest);
                    break;
                }
                case 15: {
                    header.op_$eq(HotRodOperation.ContainsKeyRequest);
                    break;
                }
                case 17: {
                    header.op_$eq(HotRodOperation.GetWithVersionRequest);
                    break;
                }
                case 19: {
                    header.op_$eq(HotRodOperation.ClearRequest);
                    break;
                }
                case 21: {
                    header.op_$eq(HotRodOperation.StatsRequest);
                    break;
                }
                case 23: {
                    header.op_$eq(HotRodOperation.PingRequest);
                    break;
                }
                case 25: {
                    header.op_$eq(HotRodOperation.BulkGetRequest);
                    break;
                }
                case 27: {
                    header.op_$eq(HotRodOperation.GetWithMetadataRequest);
                    break;
                }
                case 29: {
                    header.op_$eq(HotRodOperation.BulkGetKeysRequest);
                    break;
                }
                case 31: {
                    header.op_$eq(HotRodOperation.QueryRequest);
                    break;
                }
                case 33: {
                    header.op_$eq(HotRodOperation.AuthMechListRequest);
                    break;
                }
                case 35: {
                    header.op_$eq(HotRodOperation.AuthRequest);
                    break;
                }
                case 37: {
                    header.op_$eq(HotRodOperation.AddClientListenerRequest);
                    break;
                }
                case 39: {
                    header.op_$eq(HotRodOperation.RemoveClientListenerRequest);
                    break;
                }
                case 41: {
                    header.op_$eq(HotRodOperation.SizeRequest);
                    break;
                }
                case 43: {
                    header.op_$eq(HotRodOperation.ExecRequest);
                    break;
                }
                case 45: {
                    header.op_$eq(HotRodOperation.PutAllRequest);
                    break;
                }
                case 47: {
                    header.op_$eq(HotRodOperation.GetAllRequest);
                    break;
                }
                case 49: {
                    header.op_$eq(HotRodOperation.IterationStartRequest);
                    break;
                }
                case 51: {
                    header.op_$eq(HotRodOperation.IterationNextRequest);
                    break;
                }
                case 53: {
                    header.op_$eq(HotRodOperation.IterationEndRequest);
                    break;
                }
                default: {
                    throw new HotRodUnknownOperationException("Unknown operation: " + streamOp, version, messageId);
                }
            }
            buffer.markReaderIndex();
        }
        if ((flag = ExtendedByteBufJava.readMaybeVInt((ByteBuf)buffer)) == Integer.MIN_VALUE) {
            return false;
        }
        if (buffer.readableBytes() < 2) {
            return false;
        }
        byte clientIntelligence = buffer.readByte();
        int topologyId = ExtendedByteBufJava.readMaybeVInt((ByteBuf)buffer);
        if (topologyId == Integer.MIN_VALUE) {
            return false;
        }
        header.flag_$eq(flag);
        header.clientIntel_$eq(clientIntelligence);
        header.topologyId_$eq(topologyId);
        buffer.markReaderIndex();
        return true;
    }

    static RequestParameters readParameters(HotRodHeader header, ByteBuf buffer) {
        switch (header.op()) {
            case RemoveIfUnmodifiedRequest: {
                return Decoder2xJava.readParameters(buffer, header, false, false, true);
            }
            case ReplaceIfUnmodifiedRequest: {
                return Decoder2xJava.readParameters(buffer, header, true, true, true);
            }
            case GetAllRequest: {
                return Decoder2xJava.readParameters(buffer, header, false, true, false);
            }
        }
        return Decoder2xJava.readParameters(buffer, header, true, true, false);
    }

    private static RequestParameters readParameters(ByteBuf buffer, HotRodHeader header, boolean readExpiration, boolean readSize, boolean readVersion) {
        int size;
        long version;
        ExpirationParam param2;
        ExpirationParam param1;
        if (readExpiration) {
            byte firstUnit;
            byte secondUnit;
            boolean pre22Version = Constants$.MODULE$.isVersionPre22(header.version());
            if (pre22Version) {
                firstUnit = secondUnit = TimeUnitValue.SECONDS();
            } else {
                if (buffer.readableBytes() == 0) {
                    return null;
                }
                byte units = buffer.readByte();
                firstUnit = (byte)((units & 0xF0) >> 4);
                secondUnit = (byte)(units & 0xF);
            }
            param1 = Decoder2xJava.readExpirationParam(pre22Version, Decoder2xJava.hasFlag(header, ProtocolFlag.DefaultLifespan()), buffer, firstUnit);
            if (param1 == null) {
                return null;
            }
            param2 = Decoder2xJava.readExpirationParam(pre22Version, Decoder2xJava.hasFlag(header, ProtocolFlag.DefaultMaxIdle()), buffer, secondUnit);
            if (param2 == null) {
                return null;
            }
        } else {
            param1 = param2 = DEFAULT_EXPIRATION;
        }
        if (readVersion) {
            version = ExtendedByteBufJava.readUnsignedMaybeLong((ByteBuf)buffer);
            if (version == Integer.MIN_VALUE) {
                return null;
            }
        } else {
            version = -1L;
        }
        if (readSize) {
            size = ExtendedByteBufJava.readMaybeVInt((ByteBuf)buffer);
            if (size == Integer.MIN_VALUE) {
                return null;
            }
        } else {
            size = -1;
        }
        buffer.markReaderIndex();
        return new RequestParameters(size, param1, param2, version);
    }

    private static ExpirationParam readExpirationParam(boolean pre22Version, boolean useDefault, ByteBuf buffer, byte timeUnit) {
        if (pre22Version) {
            int duration = ExtendedByteBufJava.readMaybeVInt((ByteBuf)buffer);
            if (duration == Integer.MIN_VALUE) {
                return null;
            }
            if (duration <= 0) {
                duration = useDefault ? -2 : -1;
            }
            return new ExpirationParam(duration, timeUnit);
        }
        switch (timeUnit) {
            case 7: {
                return new ExpirationParam(-2L, timeUnit);
            }
            case 8: {
                return new ExpirationParam(-1L, timeUnit);
            }
        }
        long timeDuration = ExtendedByteBufJava.readMaybeVLong((ByteBuf)buffer);
        if (timeDuration == Long.MIN_VALUE) {
            return null;
        }
        return new ExpirationParam(timeDuration, timeUnit);
    }

    private static boolean hasFlag(HotRodHeader h, Enumeration.Value f) {
        return (h.flag() & f.id()) == f.id();
    }
}

