/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.scripting.impl;

import java.nio.charset.Charset;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.commons.util.Immutables;

public enum DataType {
    UTF8(new Utf8Transformer()),
    DEFAULT(new DefaultTransformer());

    public final Transformer transformer;

    private DataType(Transformer transformer) {
        this.transformer = transformer;
    }

    public static DataType fromMime(String mime) {
        switch (mime) {
            case "text/plain; charset=utf-8": {
                return UTF8;
            }
        }
        return DEFAULT;
    }

    static final class DefaultTransformer
    implements Transformer {
        DefaultTransformer() {
        }

        @Override
        public Map<String, ?> toDataType(Map<String, ?> objs, Optional<Marshaller> marshaller) {
            if (marshaller.isPresent()) {
                Marshaller m = marshaller.get();
                return objs.entrySet().stream().map(e -> {
                    Object v = e.getValue();
                    Object entryValue = v instanceof byte[] ? DefaultTransformer.fromBytes(v, m) : v;
                    return Immutables.immutableEntry(e.getKey(), entryValue);
                }).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            }
            return objs;
        }

        private static Object fromBytes(Object obj, Marshaller marshaller) {
            try {
                return marshaller.objectFromByteBuffer((byte[])obj);
            }
            catch (Exception e) {
                throw new CacheException((Throwable)e);
            }
        }

        @Override
        public Object fromDataType(Object obj, Optional<Marshaller> marshaller) {
            try {
                return marshaller.map(m -> DefaultTransformer.toBytes(obj, m)).orElse(obj);
            }
            catch (Exception e) {
                throw new CacheException((Throwable)e);
            }
        }

        private static Object toBytes(Object obj, Marshaller marshaller) {
            try {
                return marshaller.objectToByteBuffer(obj);
            }
            catch (Exception e) {
                throw new CacheException((Throwable)e);
            }
        }
    }

    static final class Utf8Transformer
    implements Transformer {
        public static final Charset CHARSET_UTF8 = Charset.forName("UTF-8");

        Utf8Transformer() {
        }

        @Override
        public Map<String, ?> toDataType(Map<String, ?> objs, Optional<Marshaller> marshaller) {
            return objs.entrySet().stream().map(e -> {
                Object v = e.getValue();
                Object entryValue = v instanceof byte[] ? Utf8Transformer.asString(v) : v;
                return Immutables.immutableEntry(e.getKey(), entryValue);
            }).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        }

        @Override
        public Object fromDataType(Object obj, Optional<Marshaller> marshaller) {
            return obj instanceof String ? (Object)((String)obj).getBytes(CHARSET_UTF8) : obj;
        }

        private static String asString(Object v) {
            return new String((byte[])v, CHARSET_UTF8);
        }
    }

    static interface Transformer {
        public Map<String, ?> toDataType(Map<String, ?> var1, Optional<Marshaller> var2);

        public Object fromDataType(Object var1, Optional<Marshaller> var2);
    }
}

