/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.cli.commands.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.concurrent.atomic.AtomicInteger;
import javax.jms.BytesMessage;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.TextMessage;
import org.apache.activemq.artemis.utils.ReusableLatch;

public class ProducerThread
extends Thread {
    protected final Session session;
    boolean verbose;
    int messageCount = 1000;
    boolean runIndefinitely = false;
    Destination destination;
    int sleep = 0;
    boolean persistent = true;
    int messageSize = 0;
    int textMessageSize;
    long msgTTL = 0L;
    String msgGroupID = null;
    int transactionBatchSize;
    int transactions = 0;
    final AtomicInteger sentCount = new AtomicInteger(0);
    String message;
    String messageText = null;
    String payloadUrl = null;
    byte[] payload = null;
    boolean running = false;
    final ReusableLatch finished = new ReusableLatch(1);
    final ReusableLatch paused = new ReusableLatch(0);

    public ProducerThread(Session session, Destination destination, int threadNr) {
        super("Producer " + destination.toString() + ", thread=" + threadNr);
        this.destination = destination;
        this.session = session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        MessageProducer producer = null;
        String threadName = Thread.currentThread().getName();
        try {
            producer = this.session.createProducer(this.destination);
            producer.setDeliveryMode(this.persistent ? 2 : 1);
            producer.setTimeToLive(this.msgTTL);
            this.initPayLoad();
            this.running = true;
            System.out.println(threadName + " Started to calculate elapsed time ...\n");
            long tStart = System.currentTimeMillis();
            if (this.runIndefinitely) {
                while (this.running) {
                    this.paused.await();
                    this.sendMessage(producer, threadName);
                    this.sentCount.incrementAndGet();
                }
            } else {
                this.sentCount.set(0);
                while (this.sentCount.get() < this.messageCount && this.running) {
                    this.paused.await();
                    this.sendMessage(producer, threadName);
                    this.sentCount.incrementAndGet();
                }
            }
            try {
                this.session.commit();
            }
            catch (Throwable ignored) {
                // empty catch block
            }
            System.out.println(threadName + " Produced: " + this.getSentCount() + " messages");
            long tEnd = System.currentTimeMillis();
            long elapsed = (tEnd - tStart) / 1000L;
            System.out.println(threadName + " Elapsed time in second : " + elapsed + " s");
            System.out.println(threadName + " Elapsed time in milli second : " + (tEnd - tStart) + " milli seconds");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (this.finished != null) {
                this.finished.countDown();
            }
            if (producer != null) {
                try {
                    producer.close();
                }
                catch (JMSException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private void sendMessage(MessageProducer producer, String threadName) throws Exception {
        Message message = this.createMessage(this.sentCount.get(), threadName);
        producer.send(message);
        if (this.verbose) {
            System.out.println(threadName + " Sent: " + (message instanceof TextMessage ? ((TextMessage)message).getText() : message.getJMSMessageID()));
        }
        if (this.transactionBatchSize > 0 && this.sentCount.get() > 0 && this.sentCount.get() % this.transactionBatchSize == 0) {
            System.out.println(threadName + " Committing transaction: " + this.transactions++);
            this.session.commit();
        }
        if (this.sleep > 0) {
            Thread.sleep(this.sleep);
        }
    }

    private void initPayLoad() {
        if (this.messageSize > 0) {
            this.payload = new byte[this.messageSize];
            for (int i = 0; i < this.payload.length; ++i) {
                this.payload[i] = 46;
            }
        }
    }

    protected Message createMessage(int i, String threadName) throws Exception {
        BytesMessage answer;
        if (this.payload != null) {
            answer = this.session.createBytesMessage();
            answer.writeBytes(this.payload);
        } else {
            if (this.textMessageSize > 0) {
                if (this.messageText == null) {
                    this.messageText = this.readInputStream(this.getClass().getResourceAsStream("demo.txt"), this.textMessageSize, i);
                }
            } else {
                this.messageText = this.payloadUrl != null ? this.readInputStream(new URL(this.payloadUrl).openStream(), -1, i) : (this.message != null ? this.message : this.createDefaultMessage(i));
            }
            answer = this.session.createTextMessage(this.messageText);
        }
        if (this.msgGroupID != null && !this.msgGroupID.isEmpty()) {
            answer.setStringProperty("JMSXGroupID", this.msgGroupID);
        }
        answer.setIntProperty("count", i);
        answer.setStringProperty("ThreadSent", threadName);
        return answer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readInputStream(InputStream is, int size, int messageNumber) throws IOException {
        try (InputStreamReader reader = new InputStreamReader(is);){
            int count;
            char[] buffer = size > 0 ? new char[size] : new char[1024];
            StringBuilder builder = new StringBuilder();
            while ((count = reader.read(buffer)) != -1) {
                builder.append(buffer, 0, count);
                if (size <= 0) continue;
            }
            String string = builder.toString();
            return string;
        }
    }

    private String createDefaultMessage(int messageNumber) {
        return "test message: " + messageNumber;
    }

    public ProducerThread setMessageCount(int messageCount) {
        this.messageCount = messageCount;
        return this;
    }

    public int getSleep() {
        return this.sleep;
    }

    public ProducerThread setSleep(int sleep) {
        this.sleep = sleep;
        return this;
    }

    public int getMessageCount() {
        return this.messageCount;
    }

    public int getSentCount() {
        return this.sentCount.get();
    }

    public boolean isPersistent() {
        return this.persistent;
    }

    public ProducerThread setPersistent(boolean persistent) {
        this.persistent = persistent;
        return this;
    }

    public boolean isRunning() {
        return this.running;
    }

    public ProducerThread setRunning(boolean running) {
        this.running = running;
        return this;
    }

    public long getMsgTTL() {
        return this.msgTTL;
    }

    public ProducerThread setMsgTTL(long msgTTL) {
        this.msgTTL = msgTTL;
        return this;
    }

    public int getTransactionBatchSize() {
        return this.transactionBatchSize;
    }

    public ProducerThread setTransactionBatchSize(int transactionBatchSize) {
        this.transactionBatchSize = transactionBatchSize;
        return this;
    }

    public String getMsgGroupID() {
        return this.msgGroupID;
    }

    public ProducerThread setMsgGroupID(String msgGroupID) {
        this.msgGroupID = msgGroupID;
        return this;
    }

    public int getTextMessageSize() {
        return this.textMessageSize;
    }

    public ProducerThread setTextMessageSize(int textMessageSize) {
        this.textMessageSize = textMessageSize;
        return this;
    }

    public int getMessageSize() {
        return this.messageSize;
    }

    public ProducerThread setMessageSize(int messageSize) {
        this.messageSize = messageSize;
        return this;
    }

    public ReusableLatch getFinished() {
        return this.finished;
    }

    public ProducerThread setFinished(int value) {
        this.finished.setCount(value);
        return this;
    }

    public String getPayloadUrl() {
        return this.payloadUrl;
    }

    public ProducerThread setPayloadUrl(String payloadUrl) {
        this.payloadUrl = payloadUrl;
        return this;
    }

    public String getMessage() {
        return this.message;
    }

    public ProducerThread setMessage(String message) {
        this.message = message;
        return this;
    }

    public boolean isRunIndefinitely() {
        return this.runIndefinitely;
    }

    public ProducerThread setRunIndefinitely(boolean runIndefinitely) {
        this.runIndefinitely = runIndefinitely;
        return this;
    }

    public ProducerThread pauseProducer() {
        this.paused.countUp();
        return this;
    }

    public ProducerThread resumeProducer() {
        this.paused.countDown();
        return this;
    }

    public ProducerThread resetCounters() {
        this.sentCount.set(0);
        return this;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public ProducerThread setVerbose(boolean verbose) {
        this.verbose = verbose;
        return this;
    }
}

