/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.cli.interpreter.codec;

import java.nio.charset.Charset;
import org.infinispan.cli.interpreter.Interpreter;
import org.infinispan.cli.interpreter.codec.AbstractCodec;
import org.infinispan.cli.interpreter.codec.CodecException;
import org.infinispan.cli.interpreter.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class MemcachedCodec
extends AbstractCodec {
    private static final Log log = (Log)LogFactory.getLog(Interpreter.class, Log.class);
    private Charset UTF8 = Charset.forName("UTF-8");

    @Override
    public String getName() {
        return "memcached";
    }

    @Override
    public Object encodeKey(Object key) {
        return key;
    }

    @Override
    public Object encodeValue(Object value) throws CodecException {
        if (value != null) {
            if (value instanceof String) {
                return ((String)value).getBytes(this.UTF8);
            }
            if (value instanceof byte[]) {
                return value;
            }
            throw log.valueEncodingFailed(value.getClass().getName(), this.getName());
        }
        return null;
    }

    @Override
    public Object decodeKey(Object key) {
        return key;
    }

    @Override
    public Object decodeValue(Object value) {
        if (value != null) {
            return new String((byte[])value, this.UTF8);
        }
        return null;
    }
}

