/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.cli.interpreter.statement;

import javax.transaction.TransactionManager;
import org.infinispan.cli.interpreter.logging.Log;
import org.infinispan.cli.interpreter.result.EmptyResult;
import org.infinispan.cli.interpreter.result.Result;
import org.infinispan.cli.interpreter.result.StatementException;
import org.infinispan.cli.interpreter.session.Session;
import org.infinispan.cli.interpreter.statement.AbstractTransactionStatement;
import org.infinispan.util.logging.LogFactory;

public class RollbackTransactionStatement
extends AbstractTransactionStatement {
    private static final Log log = (Log)LogFactory.getLog(RollbackTransactionStatement.class, Log.class);

    public RollbackTransactionStatement(String cacheName) {
        super(cacheName);
    }

    @Override
    public Result execute(Session session) throws StatementException {
        TransactionManager tm = this.getTransactionManager(session);
        if (tm == null) {
            throw log.noTransactionManager();
        }
        try {
            tm.rollback();
            return EmptyResult.RESULT;
        }
        catch (Exception e) {
            throw log.cannotRollbackTransaction(e);
        }
    }
}

