/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.impl.lucene;

import java.io.IOException;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Query;
import org.hibernate.search.analyzer.impl.LuceneAnalyzerReference;
import org.hibernate.search.backend.impl.lucene.analysis.ConcurrentlyMutableAnalyzer;
import org.hibernate.search.util.impl.ScopedAnalyzer;
import org.hibernate.search.util.impl.ScopedAnalyzerReference;

public final class IndexWriterDelegate {
    private final IndexWriter indexWriter;
    private final ConcurrentlyMutableAnalyzer mutableAnalyzer;
    private final Lock readLock;
    private final Lock writeLock;

    public IndexWriterDelegate(IndexWriter indexWriter) {
        this.indexWriter = indexWriter;
        this.mutableAnalyzer = (ConcurrentlyMutableAnalyzer)indexWriter.getAnalyzer();
        ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
        this.readLock = lock.readLock();
        this.writeLock = lock.writeLock();
    }

    public void deleteDocuments(Query termDeleteQuery) throws IOException {
        this.indexWriter.deleteDocuments(new Query[]{termDeleteQuery});
    }

    public void deleteDocuments(Term idTerm) throws IOException {
        this.indexWriter.deleteDocuments(new Term[]{idTerm});
    }

    public void addDocument(Document document, ScopedAnalyzerReference analyzer) throws IOException {
        this.updateDocument(null, document, analyzer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateDocument(Term idTerm, Document document, ScopedAnalyzerReference analyzer) throws IOException {
        boolean applyWithinReadLock;
        ScopedAnalyzer scopedAnalyzer = (ScopedAnalyzer)analyzer.unwrap(LuceneAnalyzerReference.class).getAnalyzer();
        this.readLock.lock();
        try {
            applyWithinReadLock = this.mutableAnalyzer.isCompatibleWith(scopedAnalyzer);
            if (applyWithinReadLock) {
                this.indexWriter.updateDocument(idTerm, (Iterable)document);
            }
        }
        finally {
            this.readLock.unlock();
        }
        if (!applyWithinReadLock) {
            this.writeLock.lock();
            try {
                this.mutableAnalyzer.updateAnalyzer(scopedAnalyzer);
                this.indexWriter.updateDocument(idTerm, (Iterable)document);
            }
            finally {
                this.writeLock.unlock();
            }
        }
    }

    @Deprecated
    public IndexWriter getIndexWriter() {
        return this.indexWriter;
    }
}

