/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.dsl.embedded.impl;

import org.hibernate.search.annotations.Store;
import org.hibernate.search.engine.metadata.impl.DocumentFieldMetadata;
import org.hibernate.search.engine.metadata.impl.EmbeddedTypeMetadata;
import org.hibernate.search.engine.metadata.impl.PropertyMetadata;
import org.hibernate.search.engine.metadata.impl.TypeMetadata;
import org.hibernate.search.engine.spi.EntityIndexBinding;
import org.hibernate.search.spi.SearchIntegrator;
import org.infinispan.objectfilter.impl.syntax.BooleShannonExpansion;

final class HibernateSearchIndexedFieldProvider
implements BooleShannonExpansion.IndexedFieldProvider {
    private final SearchIntegrator searchFactory;
    private final Class<?> entityClass;

    HibernateSearchIndexedFieldProvider(SearchIntegrator searchFactory, Class<?> entityClass) {
        this.searchFactory = searchFactory;
        this.entityClass = entityClass;
    }

    public boolean isIndexed(String[] propertyPath) {
        EntityIndexBinding entityIndexBinding = this.searchFactory.getIndexBinding(this.entityClass);
        if (entityIndexBinding == null) {
            return false;
        }
        TypeMetadata typeMetadata = entityIndexBinding.getDocumentBuilder().getMetadata();
        for (int i = 0; i < propertyPath.length - 1; ++i) {
            if ((typeMetadata = this.getEmbeddedTypeMetadata(typeMetadata, propertyPath[i])) != null) continue;
            return false;
        }
        String last = propertyPath[propertyPath.length - 1];
        return typeMetadata.getPropertyMetadataForProperty(last) != null || this.getEmbeddedTypeMetadata(typeMetadata, last) != null;
    }

    public boolean isStored(String[] propertyPath) {
        EntityIndexBinding entityIndexBinding = this.searchFactory.getIndexBinding(this.entityClass);
        if (entityIndexBinding == null) {
            return false;
        }
        TypeMetadata typeMetadata = entityIndexBinding.getDocumentBuilder().getMetadata();
        for (int i = 0; i < propertyPath.length - 1; ++i) {
            if ((typeMetadata = this.getEmbeddedTypeMetadata(typeMetadata, propertyPath[i])) != null) continue;
            return false;
        }
        String last = propertyPath[propertyPath.length - 1];
        PropertyMetadata propertyMetadata = typeMetadata.getPropertyMetadataForProperty(last);
        if (propertyMetadata == null) {
            return false;
        }
        for (DocumentFieldMetadata dfm : propertyMetadata.getFieldMetadataSet()) {
            if (dfm.getStore() != Store.NO) continue;
            return false;
        }
        return true;
    }

    private EmbeddedTypeMetadata getEmbeddedTypeMetadata(TypeMetadata typeMetadata, String name) {
        for (EmbeddedTypeMetadata embeddedTypeMetadata : typeMetadata.getEmbeddedTypeMetadata()) {
            if (!embeddedTypeMetadata.getEmbeddedFieldName().equals(name)) continue;
            return embeddedTypeMetadata;
        }
        return null;
    }
}

