/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.impl.massindex;

import java.util.Arrays;
import java.util.Set;
import java.util.function.BiConsumer;
import org.hibernate.search.backend.FlushLuceneWork;
import org.hibernate.search.backend.IndexingMonitor;
import org.hibernate.search.backend.LuceneWork;
import org.hibernate.search.backend.PurgeAllLuceneWork;
import org.hibernate.search.backend.impl.batch.DefaultBatchBackend;
import org.hibernate.search.backend.spi.BatchBackend;
import org.hibernate.search.batchindexing.MassIndexerProgressMonitor;
import org.hibernate.search.engine.spi.EntityIndexBinding;
import org.hibernate.search.indexes.spi.IndexManager;
import org.hibernate.search.spi.SearchIntegrator;

public class ExtendedBatchBackend
implements BatchBackend {
    private final DefaultBatchBackend defaultBatchBackend;
    private final SearchIntegrator integrator;
    private final MassIndexerProgressMonitor progressMonitor;

    public ExtendedBatchBackend(SearchIntegrator integrator, MassIndexerProgressMonitor progressMonitor) {
        this.integrator = integrator;
        this.progressMonitor = progressMonitor;
        this.defaultBatchBackend = new DefaultBatchBackend(integrator, progressMonitor);
    }

    public void purge(Set<Class<?>> entityTypes) {
        this.performShardAwareOperation(entityTypes, (im, type) -> im.performStreamOperation((LuceneWork)new PurgeAllLuceneWork(type), (IndexingMonitor)this.progressMonitor, false));
        this.flush(entityTypes);
    }

    public void enqueueAsyncWork(LuceneWork work) throws InterruptedException {
        this.defaultBatchBackend.enqueueAsyncWork(work);
    }

    public void doWorkInSync(LuceneWork work) {
        this.defaultBatchBackend.doWorkInSync(work);
    }

    public void flush(Set<Class<?>> indexedRootTypes) {
        this.performShardAwareOperation(indexedRootTypes, (im, type) -> im.performStreamOperation((LuceneWork)new FlushLuceneWork(null, type), (IndexingMonitor)this.progressMonitor, false));
    }

    public void optimize(Set<Class<?>> targetedClasses) {
        this.defaultBatchBackend.optimize(targetedClasses);
    }

    private void performShardAwareOperation(Set<Class<?>> entityTypes, BiConsumer<IndexManager, Class<?>> operation) {
        for (Class<?> type : entityTypes) {
            EntityIndexBinding indexBindingForEntity = this.integrator.getIndexBinding(type);
            if (indexBindingForEntity == null) continue;
            IndexManager[] indexManagers = indexBindingForEntity.getSelectionStrategy().getIndexManagersForDeletion(type, null, null);
            Arrays.stream(indexManagers).forEach(im -> operation.accept((IndexManager)im, type));
        }
    }
}

