/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.objectfilter.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.infinispan.objectfilter.FilterCallback;
import org.infinispan.objectfilter.ObjectFilter;
import org.infinispan.objectfilter.SortField;
import org.infinispan.objectfilter.impl.BaseMatcher;
import org.infinispan.objectfilter.impl.FilterResultImpl;
import org.infinispan.objectfilter.impl.FilterSubscriptionImpl;
import org.infinispan.objectfilter.impl.MetadataAdapter;
import org.infinispan.objectfilter.impl.aggregation.FieldAccumulator;
import org.infinispan.objectfilter.impl.predicateindex.AttributeNode;
import org.infinispan.objectfilter.impl.predicateindex.FilterEvalContext;
import org.infinispan.objectfilter.impl.predicateindex.MatcherEvalContext;
import org.infinispan.objectfilter.impl.predicateindex.PredicateIndex;
import org.infinispan.objectfilter.impl.predicateindex.be.BETree;
import org.infinispan.objectfilter.impl.predicateindex.be.BETreeMaker;
import org.infinispan.objectfilter.impl.syntax.BooleanExpr;
import org.infinispan.objectfilter.impl.syntax.BooleanFilterNormalizer;
import org.infinispan.objectfilter.impl.util.StringHelper;

final class ObjectFilterImpl<TypeMetadata, AttributeMetadata, AttributeId extends Comparable<AttributeId>>
implements ObjectFilter {
    private static final FilterCallback emptyCallback = (isDelta, userContext, eventType, instance, projection, sortProjection) -> {};
    private final BaseMatcher<TypeMetadata, AttributeMetadata, AttributeId> matcher;
    private final MetadataAdapter<TypeMetadata, AttributeMetadata, AttributeId> metadataAdapter;
    private final FieldAccumulator[] acc;
    private final BooleanExpr query;
    private final Set<String> paramNames;
    private final Map<String, Object> namedParameters;
    private final String queryString;
    private final String[] projection;
    private final Class<?>[] projectionTypes;
    private final List<List<AttributeId>> translatedProjections;
    private final SortField[] sortFields;
    private final List<List<AttributeId>> translatedSortFields;
    private final BooleanExpr normalizedQuery;
    private FilterSubscriptionImpl<TypeMetadata, AttributeMetadata, AttributeId> filterSubscription;
    private AttributeNode<AttributeMetadata, AttributeId> root;

    ObjectFilterImpl(BaseMatcher<TypeMetadata, AttributeMetadata, AttributeId> matcher, MetadataAdapter<TypeMetadata, AttributeMetadata, AttributeId> metadataAdapter, String queryString, Set<String> paramNames, BooleanExpr query, String[] projection, Class<?>[] projectionTypes, SortField[] sortFields, FieldAccumulator[] acc) {
        if (acc != null) {
            if (projectionTypes == null) {
                throw new IllegalArgumentException("Accumulators can only be used with projections");
            }
            if (sortFields != null) {
                throw new IllegalArgumentException("Accumulators cannot be used with sorting");
            }
        }
        this.namedParameters = null;
        this.paramNames = paramNames;
        this.matcher = matcher;
        this.metadataAdapter = metadataAdapter;
        this.acc = acc;
        this.query = query;
        this.queryString = queryString;
        this.projection = projection;
        this.projectionTypes = projectionTypes;
        this.sortFields = sortFields;
        if (projection != null && projection.length != 0) {
            this.translatedProjections = new ArrayList<List<AttributeId>>(projection.length);
            for (String projectionPath : projection) {
                this.translatedProjections.add(metadataAdapter.translatePropertyPath(StringHelper.split(projectionPath)));
            }
        } else {
            this.translatedProjections = null;
        }
        if (sortFields != null) {
            LinkedHashMap<String, SortField> sortFieldMap = new LinkedHashMap<String, SortField>();
            for (SortField sf : sortFields) {
                String path = sf.getPath().asStringPath();
                if (sortFieldMap.containsKey(path)) continue;
                sortFieldMap.put(path, sf);
            }
            sortFields = sortFieldMap.values().toArray(new SortField[sortFieldMap.size()]);
            this.translatedSortFields = new ArrayList<List<AttributeId>>(sortFields.length);
            for (SortField sortField : sortFields) {
                this.translatedSortFields.add(metadataAdapter.translatePropertyPath(sortField.getPath().getPath()));
            }
        } else {
            this.translatedSortFields = null;
        }
        BooleanFilterNormalizer booleanFilterNormalizer = new BooleanFilterNormalizer();
        this.normalizedQuery = booleanFilterNormalizer.normalize(query);
        if (paramNames.isEmpty()) {
            this.subscribe();
        }
    }

    private ObjectFilterImpl(ObjectFilterImpl<TypeMetadata, AttributeMetadata, AttributeId> other, Map<String, Object> namedParameters) {
        this.namedParameters = Collections.unmodifiableMap(namedParameters);
        this.paramNames = other.paramNames;
        this.matcher = other.matcher;
        this.metadataAdapter = other.metadataAdapter;
        this.acc = other.acc;
        this.query = other.query;
        this.queryString = other.queryString;
        this.projection = other.projection;
        this.projectionTypes = other.projectionTypes;
        this.sortFields = other.sortFields;
        this.translatedProjections = other.translatedProjections;
        this.translatedSortFields = other.translatedSortFields;
        this.normalizedQuery = other.normalizedQuery;
        this.subscribe();
    }

    private void subscribe() {
        BETreeMaker<AttributeId> treeMaker = new BETreeMaker<AttributeId>(this.metadataAdapter, false);
        BETree beTree = treeMaker.make(this.normalizedQuery, this.namedParameters);
        PredicateIndex<AttributeMetadata, AttributeId> predicateIndex = new PredicateIndex<AttributeMetadata, AttributeId>(this.metadataAdapter);
        this.root = predicateIndex.getRoot();
        this.filterSubscription = new FilterSubscriptionImpl<TypeMetadata, AttributeMetadata, AttributeId>(this.queryString, this.namedParameters, false, this.metadataAdapter, beTree, emptyCallback, this.projection, this.projectionTypes, this.translatedProjections, this.sortFields, this.translatedSortFields, null);
        this.filterSubscription.registerProjection(predicateIndex);
        this.filterSubscription.subscribe(predicateIndex);
        this.filterSubscription.index = 0;
    }

    @Override
    public String getEntityTypeName() {
        return this.metadataAdapter.getTypeName();
    }

    @Override
    public String[] getProjection() {
        return this.projection;
    }

    @Override
    public Class<?>[] getProjectionTypes() {
        return this.projectionTypes;
    }

    @Override
    public Set<String> getParameterNames() {
        return this.paramNames;
    }

    @Override
    public Map<String, Object> getParameters() {
        return this.namedParameters;
    }

    @Override
    public ObjectFilter withParameters(Map<String, Object> namedParameters) {
        if (namedParameters == null) {
            throw new IllegalArgumentException("namedParameters argument cannot be null");
        }
        return new ObjectFilterImpl<TypeMetadata, AttributeMetadata, AttributeId>(this, namedParameters);
    }

    @Override
    public SortField[] getSortFields() {
        return this.sortFields;
    }

    @Override
    public Comparator<Comparable[]> getComparator() {
        if (this.filterSubscription == null) {
            throw new IllegalStateException("Parameter values were not bound yet.");
        }
        return this.filterSubscription.getComparator();
    }

    @Override
    public ObjectFilter.FilterResult filter(Object instance) {
        if (this.filterSubscription == null) {
            throw new IllegalStateException("Parameter values were not bound yet.");
        }
        if (instance == null) {
            throw new IllegalArgumentException("instance cannot be null");
        }
        MatcherEvalContext<TypeMetadata, AttributeMetadata, AttributeId> matcherEvalContext = this.matcher.startSingleTypeContext(null, null, instance, this.filterSubscription.getMetadataAdapter());
        if (matcherEvalContext != null) {
            FilterEvalContext filterEvalContext = matcherEvalContext.initSingleFilterContext(this.filterSubscription);
            if (this.acc != null) {
                filterEvalContext.acc = this.acc;
                for (FieldAccumulator a : this.acc) {
                    if (a == null) continue;
                    a.init(filterEvalContext.getProjection());
                }
            }
            matcherEvalContext.process(this.root);
            if (filterEvalContext.isMatching()) {
                Object o = filterEvalContext.getProjection() == null ? this.matcher.convert(instance) : null;
                return new FilterResultImpl(o, filterEvalContext.getProjection(), filterEvalContext.getSortProjection());
            }
        }
        return null;
    }
}

