/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.objectfilter.impl.hql;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.antlr.runtime.tree.Tree;
import org.hibernate.hql.ast.TypeDescriptor;
import org.hibernate.hql.ast.common.JoinType;
import org.hibernate.hql.ast.origin.hql.resolve.path.PathedPropertyReference;
import org.hibernate.hql.ast.origin.hql.resolve.path.PathedPropertyReferenceSource;
import org.hibernate.hql.ast.origin.hql.resolve.path.PropertyPath;
import org.hibernate.hql.ast.spi.EntityNamesResolver;
import org.hibernate.hql.ast.spi.QueryResolverDelegate;
import org.infinispan.objectfilter.impl.hql.FilterEmbeddedEntityTypeDescriptor;
import org.infinispan.objectfilter.impl.hql.FilterEntityTypeDescriptor;
import org.infinispan.objectfilter.impl.hql.FilterPropertyTypeDescriptor;
import org.infinispan.objectfilter.impl.hql.FilterTypeDescriptor;
import org.infinispan.objectfilter.impl.hql.ObjectPropertyHelper;
import org.infinispan.objectfilter.impl.logging.Log;
import org.infinispan.objectfilter.impl.util.StringHelper;
import org.jboss.logging.Logger;

public class FilterQueryResolverDelegate
implements QueryResolverDelegate {
    private static final Log log = (Log)Logger.getMessageLogger(Log.class, (String)FilterQueryResolverDelegate.class.getName());
    protected final Map<String, String> aliasToEntityType = new HashMap<String, String>();
    protected final Map<String, PropertyPath> aliasToPropertyPath = new HashMap<String, PropertyPath>();
    protected final ObjectPropertyHelper propertyHelper;
    protected final EntityNamesResolver entityNamesResolver;
    protected String targetType;
    protected Class<?> targetClass;
    protected String alias;
    protected Status status;

    public FilterQueryResolverDelegate(EntityNamesResolver entityNamesResolver, ObjectPropertyHelper propertyHelper) {
        this.entityNamesResolver = entityNamesResolver;
        this.propertyHelper = propertyHelper;
    }

    public void registerPersisterSpace(Tree entityNameTree, Tree aliasTree) {
        String entityName;
        String alias = aliasTree.getText();
        String prevAlias = this.aliasToEntityType.put(alias, entityName = entityNameTree.getText());
        if (prevAlias != null && !prevAlias.equalsIgnoreCase(entityName)) {
            throw new UnsupportedOperationException("Alias reuse currently not supported: alias " + alias + " already assigned to type " + prevAlias);
        }
        if (this.targetType != null) {
            throw new IllegalStateException("Can't target multiple types: " + this.targetType + " already selected before " + entityName);
        }
        this.targetType = entityName;
        this.targetClass = this.entityNamesResolver.getClassFromName(entityName);
        if (this.targetClass == null) {
            throw new IllegalStateException("Unknown entity name " + entityName);
        }
    }

    public void registerJoinAlias(Tree alias, PropertyPath path) {
        if (!path.getNodes().isEmpty() && !this.aliasToPropertyPath.containsKey(alias.getText())) {
            this.aliasToPropertyPath.put(alias.getText(), path);
        }
    }

    public boolean isUnqualifiedPropertyReference() {
        return true;
    }

    public PathedPropertyReferenceSource normalizeUnqualifiedPropertyReference(Tree propertyTree) {
        String property = propertyTree.getText();
        if (this.aliasToEntityType.containsKey(property)) {
            return this.normalizeQualifiedRoot(propertyTree);
        }
        return this.normalizeProperty(new FilterEntityTypeDescriptor(this.targetType, this.propertyHelper), Collections.emptyList(), property);
    }

    public boolean isPersisterReferenceAlias() {
        return this.aliasToEntityType.containsKey(this.alias);
    }

    public PathedPropertyReferenceSource normalizeUnqualifiedRoot(Tree identifier382) {
        String aliasText = identifier382.getText();
        if (this.aliasToEntityType.containsKey(aliasText)) {
            return this.normalizeQualifiedRoot(identifier382);
        }
        if (this.aliasToPropertyPath.containsKey(aliasText)) {
            PropertyPath propertyPath = this.aliasToPropertyPath.get(aliasText);
            if (propertyPath == null) {
                throw log.getUnknownAliasException(aliasText);
            }
            FilterTypeDescriptor sourceType = (FilterTypeDescriptor)((PathedPropertyReferenceSource)propertyPath.getNodes().get(0)).getType();
            List<String> resolveAlias = this.resolveAlias(propertyPath);
            return new PathedPropertyReference(aliasText, (TypeDescriptor)new FilterEmbeddedEntityTypeDescriptor(sourceType.getEntityType(), resolveAlias, this.propertyHelper), true);
        }
        throw log.getUnknownAliasException(aliasText);
    }

    public PathedPropertyReferenceSource normalizeQualifiedRoot(Tree root) {
        String alias = root.getText();
        String entityNameForAlias = this.aliasToEntityType.get(alias);
        if (entityNameForAlias == null) {
            PropertyPath propertyPath = this.aliasToPropertyPath.get(alias);
            if (propertyPath == null) {
                throw log.getUnknownAliasException(alias);
            }
            return new PathedPropertyReference(StringHelper.join(propertyPath.getNodeNamesWithoutAlias()), null, false);
        }
        if (this.entityNamesResolver.getClassFromName(entityNameForAlias) == null) {
            throw new IllegalStateException("Unknown entity name " + entityNameForAlias);
        }
        return new PathedPropertyReference(alias, (TypeDescriptor)new FilterEntityTypeDescriptor(entityNameForAlias, this.propertyHelper), true);
    }

    public PathedPropertyReferenceSource normalizePropertyPathIntermediary(PropertyPath path, Tree propertyNameTree) {
        String propertyName;
        FilterTypeDescriptor sourceType = (FilterTypeDescriptor)path.getLastNode().getType();
        if (!sourceType.hasProperty(propertyName = propertyNameTree.getText())) {
            throw log.getNoSuchPropertyException(sourceType.toString(), propertyName);
        }
        List<String> newPath = this.resolveAlias(path);
        newPath.add(propertyName);
        return new PathedPropertyReference(propertyName, (TypeDescriptor)new FilterEmbeddedEntityTypeDescriptor(sourceType.getEntityType(), newPath, this.propertyHelper), false);
    }

    private List<String> resolveAlias(PropertyPath path) {
        if (path.getFirstNode().isAlias()) {
            String alias = path.getFirstNode().getName();
            if (this.aliasToEntityType.containsKey(alias)) {
                return path.getNodeNamesWithoutAlias();
            }
            if (this.aliasToPropertyPath.containsKey(alias)) {
                PropertyPath propertyPath = this.aliasToPropertyPath.get(alias);
                List<String> resolvedAlias = this.resolveAlias(propertyPath);
                resolvedAlias.addAll(path.getNodeNamesWithoutAlias());
                return resolvedAlias;
            }
            throw log.getUnknownAliasException(alias);
        }
        return path.getNodeNamesWithoutAlias();
    }

    public PathedPropertyReferenceSource normalizeIntermediateIndexOperation(PathedPropertyReferenceSource propertyReferenceSource, Tree collectionProperty, Tree selector) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public void normalizeTerminalIndexOperation(PathedPropertyReferenceSource propertyReferenceSource, Tree collectionProperty, Tree selector) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public PathedPropertyReferenceSource normalizeUnqualifiedPropertyReferenceSource(Tree identifier394) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public PathedPropertyReferenceSource normalizePropertyPathTerminus(PropertyPath path, Tree propertyNameNode) {
        return this.normalizeProperty((FilterTypeDescriptor)path.getLastNode().getType(), path.getNodeNamesWithoutAlias(), propertyNameNode.getText());
    }

    protected PathedPropertyReferenceSource normalizeProperty(FilterTypeDescriptor type, List<String> path, String propertyName) {
        FilterTypeDescriptor propType;
        if (!type.hasProperty(propertyName)) {
            throw log.getNoSuchPropertyException(type.toString(), propertyName);
        }
        if (type.hasEmbeddedProperty(propertyName)) {
            LinkedList<String> newPath = new LinkedList<String>(path);
            newPath.add(propertyName);
            propType = new FilterEmbeddedEntityTypeDescriptor(type.getEntityType(), newPath, this.propertyHelper);
        } else {
            propType = new FilterPropertyTypeDescriptor();
        }
        return new PathedPropertyReference(propertyName, (TypeDescriptor)propType, false);
    }

    public void pushFromStrategy(JoinType joinType, Tree associationFetchTree, Tree propertyFetchTree, Tree alias) {
        this.status = Status.DEFINING_FROM;
        this.alias = alias.getText();
    }

    public void pushSelectStrategy() {
        this.status = Status.DEFINING_SELECT;
    }

    public void popStrategy() {
        this.status = null;
        this.alias = null;
    }

    public void propertyPathCompleted(PropertyPath path) {
        if (this.status == Status.DEFINING_SELECT && path.getLastNode().getType() instanceof FilterEmbeddedEntityTypeDescriptor) {
            FilterEmbeddedEntityTypeDescriptor type = (FilterEmbeddedEntityTypeDescriptor)path.getLastNode().getType();
            throw log.getProjectionOfCompleteEmbeddedEntitiesNotSupportedException(type.getEntityType(), path.asStringPathWithoutAlias());
        }
    }

    protected static enum Status {
        DEFINING_SELECT,
        DEFINING_FROM;

    }
}

