/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.objectfilter.impl.hql.predicate;

import java.util.List;
import org.hibernate.hql.ast.spi.EntityNamesResolver;
import org.hibernate.hql.ast.spi.predicate.ComparisonPredicate;
import org.hibernate.hql.ast.spi.predicate.ConjunctionPredicate;
import org.hibernate.hql.ast.spi.predicate.DisjunctionPredicate;
import org.hibernate.hql.ast.spi.predicate.InPredicate;
import org.hibernate.hql.ast.spi.predicate.IsNullPredicate;
import org.hibernate.hql.ast.spi.predicate.LikePredicate;
import org.hibernate.hql.ast.spi.predicate.NegationPredicate;
import org.hibernate.hql.ast.spi.predicate.PredicateFactory;
import org.hibernate.hql.ast.spi.predicate.RangePredicate;
import org.hibernate.hql.ast.spi.predicate.RootPredicate;
import org.infinispan.objectfilter.impl.hql.ObjectPropertyHelper;
import org.infinispan.objectfilter.impl.hql.predicate.FilterComparisonPredicate;
import org.infinispan.objectfilter.impl.hql.predicate.FilterConjunctionPredicate;
import org.infinispan.objectfilter.impl.hql.predicate.FilterDisjunctionPredicate;
import org.infinispan.objectfilter.impl.hql.predicate.FilterInPredicate;
import org.infinispan.objectfilter.impl.hql.predicate.FilterIsNullPredicate;
import org.infinispan.objectfilter.impl.hql.predicate.FilterLikePredicate;
import org.infinispan.objectfilter.impl.hql.predicate.FilterNegationPredicate;
import org.infinispan.objectfilter.impl.hql.predicate.FilterRangePredicate;
import org.infinispan.objectfilter.impl.hql.predicate.FilterRootPredicate;
import org.infinispan.objectfilter.impl.syntax.BooleanExpr;
import org.infinispan.objectfilter.impl.syntax.PropertyValueExpr;

public final class FilterPredicateFactory
implements PredicateFactory<BooleanExpr> {
    private final EntityNamesResolver entityNamesResolver;
    private final ObjectPropertyHelper propertyHelper;

    public FilterPredicateFactory(EntityNamesResolver entityNamesResolver, ObjectPropertyHelper propertyHelper) {
        this.entityNamesResolver = entityNamesResolver;
        this.propertyHelper = propertyHelper;
    }

    public RootPredicate<BooleanExpr> getRootPredicate(String entityType) {
        if (this.entityNamesResolver.getClassFromName(entityType) == null) {
            throw new IllegalStateException("Unknown entity name " + entityType);
        }
        return new FilterRootPredicate();
    }

    public ComparisonPredicate<BooleanExpr> getComparisonPredicate(String entityType, ComparisonPredicate.Type comparisonType, List<String> propertyPath, Object comparisonValue) {
        String[] path = propertyPath.toArray(new String[propertyPath.size()]);
        PropertyValueExpr valueExpr = new PropertyValueExpr(path, this.propertyHelper.isRepeatedProperty(entityType, path), this.propertyHelper.getPrimitivePropertyType(entityType, path));
        return new FilterComparisonPredicate(valueExpr, comparisonType, comparisonValue);
    }

    public InPredicate<BooleanExpr> getInPredicate(String entityType, List<String> propertyPath, List<Object> values) {
        String[] path = propertyPath.toArray(new String[propertyPath.size()]);
        PropertyValueExpr valueExpr = new PropertyValueExpr(path, this.propertyHelper.isRepeatedProperty(entityType, path), this.propertyHelper.getPrimitivePropertyType(entityType, path));
        return new FilterInPredicate(valueExpr, values);
    }

    public RangePredicate<BooleanExpr> getRangePredicate(String entityType, List<String> propertyPath, Object lowerValue, Object upperValue) {
        String[] path = propertyPath.toArray(new String[propertyPath.size()]);
        PropertyValueExpr valueExpr = new PropertyValueExpr(path, this.propertyHelper.isRepeatedProperty(entityType, path), this.propertyHelper.getPrimitivePropertyType(entityType, path));
        return new FilterRangePredicate(valueExpr, lowerValue, upperValue);
    }

    public NegationPredicate<BooleanExpr> getNegationPredicate() {
        return new FilterNegationPredicate();
    }

    public DisjunctionPredicate<BooleanExpr> getDisjunctionPredicate() {
        return new FilterDisjunctionPredicate();
    }

    public ConjunctionPredicate<BooleanExpr> getConjunctionPredicate() {
        return new FilterConjunctionPredicate();
    }

    public LikePredicate<BooleanExpr> getLikePredicate(String entityType, List<String> propertyPath, String patternValue, Character escapeCharacter) {
        String[] path = propertyPath.toArray(new String[propertyPath.size()]);
        PropertyValueExpr valueExpr = new PropertyValueExpr(path, this.propertyHelper.isRepeatedProperty(entityType, path), this.propertyHelper.getPrimitivePropertyType(entityType, path));
        return new FilterLikePredicate(valueExpr, patternValue, escapeCharacter);
    }

    public IsNullPredicate<BooleanExpr> getIsNullPredicate(String entityType, List<String> propertyPath) {
        String[] path = propertyPath.toArray(new String[propertyPath.size()]);
        PropertyValueExpr valueExpr = new PropertyValueExpr(path, this.propertyHelper.isRepeatedProperty(entityType, path), this.propertyHelper.getPrimitivePropertyType(entityType, path));
        return new FilterIsNullPredicate(valueExpr);
    }
}

