/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands.functional;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import org.infinispan.commands.Visitor;
import org.infinispan.commands.functional.AbstractWriteManyCommand;
import org.infinispan.commons.api.functional.EntryView;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.context.InvocationContext;
import org.infinispan.functional.impl.EntryViews;
import org.infinispan.lifecycle.ComponentStatus;

public final class WriteOnlyManyEntriesCommand<K, V>
extends AbstractWriteManyCommand<K, V> {
    public static final byte COMMAND_ID = 57;
    private Map<? extends K, ? extends V> entries;
    private BiConsumer<V, EntryView.WriteEntryView<V>> f;

    public WriteOnlyManyEntriesCommand(Map<? extends K, ? extends V> entries, BiConsumer<V, EntryView.WriteEntryView<V>> f) {
        this.entries = entries;
        this.f = f;
    }

    public WriteOnlyManyEntriesCommand(WriteOnlyManyEntriesCommand<K, V> command) {
        this.entries = command.entries;
        this.f = command.f;
    }

    public WriteOnlyManyEntriesCommand() {
    }

    public Map<? extends K, ? extends V> getEntries() {
        return this.entries;
    }

    public void setEntries(Map<? extends K, ? extends V> entries) {
        this.entries = entries;
    }

    @Override
    public byte getCommandId() {
        return 57;
    }

    @Override
    public void writeTo(ObjectOutput output) throws IOException {
        output.writeObject(this.entries);
        output.writeObject(this.f);
        output.writeBoolean(this.isForwarded);
    }

    @Override
    public void readFrom(ObjectInput input) throws IOException, ClassNotFoundException {
        this.entries = (Map)input.readObject();
        this.f = (BiConsumer)input.readObject();
        this.isForwarded = input.readBoolean();
    }

    @Override
    public Object perform(InvocationContext ctx) throws Throwable {
        for (Map.Entry<K, V> entry : this.entries.entrySet()) {
            CacheEntry cacheEntry = ctx.lookupEntry(entry.getKey());
            if (cacheEntry == null) continue;
            this.f.accept(entry.getValue(), EntryViews.writeOnly(cacheEntry));
        }
        return null;
    }

    @Override
    public boolean isReturnValueExpected() {
        return false;
    }

    @Override
    public boolean canBlock() {
        return false;
    }

    @Override
    public Set<Object> getAffectedKeys() {
        return null;
    }

    @Override
    public void updateStatusFromRemoteResponse(Object remoteResponse) {
    }

    @Override
    public Object acceptVisitor(InvocationContext ctx, Visitor visitor) throws Throwable {
        return visitor.visitWriteOnlyManyEntriesCommand(ctx, this);
    }

    @Override
    public boolean ignoreCommandOnStatus(ComponentStatus status) {
        return false;
    }

    @Override
    public boolean readsExistingValues() {
        return false;
    }

    @Override
    public boolean alwaysReadsExistingValues() {
        return false;
    }

    @Override
    public boolean isWriteOnly() {
        return true;
    }
}

