/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.interceptors;

import java.util.Map;
import org.infinispan.commands.FlagAffectedCommand;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.commands.write.PutMapCommand;
import org.infinispan.commands.write.RemoveCommand;
import org.infinispan.commands.write.ReplaceCommand;
import org.infinispan.context.Flag;
import org.infinispan.context.InvocationContext;
import org.infinispan.distribution.DistributionManager;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.interceptors.CacheWriterInterceptor;
import org.infinispan.interceptors.locking.ClusteringDependentLogic;
import org.infinispan.persistence.manager.PersistenceManager;
import org.infinispan.remoting.transport.Address;
import org.infinispan.remoting.transport.Transport;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

@Deprecated
public class DistCacheWriterInterceptor
extends CacheWriterInterceptor {
    private DistributionManager dm;
    private Transport transport;
    private Address address;
    private static final Log log = LogFactory.getLog(DistCacheWriterInterceptor.class);
    private boolean isUsingLockDelegation;
    private ClusteringDependentLogic cdl;

    @Override
    protected Log getLog() {
        return log;
    }

    @Inject
    public void inject(DistributionManager dm, Transport transport, ClusteringDependentLogic cdl) {
        this.dm = dm;
        this.transport = transport;
        this.cdl = cdl;
    }

    @Start(priority=25)
    private void setAddress() {
        this.address = this.transport.getAddress();
        this.isUsingLockDelegation = !this.cacheConfiguration.transaction().transactionMode().isTransactional();
    }

    @Override
    public Object visitPutKeyValueCommand(InvocationContext ctx, PutKeyValueCommand command) throws Throwable {
        Object returnValue = this.invokeNextInterceptor(ctx, command);
        Object key = command.getKey();
        if (!this.isStoreEnabled(command) || ctx.isInTxScope() || !command.isSuccessful()) {
            return returnValue;
        }
        if (!this.isProperWriter(ctx, command, command.getKey())) {
            return returnValue;
        }
        this.storeEntry(ctx, key, command);
        if (this.getStatisticsEnabled()) {
            this.cacheStores.incrementAndGet();
        }
        return returnValue;
    }

    @Override
    public Object visitPutMapCommand(InvocationContext ctx, PutMapCommand command) throws Throwable {
        Object returnValue = this.invokeNextInterceptor(ctx, command);
        if (!this.isStoreEnabled(command) || ctx.isInTxScope()) {
            return returnValue;
        }
        Map<Object, Object> map = command.getMap();
        int count = 0;
        for (Object key : map.keySet()) {
            if (this.isUsingLockDelegation && command.isForwarded() && !this.dm.getPrimaryLocation(key).equals(ctx.getOrigin()) || !this.isProperWriter(ctx, command, key)) continue;
            this.storeEntry(ctx, key, command);
            ++count;
        }
        if (this.getStatisticsEnabled()) {
            this.cacheStores.getAndAdd(count);
        }
        return returnValue;
    }

    @Override
    public Object visitRemoveCommand(InvocationContext ctx, RemoveCommand command) throws Throwable {
        Object retval = this.invokeNextInterceptor(ctx, command);
        Object key = command.getKey();
        if (!this.isStoreEnabled(command) || ctx.isInTxScope() || !command.isSuccessful()) {
            return retval;
        }
        if (!this.isProperWriter(ctx, command, key)) {
            return retval;
        }
        boolean resp = this.persistenceManager.deleteFromAllStores(key, this.skipSharedStores(ctx, key, command) ? PersistenceManager.AccessMode.PRIVATE : PersistenceManager.AccessMode.BOTH);
        log.tracef("Removed entry under key %s and got response %s from CacheStore", key, resp);
        return retval;
    }

    @Override
    public Object visitReplaceCommand(InvocationContext ctx, ReplaceCommand command) throws Throwable {
        Object returnValue = this.invokeNextInterceptor(ctx, command);
        Object key = command.getKey();
        if (!this.isStoreEnabled(command) || ctx.isInTxScope() || !command.isSuccessful()) {
            return returnValue;
        }
        if (!this.isProperWriter(ctx, command, command.getKey())) {
            return returnValue;
        }
        this.storeEntry(ctx, key, command);
        if (this.getStatisticsEnabled()) {
            this.cacheStores.incrementAndGet();
        }
        return returnValue;
    }

    @Override
    protected boolean skipSharedStores(InvocationContext ctx, Object key, FlagAffectedCommand command) {
        return !this.cdl.localNodeIsPrimaryOwner(key) || command.hasFlag(Flag.SKIP_SHARED_CACHE_STORE);
    }

    @Override
    protected boolean isProperWriter(InvocationContext ctx, FlagAffectedCommand command, Object key) {
        if (command.hasFlag(Flag.SKIP_OWNERSHIP_CHECK)) {
            return true;
        }
        if (this.isUsingLockDelegation && !command.hasFlag(Flag.CACHE_MODE_LOCAL) && ctx.isOriginLocal() && !this.dm.getPrimaryLocation(key).equals(this.address)) {
            log.tracef("Skipping cache store on the originator because it is not the primary owner of key %s", key);
            return false;
        }
        if (!this.dm.getWriteConsistentHash().isKeyLocalToNode(this.address, key)) {
            log.tracef("Skipping cache store since the key is not local: %s", key);
            return false;
        }
        return true;
    }
}

