/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.query.engine.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.hibernate.search.engine.impl.FilterDef;
import org.hibernate.search.engine.integration.impl.ExtendedSearchIntegrator;
import org.hibernate.search.filter.FullTextFilter;
import org.hibernate.search.filter.impl.FullTextFilterImpl;
import org.hibernate.search.metadata.FieldDescriptor;
import org.hibernate.search.metadata.FieldSettingsDescriptor;
import org.hibernate.search.metadata.IndexedTypeDescriptor;
import org.hibernate.search.query.engine.impl.TimeoutManagerImpl;
import org.hibernate.search.query.engine.spi.HSQuery;
import org.hibernate.search.query.engine.spi.TimeoutExceptionFactory;
import org.hibernate.search.spatial.Coordinates;
import org.hibernate.search.spatial.DistanceSortField;
import org.hibernate.search.spi.SearchIntegrator;
import org.hibernate.search.util.StringHelper;
import org.hibernate.search.util.impl.CollectionHelper;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public abstract class AbstractHSQuery
implements HSQuery,
Serializable {
    private static final Log LOG = LoggerFactory.make();
    protected transient ExtendedSearchIntegrator extendedIntegrator;
    protected transient TimeoutExceptionFactory timeoutExceptionFactory;
    protected transient TimeoutManagerImpl timeoutManager;
    protected List<Class<?>> targetedEntities;
    protected Set<Class<?>> indexedTargetedEntities;
    protected Sort sort;
    protected String tenantId;
    protected String[] projectedFields;
    protected int firstResult;
    protected Integer maxResults;
    protected Coordinates spatialSearchCenter = null;
    protected String spatialFieldName = null;
    protected Filter userFilter;
    protected final Map<String, FullTextFilterImpl> filterDefinitions = CollectionHelper.newHashMap();

    public AbstractHSQuery(ExtendedSearchIntegrator extendedIntegrator) {
        this.extendedIntegrator = extendedIntegrator;
        this.timeoutExceptionFactory = extendedIntegrator.getDefaultTimeoutExceptionFactory();
    }

    @Override
    public void afterDeserialise(SearchIntegrator extendedIntegrator) {
        this.extendedIntegrator = extendedIntegrator.unwrap(ExtendedSearchIntegrator.class);
    }

    @Override
    public HSQuery setSpatialParameters(Coordinates center, String fieldName) {
        this.spatialSearchCenter = center;
        this.spatialFieldName = fieldName;
        return this;
    }

    @Override
    public HSQuery tenantIdentifier(String tenantId) {
        this.tenantId = tenantId;
        return this;
    }

    @Override
    public HSQuery targetedEntities(List<Class<?>> classes) {
        this.clearCachedResults();
        this.targetedEntities = classes == null ? new ArrayList(0) : new ArrayList(classes);
        Class[] classesAsArray = this.targetedEntities.toArray(new Class[this.targetedEntities.size()]);
        this.indexedTargetedEntities = this.extendedIntegrator.getIndexedTypesPolymorphic(classesAsArray);
        if (this.targetedEntities.size() > 0 && this.indexedTargetedEntities.size() == 0) {
            throw LOG.targetedEntityTypesNotIndexed(StringHelper.join(this.targetedEntities, ","));
        }
        return this;
    }

    @Override
    public HSQuery sort(Sort sort) {
        this.sort = sort;
        return this;
    }

    @Override
    public HSQuery filter(Filter filter) {
        this.clearCachedResults();
        this.userFilter = filter;
        return this;
    }

    @Override
    public HSQuery timeoutExceptionFactory(TimeoutExceptionFactory exceptionFactory) {
        this.timeoutExceptionFactory = exceptionFactory;
        return this;
    }

    @Override
    public HSQuery projection(String ... fields) {
        this.projectedFields = fields == null || fields.length == 0 ? null : fields;
        return this;
    }

    @Override
    public HSQuery firstResult(int firstResult) {
        if (firstResult < 0) {
            throw new IllegalArgumentException("'first' pagination parameter less than 0");
        }
        this.firstResult = firstResult;
        return this;
    }

    @Override
    public HSQuery maxResults(int maxResults) {
        if (maxResults < 0) {
            throw new IllegalArgumentException("'max' pagination parameter less than 0");
        }
        this.maxResults = maxResults;
        return this;
    }

    @Override
    public FullTextFilter enableFullTextFilter(String name) {
        this.clearCachedResults();
        FullTextFilterImpl filterDefinition = this.filterDefinitions.get(name);
        if (filterDefinition != null) {
            return filterDefinition;
        }
        filterDefinition = new FullTextFilterImpl();
        filterDefinition.setName(name);
        FilterDef filterDef = this.extendedIntegrator.getFilterDefinition(name);
        if (filterDef == null) {
            throw LOG.unknownFullTextFilter(name);
        }
        this.filterDefinitions.put(name, filterDefinition);
        return filterDefinition;
    }

    @Override
    public void disableFullTextFilter(String name) {
        this.clearCachedResults();
        this.filterDefinitions.remove(name);
    }

    @Override
    public List<Class<?>> getTargetedEntities() {
        return this.targetedEntities;
    }

    @Override
    public Set<Class<?>> getIndexedTargetedEntities() {
        return this.indexedTargetedEntities;
    }

    @Override
    public String[] getProjectedFields() {
        return this.projectedFields;
    }

    @Override
    public TimeoutManagerImpl getTimeoutManager() {
        if (this.timeoutManager == null) {
            this.timeoutManager = this.buildTimeoutManager();
        }
        return this.timeoutManager;
    }

    @Override
    public ExtendedSearchIntegrator getExtendedSearchIntegrator() {
        return this.extendedIntegrator;
    }

    protected void validateSortFields(ExtendedSearchIntegrator extendedIntegrator, Iterable<Class<?>> targetedEntities) {
        SortField[] sortFields;
        for (SortField sortField : sortFields = this.sort.getSort()) {
            if (!(sortField instanceof DistanceSortField)) continue;
            this.validateDistanceSortField(extendedIntegrator, targetedEntities, sortField);
        }
    }

    private void validateDistanceSortField(ExtendedSearchIntegrator extendedIntegrator, Iterable<Class<?>> targetedEntities, SortField sortField) {
        boolean indexedField = false;
        String field = sortField.getField();
        if (field != null) {
            for (Class<?> clazz : targetedEntities) {
                IndexedTypeDescriptor indexedTypeDescriptor = extendedIntegrator.getIndexedTypeDescriptor(clazz);
                FieldDescriptor fieldDescriptor = indexedTypeDescriptor.getIndexedField(field);
                if (fieldDescriptor == null) continue;
                indexedField = true;
                if (fieldDescriptor.getType() == FieldSettingsDescriptor.Type.SPATIAL) break;
                throw LOG.distanceSortRequiresSpatialField(field);
            }
        }
        if (!indexedField) {
            throw LOG.sortRequiresIndexedField(sortField.getClass(), field);
        }
    }

    protected abstract void extractFacetResults();

    protected abstract void clearCachedResults();

    protected abstract TimeoutManagerImpl buildTimeoutManager();
}

