/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.cache;

import java.util.concurrent.TimeUnit;
import org.infinispan.commons.configuration.attributes.Attribute;
import org.infinispan.commons.configuration.attributes.AttributeDefinition;
import org.infinispan.commons.configuration.attributes.AttributeSet;

public class ExpirationConfiguration {
    public static final AttributeDefinition<Long> LIFESPAN = AttributeDefinition.builder((String)"lifespan", (Object)-1L).build();
    public static final AttributeDefinition<Long> MAX_IDLE = AttributeDefinition.builder((String)"maxIdle", (Object)-1L).build();
    public static final AttributeDefinition<Boolean> REAPER_ENABLED = AttributeDefinition.builder((String)"reaperEnabled", (Object)true).immutable().build();
    public static final AttributeDefinition<Long> WAKEUP_INTERVAL = AttributeDefinition.builder((String)"wakeUpInterval", (Object)TimeUnit.MINUTES.toMillis(1L)).xmlName("interval").build();
    private final Attribute<Long> lifespan;
    private final Attribute<Long> maxIdle;
    private final Attribute<Boolean> reaperEnabled;
    private final Attribute<Long> wakeUpInterval;
    private final AttributeSet attributes;

    static AttributeSet attributeDefinitionSet() {
        return new AttributeSet(ExpirationConfiguration.class, new AttributeDefinition[]{LIFESPAN, MAX_IDLE, REAPER_ENABLED, WAKEUP_INTERVAL});
    }

    ExpirationConfiguration(AttributeSet attributes) {
        this.attributes = attributes.checkProtection();
        this.lifespan = attributes.attribute(LIFESPAN);
        this.maxIdle = attributes.attribute(MAX_IDLE);
        this.reaperEnabled = attributes.attribute(REAPER_ENABLED);
        this.wakeUpInterval = attributes.attribute(WAKEUP_INTERVAL);
    }

    public long lifespan() {
        return (Long)this.lifespan.get();
    }

    public long maxIdle() {
        return (Long)this.maxIdle.get();
    }

    public boolean reaperEnabled() {
        return (Boolean)this.reaperEnabled.get();
    }

    public long wakeUpInterval() {
        return (Long)this.wakeUpInterval.get();
    }

    public String toString() {
        return "ExpirationConfiguration [attributes=" + this.attributes + "]";
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ExpirationConfiguration other = (ExpirationConfiguration)obj;
        return !(this.attributes == null ? other.attributes != null : !this.attributes.equals((Object)other.attributes));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.attributes == null ? 0 : this.attributes.hashCode());
        return result;
    }

    public AttributeSet attributes() {
        return this.attributes;
    }
}

