/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.context;

import org.infinispan.commands.VisitableCommand;
import org.infinispan.commands.write.ClearCommand;
import org.infinispan.commons.equivalence.Equivalence;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.InvocationContextFactory;
import org.infinispan.context.impl.ClearInvocationContext;
import org.infinispan.interceptors.SequentialInterceptorChain;
import org.infinispan.remoting.transport.Address;

public abstract class AbstractInvocationContextFactory
implements InvocationContextFactory {
    protected Configuration config;
    protected SequentialInterceptorChain interceptorChain;
    protected Equivalence keyEq;

    public void init(Configuration config, SequentialInterceptorChain interceptorChain) {
        this.config = config;
        this.interceptorChain = interceptorChain;
        this.keyEq = config.dataContainer().keyEquivalence();
    }

    @Override
    public InvocationContext createRemoteInvocationContextForCommand(VisitableCommand cacheCommand, Address origin) {
        return cacheCommand instanceof ClearCommand ? this.createClearInvocationContext(origin) : this.createRemoteInvocationContext(origin);
    }

    @Override
    public final InvocationContext createClearNonTxInvocationContext() {
        return this.createClearInvocationContext(null);
    }

    private ClearInvocationContext createClearInvocationContext(Address origin) {
        ClearInvocationContext context = new ClearInvocationContext(origin, this.interceptorChain);
        return context;
    }
}

