/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.interceptors.distribution;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.infinispan.commands.CommandsFactory;
import org.infinispan.commands.DataCommand;
import org.infinispan.commands.FlagAffectedCommand;
import org.infinispan.commands.LocalFlagAffectedCommand;
import org.infinispan.commands.read.AbstractDataCommand;
import org.infinispan.commands.read.GetCacheEntryCommand;
import org.infinispan.commands.read.GetKeyValueCommand;
import org.infinispan.commands.write.DataWriteCommand;
import org.infinispan.commands.write.InvalidateCommand;
import org.infinispan.commands.write.InvalidateL1Command;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.commands.write.PutMapCommand;
import org.infinispan.commands.write.RemoveCommand;
import org.infinispan.commands.write.ReplaceCommand;
import org.infinispan.commons.util.CollectionFactory;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.container.DataContainer;
import org.infinispan.container.EntryFactory;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.context.Flag;
import org.infinispan.context.InvocationContext;
import org.infinispan.distribution.L1Manager;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.interceptors.distribution.L1WriteSynchronizer;
import org.infinispan.interceptors.impl.BaseRpcInterceptor;
import org.infinispan.interceptors.locking.ClusteringDependentLogic;
import org.infinispan.statetransfer.StateTransferLock;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class L1NonTxInterceptor
extends BaseRpcInterceptor {
    private static final Log log = LogFactory.getLog(L1NonTxInterceptor.class);
    private static final boolean trace = log.isTraceEnabled();
    protected L1Manager l1Manager;
    protected ClusteringDependentLogic cdl;
    protected EntryFactory entryFactory;
    protected CommandsFactory commandsFactory;
    protected DataContainer dataContainer;
    protected Configuration config;
    protected StateTransferLock stateTransferLock;
    private long l1Lifespan;
    private long replicationTimeout;
    private final ConcurrentMap<Object, L1WriteSynchronizer> concurrentWrites = CollectionFactory.makeConcurrentMap();

    @Inject
    public void init(L1Manager l1Manager, ClusteringDependentLogic cdl, EntryFactory entryFactory, DataContainer dataContainer, Configuration config, StateTransferLock stateTransferLock, CommandsFactory commandsFactory) {
        this.l1Manager = l1Manager;
        this.cdl = cdl;
        this.entryFactory = entryFactory;
        this.dataContainer = dataContainer;
        this.config = config;
        this.stateTransferLock = stateTransferLock;
        this.commandsFactory = commandsFactory;
    }

    @Start
    public void start() {
        this.l1Lifespan = this.config.clustering().l1().lifespan();
        this.replicationTimeout = this.config.clustering().remoteTimeout();
    }

    @Override
    public final CompletableFuture<Void> visitGetKeyValueCommand(InvocationContext ctx, GetKeyValueCommand command) throws Throwable {
        return this.visitDataReadCommand(ctx, command, false);
    }

    @Override
    public final CompletableFuture<Void> visitGetCacheEntryCommand(InvocationContext ctx, GetCacheEntryCommand command) throws Throwable {
        return this.visitDataReadCommand(ctx, command, true);
    }

    private CompletableFuture<Void> visitDataReadCommand(InvocationContext ctx, AbstractDataCommand command, boolean isEntry) throws Throwable {
        return this.performCommandWithL1WriteIfAble(ctx, command, isEntry, false, true);
    }

    protected CompletableFuture<Void> performCommandWithL1WriteIfAble(InvocationContext ctx, DataCommand command, boolean isEntry, boolean shouldAlwaysRunNextInterceptor, boolean registerL1) throws Throwable {
        Object returnValue;
        if (ctx.isOriginLocal()) {
            Object key = command.getKey();
            returnValue = this.skipL1Lookup(command, key) ? ctx.forkInvocationSync(command) : this.performL1Lookup(ctx, shouldAlwaysRunNextInterceptor, key, command, isEntry);
        } else {
            if (registerL1) {
                this.l1Manager.addRequestor(command.getKey(), ctx.getOrigin());
            }
            returnValue = ctx.forkInvocationSync(command);
        }
        return ctx.shortCircuit(returnValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object performL1Lookup(InvocationContext ctx, boolean runInterceptorOnConflict, Object key, DataCommand command, boolean isEntry) throws Throwable {
        L1WriteSynchronizer l1WriteSync = new L1WriteSynchronizer(this.dataContainer, this.l1Lifespan, this.stateTransferLock, this.cdl);
        L1WriteSynchronizer presentSync = this.concurrentWrites.putIfAbsent(key, l1WriteSync);
        if (presentSync == null) {
            try {
                Object returnValue;
                this.l1Manager.registerL1WriteSynchronizer(key, l1WriteSync);
                try {
                    returnValue = ctx.forkInvocationSync(command);
                }
                finally {
                    this.l1Manager.unregisterL1WriteSynchronizer(key, l1WriteSync);
                }
                Object object = returnValue;
                return object;
            }
            catch (Throwable t) {
                l1WriteSync.retrievalEncounteredException(t);
                throw t;
            }
            finally {
                this.concurrentWrites.remove(key);
            }
        }
        if (trace) {
            log.tracef("Found current request for key %s, waiting for their invocation's response", key);
        }
        try {
            Object returnValue;
            try {
                returnValue = presentSync.get(this.replicationTimeout, TimeUnit.MILLISECONDS);
                if (runInterceptorOnConflict) {
                    returnValue = ctx.forkInvocationSync(command);
                } else if (!isEntry && returnValue instanceof InternalCacheEntry) {
                    returnValue = ((InternalCacheEntry)returnValue).getValue();
                }
            }
            catch (TimeoutException e) {
                log.warnf("Synchronizer didn't return in %s milliseconds - running command normally!", this.replicationTimeout);
                returnValue = ctx.forkInvocationSync(command);
            }
            return returnValue;
        }
        catch (ExecutionException e) {
            throw e.getCause();
        }
    }

    protected boolean skipL1Lookup(LocalFlagAffectedCommand command, Object key) {
        return command.hasFlag(Flag.CACHE_MODE_LOCAL) || command.hasFlag(Flag.SKIP_REMOTE_LOOKUP) || command.hasFlag(Flag.IGNORE_RETURN_VALUES) || this.cdl.localNodeIsOwner(key) || this.dataContainer.containsKey(key);
    }

    @Override
    public CompletableFuture<Void> visitPutKeyValueCommand(InvocationContext ctx, PutKeyValueCommand command) throws Throwable {
        return this.handleDataWriteCommand(ctx, command, true);
    }

    @Override
    public CompletableFuture<Void> visitRemoveCommand(InvocationContext ctx, RemoveCommand command) throws Throwable {
        return this.handleDataWriteCommand(ctx, command, false);
    }

    @Override
    public CompletableFuture<Void> visitReplaceCommand(InvocationContext ctx, ReplaceCommand command) throws Throwable {
        return this.handleDataWriteCommand(ctx, command, true);
    }

    @Override
    public CompletableFuture<Void> visitPutMapCommand(InvocationContext ctx, PutMapCommand command) throws Throwable {
        Future<?> invalidationFuture = null;
        Set<Object> keys = command.getMap().keySet();
        HashSet<Object> toInvalidate = new HashSet<Object>(keys.size());
        for (Object k : keys) {
            if (!this.cdl.localNodeIsOwner(k)) continue;
            toInvalidate.add(k);
        }
        if (!toInvalidate.isEmpty()) {
            invalidationFuture = this.l1Manager.flushCache(toInvalidate, ctx.getOrigin(), true);
        }
        Object result = ctx.forkInvocationSync(command);
        this.processInvalidationResult(command, invalidationFuture);
        for (Object o : command.getAffectedKeys()) {
            if (this.cdl.localNodeIsOwner(o)) continue;
            this.removeFromL1(ctx, o);
        }
        return ctx.shortCircuit(result);
    }

    @Override
    public CompletableFuture<Void> visitInvalidateL1Command(InvocationContext ctx, InvalidateL1Command invalidateL1Command) throws Throwable {
        for (Object key : invalidateL1Command.getKeys()) {
            this.abortL1UpdateOrWait(key);
            if (ctx.lookupEntry(key) != null) continue;
            this.entryFactory.wrapEntryForWriting(ctx, key, EntryFactory.Wrap.WRAP_NON_NULL, true, true);
        }
        return ctx.continueInvocation();
    }

    private void abortL1UpdateOrWait(Object key) throws InterruptedException {
        L1WriteSynchronizer sync = (L1WriteSynchronizer)this.concurrentWrites.remove(key);
        if (sync != null) {
            if (sync.trySkipL1Update()) {
                if (trace) {
                    log.tracef("Aborted possible L1 update due to concurrent invalidation for key %s", key);
                }
            } else {
                boolean success;
                if (trace) {
                    log.tracef("L1 invalidation found a pending update for key %s - need to block until finished", key);
                }
                try {
                    sync.get();
                    success = true;
                }
                catch (ExecutionException e) {
                    success = false;
                }
                if (trace) {
                    log.tracef("Pending L1 update completed successfully: %b - L1 invalidation can occur for key %s", success, key);
                }
            }
        }
    }

    private CompletableFuture<Void> handleDataWriteCommand(InvocationContext ctx, DataWriteCommand command, boolean assumeOriginKeptEntryInL1) throws Throwable {
        if (command.hasFlag(Flag.CACHE_MODE_LOCAL)) {
            if (trace) {
                log.tracef("local mode forced, suppressing L1 calls.", new Object[0]);
            }
            return ctx.continueInvocation();
        }
        Future<?> l1InvalidationFuture = this.invalidateL1(ctx, command, assumeOriginKeptEntryInL1);
        Object returnValue = ctx.forkInvocationSync(command);
        this.processInvalidationResult(command, l1InvalidationFuture);
        this.removeFromLocalL1(ctx, command);
        return ctx.shortCircuit(returnValue);
    }

    private void removeFromLocalL1(InvocationContext ctx, DataWriteCommand command) throws Throwable {
        if (ctx.isOriginLocal() && !this.cdl.localNodeIsOwner(command.getKey())) {
            this.removeFromL1(ctx, command.getKey());
        } else if (trace) {
            log.trace("Allowing entry to commit as local node is owner");
        }
    }

    private void removeFromL1(InvocationContext ctx, Object key) throws Throwable {
        if (trace) {
            log.tracef("Removing entry from L1 for key %s", key);
        }
        this.abortL1UpdateOrWait(key);
        ctx.removeLookedUpEntry(key);
        this.entryFactory.wrapEntryForWriting(ctx, key, EntryFactory.Wrap.WRAP_NON_NULL, true, true);
        InvalidateCommand command = this.commandsFactory.buildInvalidateFromL1Command(0L, Collections.singleton(key));
        ctx.forkInvocationSync(command);
    }

    private void processInvalidationResult(FlagAffectedCommand command, Future<?> l1InvalidationFuture) throws InterruptedException, ExecutionException {
        if (l1InvalidationFuture != null && this.isSynchronous(command)) {
            l1InvalidationFuture.get();
        }
    }

    private Future<?> invalidateL1(InvocationContext ctx, DataWriteCommand command, boolean assumeOriginKeptEntryInL1) {
        Future<?> l1InvalidationFuture = null;
        if (this.cdl.localNodeIsOwner(command.getKey())) {
            l1InvalidationFuture = this.l1Manager.flushCache(Collections.singletonList(command.getKey()), ctx.getOrigin(), assumeOriginKeptEntryInL1);
        } else if (trace) {
            log.tracef("Not invalidating key '%s' as local node(%s) is not owner", command.getKey(), this.rpcManager.getAddress());
        }
        return l1InvalidationFuture;
    }

    @Override
    protected Log getLog() {
        return log;
    }
}

