/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.interceptors.impl;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commons.CacheException;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.SequentialInvocationContext;
import org.infinispan.interceptors.DDSequentialInterceptor;
import org.infinispan.interceptors.SequentialInterceptor;
import org.infinispan.interceptors.impl.InterceptorListNode;
import org.infinispan.interceptors.impl.SecurityActions;
import org.infinispan.util.concurrent.CompletableFutures;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.jboss.logging.NDC;

public abstract class BaseSequentialInvocationContext
implements InvocationContext,
SequentialInvocationContext {
    private static final Log log = LogFactory.getLog(BaseSequentialInvocationContext.class);
    private static final boolean trace = log.isTraceEnabled();
    private static final boolean EXTRA_LOGS = SecurityActions.getBooleanProperty("org.infinispan.debug.BaseSequentialInvocationContext");
    private static final CompletableFuture<Void> CONTINUE_INVOCATION = CompletableFuture.completedFuture(null);
    private static final int INVOKE_NEXT = 0;
    private static final int SHORT_CIRCUIT = 1;
    private static final int STOP_INVOCATION = 2;
    private static final int FORK_INVOCATION = 3;
    private static final int ON_RETURN = 4;
    private InterceptorListNode nextInterceptor;
    private ReturnHandlerNode nextReturnHandler;
    private CompletableFuture<Object> future;
    private int action;
    private Object actionValue;

    @Override
    public CompletableFuture<Void> onReturn(SequentialInterceptor.ReturnHandler returnHandler) {
        this.preActionCheck();
        this.action = 4;
        this.actionValue = returnHandler;
        return CONTINUE_INVOCATION;
    }

    @Override
    public CompletableFuture<Void> continueInvocation() {
        return CONTINUE_INVOCATION;
    }

    @Override
    public CompletableFuture<Void> shortCircuit(Object returnValue) {
        this.preActionCheck();
        this.action = 1;
        this.actionValue = returnValue;
        return CONTINUE_INVOCATION;
    }

    @Override
    public CompletableFuture<Void> forkInvocation(VisitableCommand newCommand, SequentialInterceptor.ForkReturnHandler forkReturnHandler) {
        this.preActionCheck();
        InterceptorListNode localNode = this.nextInterceptor;
        if (localNode == null) {
            throw new IllegalStateException("Cannot call shortCircuit or forkInvocation after all interceptors have executed");
        }
        this.action = 3;
        this.actionValue = new ForkInfo(newCommand, forkReturnHandler);
        return CONTINUE_INVOCATION;
    }

    private void preActionCheck() {
        if (this.action != 0) {
            throw new IllegalStateException("An interceptor can call shortCircuit, forkInvocation, or onReturn at most once. The current action is " + BaseSequentialInvocationContext.actionName(this.action));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object forkInvocationSync(VisitableCommand newCommand) throws Throwable {
        InterceptorListNode savedInterceptorNode = this.nextInterceptor;
        try {
            Object object = this.doInvokeNextSync(newCommand, savedInterceptorNode);
            return object;
        }
        finally {
            this.nextInterceptor = savedInterceptorNode;
        }
    }

    CompletableFuture<Object> invoke(VisitableCommand command, InterceptorListNode firstInterceptor) {
        this.future = new CompletableFuture();
        this.nextInterceptor = firstInterceptor;
        this.action = 0;
        this.invokeNextWithContext(command, null, null);
        return this.future;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invokeNextWithContext(VisitableCommand command, Object returnValue, Throwable throwable) {
        Object lockOwner = this.getLockOwner();
        if (lockOwner != null) {
            NDC.push((String)lockOwner.toString());
        }
        try {
            this.invokeNext(command, returnValue, throwable);
        }
        finally {
            NDC.pop();
        }
    }

    private void invokeNext(VisitableCommand command, Object returnValue, Throwable throwable) {
        InterceptorListNode interceptorNode = this.nextInterceptor;
        while (true) {
            SequentialInterceptor.ReturnHandler returnHandler;
            if (this.action == 3) {
                ForkInfo forkInfo = (ForkInfo)this.actionValue;
                forkInfo.savedInterceptor = interceptorNode;
                forkInfo.savedCommand = command;
                command = forkInfo.newCommand;
                this.nextReturnHandler = new ReturnHandlerNode(forkInfo, this.nextReturnHandler);
            } else {
                if (this.action == 2) {
                    this.action = 0;
                    return;
                }
                if (this.action == 1) {
                    returnValue = this.actionValue;
                    interceptorNode = null;
                    this.nextInterceptor = null;
                } else if (this.action == 4) {
                    this.action = 0;
                    returnHandler = (SequentialInterceptor.ReturnHandler)this.actionValue;
                    this.nextReturnHandler = new ReturnHandlerNode(returnHandler, this.nextReturnHandler);
                }
            }
            this.action = 0;
            if (interceptorNode != null) {
                SequentialInterceptor interceptor = interceptorNode.interceptor;
                this.nextInterceptor = interceptorNode = interceptorNode.nextNode;
                if (EXTRA_LOGS && trace) {
                    log.tracef("Executing interceptor %s with command %s", BaseSequentialInvocationContext.className(interceptor), BaseSequentialInvocationContext.className(command));
                }
                try {
                    CompletableFuture<Void> nextFuture = interceptor.visitCommand(this, command);
                    if (nextFuture == null) {
                        throw new IllegalStateException(interceptor.getClass() + ".visitCommand() must not return null");
                    }
                    if (nextFuture.isDone()) {
                        returnValue = nextFuture.getNow(null);
                    }
                    if (EXTRA_LOGS && trace) {
                        log.tracef("Interceptor %s continues asynchronously", interceptor);
                    }
                    VisitableCommand finalCommand = command;
                    nextFuture.whenComplete((rv1, throwable1) -> this.invokeNextWithContext(finalCommand, rv1, (Throwable)throwable1));
                    return;
                }
                catch (Throwable t) {
                    throwable = t;
                    if (t instanceof CompletionException) {
                        throwable = t.getCause();
                    }
                    if (trace) {
                        log.tracef("Interceptor %s threw exception %s", BaseSequentialInvocationContext.className(interceptor), throwable);
                    }
                    this.action = 0;
                    interceptorNode = null;
                    this.nextInterceptor = null;
                }
                continue;
            }
            if (this.nextReturnHandler == null) break;
            returnHandler = this.nextReturnHandler.returnHandler;
            this.nextReturnHandler = this.nextReturnHandler.nextNode;
            if (EXTRA_LOGS && trace) {
                log.tracef("Executing return handler %s, returning %s/%s", new Object[]{this.nextReturnHandler, returnHandler, BaseSequentialInvocationContext.className(returnValue), throwable});
            }
            try {
                CompletableFuture<Object> handlerFuture = returnHandler.handle(this, command, returnValue, throwable);
                if (handlerFuture == null) continue;
                if (handlerFuture.isDone()) {
                    returnValue = handlerFuture.getNow(returnValue);
                    throwable = null;
                    interceptorNode = this.nextInterceptor;
                    continue;
                }
                if (EXTRA_LOGS && trace) {
                    log.tracef("Return handler %s continues asynchronously", returnHandler);
                }
                VisitableCommand finalCommand1 = command;
                handlerFuture.whenComplete((rv1, throwable1) -> this.invokeNextWithContext(finalCommand1, rv1, (Throwable)throwable1));
                return;
            }
            catch (Throwable t) {
                if (trace) {
                    log.tracef("Return handler %s threw exception %s", BaseSequentialInvocationContext.className(returnHandler), t);
                }
                returnValue = null;
                throwable = t;
                interceptorNode = null;
                this.nextInterceptor = null;
                continue;
            }
            break;
        }
        if (EXTRA_LOGS && trace) {
            log.tracef("Command %s done, returning %s/%s", command, BaseSequentialInvocationContext.className(returnValue), throwable);
        }
        BaseSequentialInvocationContext.completeFuture(this.future, returnValue, throwable);
    }

    private CompletableFuture<Object> handleForkReturn(ForkInfo forkInfo, Object returnValue, Throwable throwable) throws Throwable {
        if (EXTRA_LOGS && trace) {
            log.tracef("Forked command %s done for interceptor %s, returning %s/%s", new Object[]{forkInfo.newCommand, BaseSequentialInvocationContext.className(forkInfo.savedInterceptor.interceptor), BaseSequentialInvocationContext.className(returnValue), throwable});
        }
        this.nextInterceptor = forkInfo.savedInterceptor;
        CompletableFuture<Object> handlerFuture = forkInfo.forkReturnHandler.handle(this, forkInfo.savedCommand, returnValue, throwable);
        return handlerFuture;
    }

    Object invokeSync(VisitableCommand command, InterceptorListNode firstInterceptor) throws Throwable {
        this.future = null;
        this.nextInterceptor = firstInterceptor;
        this.action = 0;
        return this.doInvokeNextSync(command, firstInterceptor);
    }

    private Object doInvokeNextSync(VisitableCommand command, InterceptorListNode interceptorNode) throws Throwable {
        SequentialInterceptor interceptor = interceptorNode.interceptor;
        this.nextInterceptor = interceptorNode.nextNode;
        CompletableFuture nextVisitFuture = interceptor instanceof DDSequentialInterceptor ? (CompletableFuture)command.acceptVisitor(this, (DDSequentialInterceptor)interceptor) : interceptor.visitCommand(this, command);
        if (!nextVisitFuture.isDone()) {
            CompletableFutures.await(nextVisitFuture);
        }
        return this.handleActionSync(command, interceptorNode);
    }

    private Object handleActionSync(VisitableCommand command, InterceptorListNode interceptorNode) throws Throwable {
        if (EXTRA_LOGS && trace) {
            log.tracef("Handling action %s/%s from %s", BaseSequentialInvocationContext.actionName(this.action), BaseSequentialInvocationContext.className(this.actionValue), BaseSequentialInvocationContext.className(interceptorNode.interceptor));
        }
        if (this.action == 1) {
            this.action = 0;
            return this.actionValue;
        }
        if (this.action == 0) {
            return this.doInvokeNextSync(command, interceptorNode.nextNode);
        }
        if (this.action == 3) {
            this.action = 0;
            ForkInfo forkInfo = (ForkInfo)this.actionValue;
            return this.handleForkActionSync(forkInfo, interceptorNode.nextNode);
        }
        if (this.action == 4) {
            this.action = 0;
            return this.handleOnReturnActionSync(command, interceptorNode.nextNode);
        }
        throw new IllegalStateException("Illegal action type: " + this.action);
    }

    private Object handleOnReturnActionSync(VisitableCommand command, InterceptorListNode interceptorNode) throws Throwable {
        SequentialInterceptor.ReturnHandler returnHandler = (SequentialInterceptor.ReturnHandler)this.actionValue;
        Object returnValue = null;
        Throwable throwable = null;
        try {
            returnValue = this.doInvokeNextSync(command, interceptorNode);
        }
        catch (Throwable t) {
            throwable = t;
        }
        CompletableFuture<Object> handlerFuture = returnHandler.handle(this, command, returnValue, throwable);
        if (handlerFuture != null) {
            return CompletableFutures.await(handlerFuture);
        }
        if (throwable != null) {
            throw throwable;
        }
        return returnValue;
    }

    private Object handleForkActionSync(ForkInfo forkInfo, InterceptorListNode interceptorNode) throws Throwable {
        Object returnValue = null;
        Throwable throwable = null;
        try {
            returnValue = this.forkInvocationSync(forkInfo.newCommand);
        }
        catch (Throwable t) {
            throwable = t;
        }
        CompletableFuture<Void> handlerFuture = forkInfo.forkReturnHandler.handle(this, forkInfo.savedCommand, returnValue, throwable);
        if (!handlerFuture.isDone()) {
            CompletableFutures.await(handlerFuture);
        }
        return this.handleActionSync(forkInfo.savedCommand, interceptorNode);
    }

    private static <T, E extends Throwable> void completeFuture(CompletableFuture<T> future, T returnValue, E exception) {
        if (exception == null) {
            future.complete(returnValue);
        } else {
            future.completeExceptionally(exception);
        }
    }

    private static String className(Object o) {
        return o == null ? "null" : o.getClass().getName();
    }

    private static String actionName(int action) {
        switch (action) {
            case 0: {
                return "INVOKE_NEXT";
            }
            case 1: {
                return "SHORT_CIRCUIT";
            }
            case 2: {
                return "STOP_INVOCATION";
            }
            case 3: {
                return "FORK_INVOCATION";
            }
            case 4: {
                return "ON_RETURN";
            }
        }
        return "Unknown action " + action;
    }

    @Override
    public InvocationContext clone() {
        try {
            BaseSequentialInvocationContext clone = (BaseSequentialInvocationContext)super.clone();
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new CacheException("Impossible");
        }
    }

    private static class ReturnHandlerNode {
        final SequentialInterceptor.ReturnHandler returnHandler;
        final ReturnHandlerNode nextNode;

        ReturnHandlerNode(SequentialInterceptor.ReturnHandler returnHandler, ReturnHandlerNode next) {
            this.returnHandler = returnHandler;
            this.nextNode = next;
        }
    }

    private static class ForkInfo
    implements SequentialInterceptor.ReturnHandler {
        final VisitableCommand newCommand;
        final SequentialInterceptor.ForkReturnHandler forkReturnHandler;
        InterceptorListNode savedInterceptor;
        VisitableCommand savedCommand;

        public ForkInfo(VisitableCommand newCommand, SequentialInterceptor.ForkReturnHandler forkReturnHandler) {
            this.newCommand = newCommand;
            this.forkReturnHandler = forkReturnHandler;
        }

        public String toString() {
            return "ForkInfo{" + this.newCommand.getClass().getSimpleName() + "}";
        }

        @Override
        public CompletableFuture<Object> handle(InvocationContext ctx, VisitableCommand command, Object rv, Throwable throwable) throws Throwable {
            return ((BaseSequentialInvocationContext)ctx).handleForkReturn(this, rv, throwable);
        }
    }
}

