/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.interceptors.impl;

import java.util.concurrent.CompletableFuture;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.infinispan.batch.BatchContainer;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commands.write.EvictCommand;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.InvocationContextFactory;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.interceptors.DDSequentialInterceptor;
import org.infinispan.interceptors.SequentialInterceptorChain;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class BatchingInterceptor
extends DDSequentialInterceptor {
    private BatchContainer batchContainer;
    private TransactionManager transactionManager;
    private InvocationContextFactory invocationContextFactory;
    private SequentialInterceptorChain invoker;
    private static final Log log = LogFactory.getLog(BatchingInterceptor.class);

    @Inject
    private void inject(BatchContainer batchContainer, TransactionManager transactionManager, InvocationContextFactory invocationContextFactory, SequentialInterceptorChain invoker) {
        this.batchContainer = batchContainer;
        this.transactionManager = transactionManager;
        this.invocationContextFactory = invocationContextFactory;
        this.invoker = invoker;
    }

    @Override
    public CompletableFuture<Void> visitEvictCommand(InvocationContext ctx, EvictCommand command) throws Throwable {
        return ctx.continueInvocation();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<Void> handleDefault(InvocationContext ctx, VisitableCommand command) throws Throwable {
        Transaction tx;
        if (!ctx.isOriginLocal()) {
            return ctx.continueInvocation();
        }
        if (this.transactionManager.getTransaction() != null || (tx = this.batchContainer.getBatchTransaction()) == null) {
            return ctx.continueInvocation();
        }
        try {
            this.transactionManager.resume(tx);
            InvocationContext txInvocationContext = ctx;
            if (!ctx.isInTxScope()) {
                log.tracef("Called with a non-tx invocation context: %s", ctx);
                txInvocationContext = this.invocationContextFactory.createInvocationContext(true, -1);
            }
            CompletableFuture<Void> completableFuture = ctx.shortCircuit(this.invoker.invoke(txInvocationContext, command));
            return completableFuture;
        }
        finally {
            if (this.transactionManager.getTransaction() != null && this.batchContainer.isSuspendTxAfterInvocation()) {
                this.transactionManager.suspend();
            }
        }
    }
}

