/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.interceptors.impl;

import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.infinispan.commands.FlagAffectedCommand;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commands.control.LockControlCommand;
import org.infinispan.commands.read.GetAllCommand;
import org.infinispan.commands.read.GetCacheEntryCommand;
import org.infinispan.commands.read.GetKeyValueCommand;
import org.infinispan.commands.tx.CommitCommand;
import org.infinispan.commands.tx.PrepareCommand;
import org.infinispan.commands.tx.RollbackCommand;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.context.Flag;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.impl.TxInvocationContext;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.interceptors.DDSequentialInterceptor;
import org.infinispan.notifications.cachelistener.CacheNotifier;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class CallInterceptor
extends DDSequentialInterceptor {
    private static final Log log = LogFactory.getLog(CallInterceptor.class);
    private static final boolean trace = log.isTraceEnabled();
    private CacheNotifier notifier;

    @Inject
    public void inject(CacheNotifier notifier) {
        this.notifier = notifier;
    }

    @Override
    public CompletableFuture<Void> visitPrepareCommand(TxInvocationContext ctx, PrepareCommand command) throws Throwable {
        if (trace) {
            log.trace("Suppressing invocation of method handlePrepareCommand.");
        }
        return ctx.shortCircuit(null);
    }

    @Override
    public CompletableFuture<Void> visitCommitCommand(TxInvocationContext ctx, CommitCommand command) throws Throwable {
        if (trace) {
            log.trace("Suppressing invocation of method handleCommitCommand.");
        }
        return ctx.shortCircuit(null);
    }

    @Override
    public CompletableFuture<Void> visitRollbackCommand(TxInvocationContext ctx, RollbackCommand command) throws Throwable {
        if (trace) {
            log.trace("Suppressing invocation of method handleRollbackCommand.");
        }
        return ctx.shortCircuit(null);
    }

    @Override
    public CompletableFuture<Void> visitLockControlCommand(TxInvocationContext ctx, LockControlCommand c) throws Throwable {
        if (trace) {
            log.trace("Suppressing invocation of method handleLockControlCommand.");
        }
        return ctx.shortCircuit(null);
    }

    @Override
    public CompletableFuture<Void> visitGetKeyValueCommand(InvocationContext ctx, GetKeyValueCommand command) throws Throwable {
        Object ret;
        if (trace) {
            log.trace("Executing command: " + command + ".");
        }
        if ((ret = command.perform(ctx)) != null) {
            this.notifyCacheEntryVisit(ctx, command, command.getKey(), ret);
        }
        return ctx.shortCircuit(ret);
    }

    @Override
    public CompletableFuture<Void> visitGetCacheEntryCommand(InvocationContext ctx, GetCacheEntryCommand command) throws Throwable {
        Object ret;
        if (trace) {
            log.trace("Executing command: " + command + ".");
        }
        if ((ret = command.perform(ctx)) != null) {
            this.notifyCacheEntryVisit(ctx, command, command.getKey(), ((CacheEntry)ret).getValue());
        }
        return ctx.shortCircuit(ret);
    }

    @Override
    public CompletableFuture<Void> visitGetAllCommand(InvocationContext ctx, GetAllCommand command) throws Throwable {
        Object ret;
        if (trace) {
            log.trace("Executing command: " + command + ".");
        }
        if ((ret = command.perform(ctx)) != null) {
            Map map = (Map)ret;
            if (command.getFlags() == null || !command.getFlags().contains((Object)Flag.SKIP_LISTENER_NOTIFICATION)) {
                for (Map.Entry entry : map.entrySet()) {
                    Object value = entry.getValue();
                    if (value == null) continue;
                    value = command.isReturnEntries() ? ((CacheEntry)value).getValue() : entry.getValue();
                    this.notifyCacheEntryVisit(ctx, command, entry.getKey(), value);
                }
            }
        }
        return ctx.shortCircuit(ret);
    }

    private void notifyCacheEntryVisit(InvocationContext ctx, FlagAffectedCommand command, Object key, Object value) {
        this.notifier.notifyCacheEntryVisited(key, value, true, ctx, command);
        this.notifier.notifyCacheEntryVisited(key, value, false, ctx, command);
    }

    @Override
    public final CompletableFuture<Void> handleDefault(InvocationContext ctx, VisitableCommand command) throws Throwable {
        if (trace) {
            log.trace("Executing command: " + command + ".");
        }
        return ctx.shortCircuit(command.perform(ctx));
    }
}

