/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.topology;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.util.Immutables;
import org.infinispan.distribution.ch.ConsistentHash;
import org.infinispan.distribution.ch.ConsistentHashFactory;
import org.infinispan.globalstate.ScopedPersistentState;
import org.infinispan.lifecycle.ComponentStatus;
import org.infinispan.partitionhandling.AvailabilityMode;
import org.infinispan.partitionhandling.impl.AvailabilityStrategy;
import org.infinispan.partitionhandling.impl.AvailabilityStrategyContext;
import org.infinispan.remoting.transport.Address;
import org.infinispan.remoting.transport.Transport;
import org.infinispan.topology.CacheJoinInfo;
import org.infinispan.topology.CacheStatusResponse;
import org.infinispan.topology.CacheTopology;
import org.infinispan.topology.ClusterTopologyManager;
import org.infinispan.topology.PersistentUUIDManager;
import org.infinispan.topology.RebalanceConfirmationCollector;
import org.infinispan.topology.RebalancingStatus;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class ClusterCacheStatus
implements AvailabilityStrategyContext {
    private static final Log log = LogFactory.getLog(ClusterCacheStatus.class);
    private static boolean trace = log.isTraceEnabled();
    private final String cacheName;
    private final AvailabilityStrategy availabilityStrategy;
    private final ClusterTopologyManager clusterTopologyManager;
    private final PersistentUUIDManager persistentUUIDManager;
    private Transport transport;
    private volatile CacheJoinInfo joinInfo;
    private volatile List<Address> expectedMembers;
    private volatile Map<Address, Float> capacityFactors;
    private volatile List<Address> joiners;
    private Optional<ScopedPersistentState> persistentState;
    private volatile CacheTopology currentTopology;
    private volatile CacheTopology stableTopology;
    private volatile AvailabilityMode availabilityMode = AvailabilityMode.AVAILABLE;
    private volatile List<Address> queuedRebalanceMembers;
    private volatile boolean rebalancingEnabled = true;
    private volatile RebalanceConfirmationCollector rebalanceConfirmationCollector;
    private ComponentStatus status;

    public ClusterCacheStatus(String cacheName, AvailabilityStrategy availabilityStrategy, ClusterTopologyManager clusterTopologyManager, Transport transport, Optional<ScopedPersistentState> state, PersistentUUIDManager persistentUUIDManager) {
        this.cacheName = cacheName;
        this.availabilityStrategy = availabilityStrategy;
        this.clusterTopologyManager = clusterTopologyManager;
        this.transport = transport;
        this.persistentState = state;
        this.currentTopology = null;
        this.stableTopology = null;
        this.expectedMembers = Collections.emptyList();
        this.capacityFactors = Collections.emptyMap();
        this.joiners = Collections.emptyList();
        this.persistentUUIDManager = persistentUUIDManager;
        state.ifPresent(scopedPersistentState -> {
            this.rebalancingEnabled = false;
            this.availabilityMode = AvailabilityMode.DEGRADED_MODE;
        });
        this.status = ComponentStatus.INSTANTIATED;
        if (trace) {
            log.tracef("Cache %s initialized", cacheName);
        }
    }

    public CacheJoinInfo getJoinInfo() {
        return this.joinInfo;
    }

    @Override
    public List<Address> getExpectedMembers() {
        return this.expectedMembers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void queueRebalance(List<Address> newMembers) {
        ClusterCacheStatus clusterCacheStatus = this;
        synchronized (clusterCacheStatus) {
            if (newMembers != null && !newMembers.isEmpty()) {
                log.debugf("Queueing rebalance for cache %s with members %s", this.cacheName, newMembers);
                this.queuedRebalanceMembers = newMembers;
                this.startQueuedRebalance();
            }
        }
    }

    public boolean isTotalOrder() {
        return this.joinInfo.isTotalOrder();
    }

    public boolean isDistributed() {
        return this.joinInfo.isDistributed();
    }

    public Map<Address, Float> getCapacityFactors() {
        return this.capacityFactors;
    }

    @Override
    public CacheTopology getCurrentTopology() {
        return this.currentTopology;
    }

    @Override
    public CacheTopology getStableTopology() {
        return this.stableTopology;
    }

    @Override
    public AvailabilityMode getAvailabilityMode() {
        return this.availabilityMode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateAvailabilityMode(List<Address> actualMembers, AvailabilityMode newAvailabilityMode, boolean cancelRebalance) {
        ClusterCacheStatus clusterCacheStatus = this;
        synchronized (clusterCacheStatus) {
            boolean modeChanged = this.setAvailabilityMode(newAvailabilityMode);
            if (modeChanged || !actualMembers.equals(this.currentTopology.getActualMembers())) {
                log.debugf("Updating availability for cache %s to %s", this.cacheName, (Object)newAvailabilityMode);
                ConsistentHash newPendingCH = this.currentTopology.getPendingCH();
                if (cancelRebalance) {
                    newPendingCH = null;
                    if (this.isRebalanceInProgress()) {
                        this.removeRebalanceConfirmationCollector();
                    }
                }
                CacheTopology newTopology = new CacheTopology(this.currentTopology.getTopologyId() + 1, this.currentTopology.getRebalanceId(), this.currentTopology.getCurrentCH(), newPendingCH, actualMembers, this.persistentUUIDManager.mapAddresses(actualMembers));
                this.setCurrentTopology(newTopology);
                this.clusterTopologyManager.broadcastTopologyUpdate(this.cacheName, newTopology, newAvailabilityMode, this.isTotalOrder(), this.isDistributed());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateTopologiesAfterMerge(CacheTopology currentTopology, CacheTopology stableTopology, AvailabilityMode availabilityMode) {
        ClusterCacheStatus clusterCacheStatus = this;
        synchronized (clusterCacheStatus) {
            log.debugf("Updating topologies after merge for cache %s, current topology = %s, stable topology = %s, availability mode = %s", new Object[]{this.cacheName, currentTopology, stableTopology, availabilityMode});
            this.currentTopology = currentTopology;
            this.stableTopology = stableTopology;
            this.availabilityMode = availabilityMode;
            if (currentTopology != null) {
                this.clusterTopologyManager.broadcastTopologyUpdate(this.cacheName, currentTopology, availabilityMode, this.isTotalOrder(), this.isDistributed());
            }
            if (stableTopology != null) {
                this.clusterTopologyManager.broadcastStableTopologyUpdate(this.cacheName, stableTopology, this.isTotalOrder(), this.isDistributed());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean addMember(Address joiner, CacheJoinInfo joinInfo) {
        ClusterCacheStatus clusterCacheStatus = this;
        synchronized (clusterCacheStatus) {
            if (this.expectedMembers.contains(joiner)) {
                return false;
            }
            if (this.persistentState.isPresent()) {
                if (!joinInfo.getPersistentStateChecksum().isPresent()) {
                    if (this.status == ComponentStatus.INSTANTIATED) {
                        throw log.nodeWithoutPersistentStateJoiningCacheWithState(joiner, this.cacheName);
                    }
                } else if (this.persistentState.get().getChecksum() != joinInfo.getPersistentStateChecksum().get().intValue()) {
                    throw log.nodeWithIncompatibleStateJoiningCache(joiner, this.cacheName);
                }
            } else if (joinInfo.getPersistentStateChecksum().isPresent()) {
                throw log.nodeWithPersistentStateJoiningClusterWithoutState(joiner, this.cacheName);
            }
            if (this.joinInfo == null) {
                this.joinInfo = joinInfo;
            }
            HashMap<Address, Float> newCapacityFactors = new HashMap<Address, Float>(this.capacityFactors);
            newCapacityFactors.put(joiner, Float.valueOf(joinInfo.getCapacityFactor()));
            this.capacityFactors = Immutables.immutableMapWrap(newCapacityFactors);
            this.expectedMembers = this.immutableAdd(this.expectedMembers, joiner);
            this.persistentUUIDManager.addPersistentAddressMapping(joiner, joinInfo.getPersistentUUID());
            this.joiners = this.immutableAdd(this.joiners, joiner);
            if (trace) {
                log.tracef("Added joiner %s to cache %s with persistent uuid %s: members = %s, joiners = %s", new Object[]{joiner, this.cacheName, joinInfo.getPersistentUUID(), this.expectedMembers, this.joiners});
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean removeMember(Address leaver) {
        ClusterCacheStatus clusterCacheStatus = this;
        synchronized (clusterCacheStatus) {
            if (!this.expectedMembers.contains(leaver)) {
                if (trace) {
                    log.tracef("Trying to remove node %s from cache %s, but it is not a member: members = %s", leaver, this.cacheName, this.expectedMembers);
                }
                return false;
            }
            this.expectedMembers = this.immutableRemove(this.expectedMembers, leaver);
            HashMap<Address, Float> newCapacityFactors = new HashMap<Address, Float>(this.capacityFactors);
            newCapacityFactors.remove(leaver);
            this.capacityFactors = Immutables.immutableMapWrap(newCapacityFactors);
            this.joiners = this.immutableRemove(this.joiners, leaver);
            if (trace) {
                log.tracef("Removed node %s from cache %s: members = %s, joiners = %s", new Object[]{leaver, this.cacheName, this.expectedMembers, this.joiners});
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean retainMembers(List<Address> newClusterMembers) {
        ClusterCacheStatus clusterCacheStatus = this;
        synchronized (clusterCacheStatus) {
            if (newClusterMembers.containsAll(this.expectedMembers)) {
                if (trace) {
                    log.tracef("Cluster members updated for cache %s, no abrupt leavers detected: cache members = %s. Existing members = %s", this.cacheName, newClusterMembers, this.expectedMembers);
                }
                return false;
            }
            this.expectedMembers = this.immutableRetainAll(this.expectedMembers, newClusterMembers);
            this.joiners = this.immutableRetainAll(this.joiners, newClusterMembers);
            if (trace) {
                log.tracef("Cluster members updated for cache %s: members = %s, joiners = %s", this.cacheName, this.expectedMembers, this.joiners);
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setCurrentTopology(CacheTopology newTopology) {
        ClusterCacheStatus clusterCacheStatus = this;
        synchronized (clusterCacheStatus) {
            this.currentTopology = newTopology;
            if (newTopology != null) {
                this.joiners = this.immutableRemoveAll(this.expectedMembers, newTopology.getCurrentCH().getMembers());
            }
            if (trace) {
                log.tracef("Cache %s topology updated: %s, members = %s, joiners = %s", new Object[]{this.cacheName, this.currentTopology, this.expectedMembers, this.joiners});
            }
            if (newTopology != null) {
                newTopology.logRoutingTableInformation();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setStableTopology(CacheTopology newTopology) {
        ClusterCacheStatus clusterCacheStatus = this;
        synchronized (clusterCacheStatus) {
            this.stableTopology = newTopology;
            if (trace) {
                log.tracef("Cache %s stable topology updated: members = %s, joiners = %s, topology = %s", new Object[]{this.cacheName, this.expectedMembers, this.joiners, newTopology});
            }
        }
    }

    private boolean needConsistentHashUpdate() {
        return !this.expectedMembers.equals(this.currentTopology.getMembers());
    }

    private List<Address> pruneInvalidMembers(List<Address> possibleMembers) {
        return this.immutableRetainAll(possibleMembers, this.expectedMembers);
    }

    public boolean isRebalanceInProgress() {
        return this.rebalanceConfirmationCollector != null;
    }

    public RebalancingStatus getRebalancingStatus() {
        if (!this.isRebalanceEnabled()) {
            return RebalancingStatus.SUSPENDED;
        }
        if (this.isRebalanceInProgress()) {
            return RebalancingStatus.IN_PROGRESS;
        }
        if (this.queuedRebalanceMembers != null) {
            return RebalancingStatus.PENDING;
        }
        return RebalancingStatus.COMPLETE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean initRebalanceConfirmationCollector(CacheTopology newTopology) {
        ClusterCacheStatus clusterCacheStatus = this;
        synchronized (clusterCacheStatus) {
            if (this.rebalanceConfirmationCollector != null) {
                return false;
            }
            this.rebalanceConfirmationCollector = new RebalanceConfirmationCollector(this.cacheName, newTopology.getTopologyId(), newTopology.getMembers());
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doConfirmRebalance(Address member, int receivedTopologyId) throws Exception {
        ClusterCacheStatus clusterCacheStatus = this;
        synchronized (clusterCacheStatus) {
            if (this.rebalanceConfirmationCollector == null) {
                throw new CacheException(String.format("Received invalid rebalance confirmation from %s for cache %s, we don't have a rebalance in progress", member, this.cacheName));
            }
            boolean rebalanceCompleted = this.rebalanceConfirmationCollector.confirmRebalance(member, receivedTopologyId);
            if (rebalanceCompleted) {
                this.endRebalance();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean updateRebalanceMembers() {
        ClusterCacheStatus clusterCacheStatus = this;
        synchronized (clusterCacheStatus) {
            if (this.rebalanceConfirmationCollector == null) {
                return false;
            }
            return this.rebalanceConfirmationCollector.updateMembers(this.currentTopology.getMembers());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doHandleClusterView() throws Exception {
        ClusterCacheStatus clusterCacheStatus = this;
        synchronized (clusterCacheStatus) {
            boolean rebalanceCompleted;
            if (this.currentTopology == null) {
                return;
            }
            List<Address> newClusterMembers = this.transport.getMembers();
            boolean cacheMembersModified = this.retainMembers(newClusterMembers);
            this.availabilityStrategy.onClusterViewChange(this, newClusterMembers);
            if (cacheMembersModified && (rebalanceCompleted = this.updateRebalanceMembers())) {
                this.endRebalance();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void endRebalance() {
        ClusterCacheStatus clusterCacheStatus = this;
        synchronized (clusterCacheStatus) {
            this.removeRebalanceConfirmationCollector();
            CacheTopology currentTopology = this.getCurrentTopology();
            if (currentTopology == null) {
                log.tracef("Rebalance finished because there are no more members in cache %s", this.cacheName);
                return;
            }
            int currentTopologyId = currentTopology.getTopologyId();
            LogFactory.CLUSTER.clusterWideRebalanceCompleted(this.cacheName, currentTopologyId);
            int newTopologyId = currentTopologyId + 1;
            ConsistentHash newCurrentCH = currentTopology.getPendingCH();
            CacheTopology newTopology = new CacheTopology(newTopologyId, currentTopology.getRebalanceId(), newCurrentCH, null, newCurrentCH.getMembers(), this.persistentUUIDManager.mapAddresses(newCurrentCH.getMembers()));
            this.setCurrentTopology(newTopology);
            this.clusterTopologyManager.broadcastTopologyUpdate(this.cacheName, newTopology, this.availabilityMode, this.isTotalOrder(), this.isDistributed());
            this.availabilityStrategy.onRebalanceEnd(this);
            this.startQueuedRebalance();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeRebalanceConfirmationCollector() {
        ClusterCacheStatus clusterCacheStatus = this;
        synchronized (clusterCacheStatus) {
            if (this.rebalanceConfirmationCollector == null) {
                throw new IllegalStateException("Can't end rebalance, there is no rebalance in progress");
            }
            this.rebalanceConfirmationCollector = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateCurrentTopology(List<Address> newMembers) {
        ClusterCacheStatus clusterCacheStatus = this;
        synchronized (clusterCacheStatus) {
            ConsistentHash newCurrentCH;
            List<Address> actualMembers;
            if (this.currentTopology == null) {
                this.createInitialCacheTopology();
            }
            ConsistentHashFactory consistentHashFactory = this.getJoinInfo().getConsistentHashFactory();
            int topologyId = this.currentTopology.getTopologyId();
            int rebalanceId = this.currentTopology.getRebalanceId();
            ConsistentHash currentCH = this.currentTopology.getCurrentCH();
            ConsistentHash pendingCH = this.currentTopology.getPendingCH();
            if (!this.needConsistentHashUpdate()) {
                log.tracef("Cache %s members list was updated, but the cache topology doesn't need to change: %s", this.cacheName, this.currentTopology);
                return;
            }
            if (newMembers.isEmpty()) {
                log.tracef("Cache %s no longer has any members, removing topology", this.cacheName);
                this.setCurrentTopology(null);
                this.setStableTopology(null);
                if (this.isRebalanceInProgress()) {
                    this.removeRebalanceConfirmationCollector();
                }
                return;
            }
            List<Address> newCurrentMembers = this.pruneInvalidMembers(currentCH.getMembers());
            ConsistentHash newPendingCH = null;
            if (newCurrentMembers.isEmpty()) {
                log.tracef("All current members left, re-initializing status for cache %s", this.cacheName);
                if (this.isRebalanceInProgress()) {
                    this.removeRebalanceConfirmationCollector();
                }
                actualMembers = newCurrentMembers = this.getExpectedMembers();
                newCurrentCH = this.joinInfo.getConsistentHashFactory().create(this.joinInfo.getHashFunction(), this.joinInfo.getNumOwners(), this.joinInfo.getNumSegments(), newCurrentMembers, this.getCapacityFactors());
            } else {
                newCurrentCH = consistentHashFactory.updateMembers(currentCH, newCurrentMembers, this.getCapacityFactors());
                actualMembers = newCurrentMembers;
                if (pendingCH != null) {
                    List<Address> newPendingMembers = this.pruneInvalidMembers(pendingCH.getMembers());
                    newPendingCH = consistentHashFactory.updateMembers(pendingCH, newPendingMembers, this.getCapacityFactors());
                    actualMembers = newPendingMembers;
                }
            }
            CacheTopology newTopology = new CacheTopology(topologyId + 1, rebalanceId, newCurrentCH, newPendingCH, actualMembers, this.persistentUUIDManager.mapAddresses(actualMembers));
            this.setCurrentTopology(newTopology);
            this.clusterTopologyManager.broadcastTopologyUpdate(this.cacheName, newTopology, this.availabilityMode, this.isTotalOrder(), this.isDistributed());
        }
    }

    private boolean setAvailabilityMode(AvailabilityMode newAvailabilityMode) {
        if (newAvailabilityMode == this.availabilityMode) {
            return false;
        }
        log.tracef("Cache %s availability changed: %s -> %s", this.cacheName, (Object)this.availabilityMode, (Object)newAvailabilityMode);
        this.availabilityMode = newAvailabilityMode;
        return true;
    }

    private <T> List<T> immutableAdd(List<T> list, T element) {
        ArrayList<T> result = new ArrayList<T>(list);
        result.add(element);
        return Collections.unmodifiableList(result);
    }

    private <T> List<T> immutableRemove(List<T> list, T element) {
        ArrayList<T> result = new ArrayList<T>(list);
        result.remove(element);
        return Collections.unmodifiableList(result);
    }

    private <T> List<T> immutableRemoveAll(List<T> list, List<T> otherList) {
        ArrayList<T> result = new ArrayList<T>(list);
        result.removeAll(otherList);
        return Collections.unmodifiableList(result);
    }

    private <T> List<T> immutableRetainAll(List<T> list, List<T> otherList) {
        ArrayList<T> result = new ArrayList<T>(list);
        result.retainAll(otherList);
        return Collections.unmodifiableList(result);
    }

    public String toString() {
        return "ClusterCacheStatus{cacheName='" + this.cacheName + '\'' + ", members=" + this.expectedMembers + ", joiners=" + this.joiners + ", currentTopology=" + this.currentTopology + ", rebalanceConfirmationCollector=" + this.rebalanceConfirmationCollector + '}';
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doMergePartitions(Map<Address, CacheStatusResponse> statusResponses, List<Address> clusterMembers, boolean isMergeView) throws Exception {
        ClusterCacheStatus clusterCacheStatus = this;
        synchronized (clusterCacheStatus) {
            if (statusResponses.isEmpty()) {
                throw new IllegalArgumentException("Should have at least one current topology");
            }
            try {
                HashMap<Address, CacheJoinInfo> joinInfos = new HashMap<Address, CacheJoinInfo>();
                HashSet<CacheTopology> currentTopologies = new HashSet<CacheTopology>();
                HashSet<CacheTopology> stableTopologies = new HashSet<CacheTopology>();
                for (Map.Entry<Address, CacheStatusResponse> e : statusResponses.entrySet()) {
                    Address sender = e.getKey();
                    CacheStatusResponse response = e.getValue();
                    joinInfos.put(sender, response.getCacheJoinInfo());
                    if (response.getCacheTopology() != null) {
                        currentTopologies.add(response.getCacheTopology());
                    }
                    if (response.getStableTopology() == null) continue;
                    stableTopologies.add(response.getStableTopology());
                }
                log.debugf("Recovered %d partition(s) for cache %s: %s", currentTopologies.size(), this.cacheName, currentTopologies);
                this.recoverMembers(joinInfos, currentTopologies, stableTopologies);
                this.availabilityStrategy.onPartitionMerge(this, statusResponses.values());
            }
            catch (Exception e) {
                log.failedToRecoverCacheState(this.cacheName, e);
            }
        }
    }

    private void recoverMembers(Map<Address, CacheJoinInfo> joinInfos, Collection<CacheTopology> currentTopologies, Collection<CacheTopology> stableTopologies) {
        this.expectedMembers = Collections.emptyList();
        for (CacheTopology cacheTopology : stableTopologies) {
            this.addMembers(cacheTopology.getMembers(), joinInfos);
        }
        for (CacheTopology cacheTopology : currentTopologies) {
            this.addMembers(cacheTopology.getMembers(), joinInfos);
        }
        for (Map.Entry entry : joinInfos.entrySet()) {
            if (this.expectedMembers.contains(entry.getKey())) continue;
            this.addMember((Address)entry.getKey(), (CacheJoinInfo)entry.getValue());
        }
    }

    private void addMembers(Collection<Address> membersToAdd, Map<Address, CacheJoinInfo> joinInfos) {
        for (Address member : membersToAdd) {
            CacheJoinInfo joinInfo;
            if (this.expectedMembers.contains(member) || (joinInfo = joinInfos.get(member)) == null) continue;
            this.addMember(member, joinInfo);
        }
    }

    @Override
    public String getCacheName() {
        return this.cacheName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CacheStatusResponse doJoin(Address joiner, CacheJoinInfo joinInfo) throws Exception {
        CacheTopology topologyBeforeRebalance;
        ClusterCacheStatus clusterCacheStatus = this;
        synchronized (clusterCacheStatus) {
            boolean isFirstMember = this.getCurrentTopology() == null;
            boolean memberJoined = this.addMember(joiner, joinInfo);
            if (!isFirstMember && !memberJoined) {
                if (trace) {
                    log.tracef("Trying to add node %s to cache %s, but it is already a member: members = %s, joiners = %s", new Object[]{joiner, this.cacheName, this.expectedMembers, this.joiners});
                }
                return new CacheStatusResponse(null, this.currentTopology, this.stableTopology, this.availabilityMode);
            }
            if (this.status == ComponentStatus.INSTANTIATED) {
                if (this.persistentState.isPresent()) {
                    CacheTopology topology;
                    if (trace) {
                        log.tracef("Node %s joining. Attempting to reform previous cluster", joiner);
                    }
                    if ((topology = this.restoreCacheTopology(this.persistentState.get())) != null) {
                        this.status = ComponentStatus.RUNNING;
                        this.clusterTopologyManager.broadcastTopologyUpdate(this.cacheName, topology, this.availabilityMode, this.isTotalOrder(), this.isDistributed());
                        this.clusterTopologyManager.broadcastStableTopologyUpdate(this.cacheName, topology, this.isTotalOrder(), this.isDistributed());
                        return new CacheStatusResponse(null, this.currentTopology, this.stableTopology, this.availabilityMode);
                    }
                } else if (isFirstMember) {
                    CacheTopology initialTopology = this.createInitialCacheTopology();
                    this.status = ComponentStatus.RUNNING;
                    this.clusterTopologyManager.broadcastStableTopologyUpdate(this.cacheName, initialTopology, this.isTotalOrder(), this.isDistributed());
                }
            }
            if ((topologyBeforeRebalance = this.getCurrentTopology()) != null) {
                this.availabilityStrategy.onJoin(this, joiner);
            }
        }
        return new CacheStatusResponse(null, topologyBeforeRebalance, this.stableTopology, this.availabilityMode);
    }

    protected CacheTopology restoreCacheTopology(ScopedPersistentState state) {
        ConsistentHash persistedCH;
        if (trace) {
            log.tracef("Attempting to restore CH for cache %s", this.cacheName);
        }
        if ((persistedCH = this.joinInfo.getConsistentHashFactory().fromPersistentState(state).remapAddresses(this.persistentUUIDManager.persistentUUIDToAddress())) == null || !this.getExpectedMembers().containsAll(persistedCH.getMembers())) {
            if (trace) {
                log.tracef("Could not restore CH for cache %s, one or more addresses are missing", this.cacheName);
            }
            return null;
        }
        if (this.getExpectedMembers().size() > persistedCH.getMembers().size()) {
            ArrayList<Address> extraneousMembers = new ArrayList<Address>(this.getExpectedMembers());
            extraneousMembers.removeAll(persistedCH.getMembers());
            throw log.extraneousMembersJoinRestoredCache(extraneousMembers, this.cacheName);
        }
        CacheTopology initialTopology = new CacheTopology(0, 0, persistedCH, null, persistedCH.getMembers(), this.persistentUUIDManager.mapAddresses(persistedCH.getMembers()));
        this.setCurrentTopology(initialTopology);
        this.setStableTopology(initialTopology);
        this.rebalancingEnabled = true;
        this.availabilityMode = AvailabilityMode.AVAILABLE;
        return initialTopology;
    }

    protected CacheTopology createInitialCacheTopology() {
        log.tracef("Initializing status for cache %s", this.cacheName);
        List<Address> initialMembers = this.getExpectedMembers();
        Object initialCH = this.joinInfo.getConsistentHashFactory().create(this.joinInfo.getHashFunction(), this.joinInfo.getNumOwners(), this.joinInfo.getNumSegments(), initialMembers, this.getCapacityFactors());
        CacheTopology initialTopology = new CacheTopology(0, 0, (ConsistentHash)initialCH, null, initialMembers, this.persistentUUIDManager.mapAddresses(initialMembers));
        this.setCurrentTopology(initialTopology);
        this.setStableTopology(initialTopology);
        return initialTopology;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean doLeave(Address leaver) throws Exception {
        ClusterCacheStatus clusterCacheStatus = this;
        synchronized (clusterCacheStatus) {
            if (this.currentTopology == null) {
                return false;
            }
            boolean actualLeaver = this.removeMember(leaver);
            if (!actualLeaver) {
                return false;
            }
            this.availabilityStrategy.onGracefulLeave(this, leaver);
            boolean rebalanceCompleted = this.updateRebalanceMembers();
            if (rebalanceCompleted) {
                this.endRebalance();
            }
            return this.expectedMembers.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startQueuedRebalance() {
        ClusterCacheStatus clusterCacheStatus = this;
        synchronized (clusterCacheStatus) {
            ConsistentHash updatedMembersCH;
            if (this.queuedRebalanceMembers == null) {
                if (this.stableTopology == null || this.stableTopology.getTopologyId() < this.currentTopology.getTopologyId()) {
                    this.stableTopology = this.currentTopology;
                    log.tracef("Updating stable topology for cache %s: %s", this.cacheName, this.stableTopology);
                    this.clusterTopologyManager.broadcastStableTopologyUpdate(this.cacheName, this.stableTopology, this.isTotalOrder(), this.isDistributed());
                }
                return;
            }
            CacheTopology cacheTopology = this.getCurrentTopology();
            if (!this.isRebalanceEnabled()) {
                log.tracef("Postponing rebalance for cache %s, rebalancing is disabled", this.cacheName);
                return;
            }
            if (this.isRebalanceInProgress()) {
                log.tracef("Postponing rebalance for cache %s, there's already a rebalance in progress: %s", this.cacheName, this.rebalanceConfirmationCollector);
                return;
            }
            if (this.queuedRebalanceMembers.isEmpty()) {
                log.tracef("Ignoring request to rebalance cache %s, it doesn't have any member", this.cacheName);
                return;
            }
            ArrayList<Address> newMembers = new ArrayList<Address>(this.queuedRebalanceMembers);
            this.queuedRebalanceMembers = null;
            log.tracef("Rebalancing consistent hash for cache %s, members are %s", this.cacheName, newMembers);
            if (cacheTopology == null) {
                this.createInitialCacheTopology();
                return;
            }
            int newTopologyId = cacheTopology.getTopologyId() + 1;
            int newRebalanceId = cacheTopology.getRebalanceId() + 1;
            ConsistentHash currentCH = cacheTopology.getCurrentCH();
            if (currentCH == null) {
                log.tracef("Ignoring request to rebalance cache %s, it doesn't have a consistent hash", this.cacheName);
                return;
            }
            if (!this.expectedMembers.containsAll(newMembers)) {
                newMembers.removeAll(this.expectedMembers);
                log.tracef("Ignoring request to rebalance cache %s, we have new leavers: %s", this.cacheName, newMembers);
                return;
            }
            ConsistentHashFactory chFactory = this.getJoinInfo().getConsistentHashFactory();
            ConsistentHash balancedCH = chFactory.rebalance(updatedMembersCH = chFactory.updateMembers(currentCH, newMembers, this.getCapacityFactors()));
            if (balancedCH.equals(currentCH)) {
                log.tracef("The balanced CH is the same as the current CH, not rebalancing", new Object[0]);
                return;
            }
            CacheTopology newTopology = new CacheTopology(newTopologyId, newRebalanceId, currentCH, balancedCH, balancedCH.getMembers(), this.persistentUUIDManager.mapAddresses(balancedCH.getMembers()));
            log.tracef("Updating cache %s topology for rebalance: %s", this.cacheName, newTopology);
            this.setCurrentTopology(newTopology);
            this.initRebalanceConfirmationCollector(newTopology);
        }
        this.clusterTopologyManager.broadcastRebalanceStart(this.cacheName, this.getCurrentTopology(), this.isTotalOrder(), this.isDistributed());
    }

    public boolean isRebalanceEnabled() {
        return this.rebalancingEnabled && this.clusterTopologyManager.isRebalancingEnabled();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRebalanceEnabled(boolean enabled) {
        ClusterCacheStatus clusterCacheStatus = this;
        synchronized (clusterCacheStatus) {
            this.rebalancingEnabled = enabled;
            if (this.rebalancingEnabled) {
                log.debugf("Rebalancing is now enabled for cache %s", this.cacheName);
                this.startQueuedRebalance();
            } else {
                log.debugf("Rebalancing is now disabled for cache %s", this.cacheName);
            }
        }
    }

    public void forceRebalance() {
        this.queueRebalance(this.getCurrentTopology().getMembers());
        this.startQueuedRebalance();
    }

    public void forceAvailabilityMode(AvailabilityMode newAvailabilityMode) {
        this.availabilityStrategy.onManualAvailabilityChange(this, newAvailabilityMode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdownCache() throws Exception {
        ClusterCacheStatus clusterCacheStatus = this;
        synchronized (clusterCacheStatus) {
            if (this.status == ComponentStatus.RUNNING) {
                this.status = ComponentStatus.STOPPING;
                this.clusterTopologyManager.setRebalancingEnabled(this.cacheName, false);
                this.clusterTopologyManager.broadcastShutdownCache(this.cacheName, this.getCurrentTopology(), this.isTotalOrder(), this.isDistributed());
                this.status = ComponentStatus.TERMINATED;
            }
        }
    }
}

