/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.webservices11.wsaddr;

import com.arjuna.webservices11.util.PrivilegedMapBuilderFactory;
import com.arjuna.webservices11.wsarj.InstanceIdentifier;
import com.arjuna.wsc11.messaging.MessageId;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.ws.handler.MessageContext;
import org.jboss.ws.api.addressing.MAP;
import org.jboss.ws.api.addressing.MAPBuilder;
import org.jboss.ws.api.addressing.MAPConstants;
import org.jboss.ws.api.addressing.MAPEndpoint;
import org.jboss.ws.api.addressing.MAPRelatesTo;

public class AddressingHelper {
    private static MAPEndpoint noneAddress = null;
    private static String REPLY_RELATIONSHIP_TYPE_NS = "org.jboss.jbossts.xts";
    private static String REPLY_RELATIONSHIP_TYPE_STRING = "reply";
    private static QName REPLY_RELATIONSHIP_TYPE_QNAME = new QName(REPLY_RELATIONSHIP_TYPE_NS, REPLY_RELATIONSHIP_TYPE_STRING);

    protected AddressingHelper() {
    }

    public static MAP createOneWayResponseContext(MAP map, String messageID) {
        MAPBuilder builder = PrivilegedMapBuilderFactory.getInstance().getBuilderInstance();
        MAP responseMap = builder.newMap();
        MAPEndpoint epref = map.getReplyTo();
        if (AddressingHelper.isNoneAddress(epref)) {
            epref = map.getFrom();
        }
        responseMap.initializeAsDestination(epref);
        responseMap.setMessageID(messageID);
        if (map.getMessageID() != null) {
            MAPRelatesTo relatesTo = builder.newRelatesTo(map.getMessageID(), REPLY_RELATIONSHIP_TYPE_QNAME);
            responseMap.setRelatesTo(relatesTo);
        }
        return responseMap;
    }

    public static MAP createResponseContext(MAP map, String messageID) {
        MAPBuilder builder = PrivilegedMapBuilderFactory.getInstance().getBuilderInstance();
        MAP responseMap = builder.newMap();
        MAPEndpoint epref = map.getReplyTo();
        if (AddressingHelper.isNoneAddress(epref)) {
            epref = map.getFrom();
        }
        responseMap.initializeAsDestination(epref);
        responseMap.setMessageID(messageID);
        if (map.getMessageID() != null) {
            MAPRelatesTo relatesTo = builder.newRelatesTo(map.getMessageID(), REPLY_RELATIONSHIP_TYPE_QNAME);
            responseMap.setRelatesTo(relatesTo);
        }
        return responseMap;
    }

    public static MAP createFaultContext(MAP map, String messageID) {
        MAPBuilder builder = PrivilegedMapBuilderFactory.getInstance().getBuilderInstance();
        MAP faultMap = builder.newMap();
        MAPEndpoint epref = map.getFaultTo();
        if (AddressingHelper.isNoneAddress(epref) && AddressingHelper.isNoneAddress(epref = map.getReplyTo())) {
            epref = map.getFrom();
        }
        faultMap.initializeAsDestination(epref);
        faultMap.setMessageID(messageID);
        if (map.getMessageID() != null) {
            MAPRelatesTo relatesTo = builder.newRelatesTo(map.getMessageID(), REPLY_RELATIONSHIP_TYPE_QNAME);
            faultMap.setRelatesTo(relatesTo);
        }
        return faultMap;
    }

    public static MAP createRequestContext(String address, String messageID) {
        MAPBuilder builder = PrivilegedMapBuilderFactory.getInstance().getBuilderInstance();
        MAP requestMap = builder.newMap();
        requestMap.setTo(address);
        if (messageID != null) {
            requestMap.setMessageID(messageID);
        } else {
            String dummyID = MessageId.getMessageId();
            requestMap.setMessageID(dummyID);
        }
        return requestMap;
    }

    public static MAP createRequestContext(String address, String action, String messageID) {
        MAPBuilder builder = PrivilegedMapBuilderFactory.getInstance().getBuilderInstance();
        MAP requestMap = builder.newMap();
        requestMap.setTo(address);
        if (messageID != null) {
            requestMap.setMessageID(messageID);
        } else {
            String dummyID = MessageId.getMessageId();
            requestMap.setMessageID(dummyID);
        }
        requestMap.setAction(action);
        return requestMap;
    }

    public static MAP createRequestContext(MAP map, String messageID) {
        MAPBuilder builder = PrivilegedMapBuilderFactory.getInstance().getBuilderInstance();
        MAP requestMap = builder.newMap();
        MAPEndpoint epref = map.getReplyTo();
        if (AddressingHelper.isNoneAddress(epref)) {
            epref = map.getFrom();
        }
        requestMap.initializeAsDestination(epref);
        if (messageID != null) {
            requestMap.setMessageID(messageID);
        }
        if (map.getMessageID() != null) {
            MAPRelatesTo relatesTo = builder.newRelatesTo(map.getMessageID(), REPLY_RELATIONSHIP_TYPE_QNAME);
            requestMap.setRelatesTo(relatesTo);
        }
        return requestMap;
    }

    public static MAP createNotificationContext(String messageID) {
        MAPBuilder builder = PrivilegedMapBuilderFactory.getInstance().getBuilderInstance();
        MAP requestMap = builder.newMap();
        requestMap.setMessageID(messageID);
        requestMap.setAction("");
        String noneURI = builder.newConstants().getNoneURI();
        requestMap.setReplyTo(builder.newEndpoint(noneURI));
        return requestMap;
    }

    public static void installActionMessageID(MAP map, String action, String messageID) {
        map.setMessageID(messageID);
        map.setAction(action);
    }

    public static void installCallerProperties(MAP map, MAP requestMap) {
        MAPRelatesTo relatesTo;
        MAPEndpoint epr;
        String uri = map.getAction();
        if (uri != null) {
            requestMap.setAction(uri);
        }
        if ((uri = map.getMessageID()) != null) {
            requestMap.setMessageID(uri);
        }
        if ((epr = map.getFrom()) != null) {
            requestMap.setFrom(epr);
        }
        if ((epr = map.getFaultTo()) != null) {
            requestMap.setFaultTo(epr);
        }
        if ((epr = map.getReplyTo()) != null) {
            requestMap.setReplyTo(epr);
        }
        if ((relatesTo = map.getRelatesTo()) != null) {
            requestMap.setRelatesTo(relatesTo);
        }
    }

    public static void installFaultTo(MAP map, MAPEndpoint epReference, InstanceIdentifier identifier) {
        MAPBuilder builder = PrivilegedMapBuilderFactory.getInstance().getBuilderInstance();
        MAPEndpoint from = builder.newEndpoint(epReference.getAddress());
        InstanceIdentifier.setEndpointInstanceIdentifier(from, identifier);
        map.setFaultTo(from);
    }

    public static void installFromFaultTo(MAP map, MAPEndpoint epReference, InstanceIdentifier identifier) {
        MAPBuilder builder = PrivilegedMapBuilderFactory.getInstance().getBuilderInstance();
        MAPEndpoint from = builder.newEndpoint(epReference.getAddress());
        InstanceIdentifier.setEndpointInstanceIdentifier(from, identifier);
        map.setFrom(from);
        MAPEndpoint faultTo = builder.newEndpoint(epReference.getAddress());
        InstanceIdentifier.setEndpointInstanceIdentifier(faultTo, identifier);
        map.setFaultTo(faultTo);
    }

    public static boolean isNoneReplyTo(MAP map) {
        return AddressingHelper.isNoneAddress(map.getReplyTo());
    }

    public static boolean isNoneAddress(MAPEndpoint epref) {
        if (epref != null) {
            String noneAddress = AddressingHelper.getNoneAddress().getAddress();
            String eprefAddress = epref.getAddress();
            return noneAddress.equals(eprefAddress);
        }
        return true;
    }

    public static void installNoneReplyTo(MAP map) {
        map.setReplyTo(AddressingHelper.getNoneAddress());
    }

    public static void configureRequestContext(Map<String, Object> requestContext, MAP map, String to, String action) {
        AddressingHelper.configureRequestContext(requestContext, map);
        map.setAction(action);
        AddressingHelper.configureRequestContext(requestContext, to, action);
    }

    public static void configureRequestContext(Map<String, Object> requestContext, MAP map) {
        map.installOutboundMapOnClientSide(requestContext, map);
    }

    public static void configureRequestContext(Map<String, Object> requestContext, String to, String action) {
        if (to != null) {
            requestContext.put("javax.xml.ws.service.endpoint.address", to);
        }
        if (action != null) {
            requestContext.put("javax.xml.ws.soap.http.soapaction.uri", action);
        }
    }

    public static MAP inboundMap(MessageContext ctx) {
        return PrivilegedMapBuilderFactory.getInstance().getBuilderInstance().inboundMap((Map)ctx);
    }

    public static MAP outboundMap(Map<String, Object> ctx) {
        return PrivilegedMapBuilderFactory.getInstance().getBuilderInstance().outboundMap(ctx);
    }

    private static synchronized MAPEndpoint getNoneAddress() {
        if (noneAddress == null) {
            MAPBuilder builder = PrivilegedMapBuilderFactory.getInstance().getBuilderInstance();
            MAPConstants mapConstants = builder.newConstants();
            String noneURI = mapConstants.getNoneURI();
            noneAddress = builder.newEndpoint(noneURI);
        }
        return noneAddress;
    }
}

