/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.hotrod.transport;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOutboundHandler;
import java.util.concurrent.ExecutorService;
import org.infinispan.commons.logging.LogFactory;
import org.infinispan.server.core.ProtocolServer;
import org.infinispan.server.core.transport.NettyChannelInitializer;
import org.infinispan.server.core.transport.NettyTransport;
import org.infinispan.server.hotrod.AuthenticationHandler;
import org.infinispan.server.hotrod.ContextHandler;
import org.infinispan.server.hotrod.HotRodExceptionHandler;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.server.hotrod.LocalContextHandler;
import org.infinispan.server.hotrod.configuration.HotRodServerConfiguration;
import org.infinispan.server.hotrod.logging.HotRodAccessLoggingHandler;
import org.infinispan.server.hotrod.logging.JavaLog;
import org.infinispan.server.hotrod.logging.LoggingContextHandler;
import org.jboss.logging.BasicLogger;
import scala.Function0;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001Y3A!\u0001\u0002\u0001\u001b\tA\u0002j\u001c;S_\u0012\u001c\u0005.\u00198oK2Le.\u001b;jC2L'0\u001a:\u000b\u0005\r!\u0011!\u0003;sC:\u001c\bo\u001c:u\u0015\t)a!\u0001\u0004i_R\u0014x\u000e\u001a\u0006\u0003\u000f!\taa]3sm\u0016\u0014(BA\u0005\u000b\u0003)IgNZ5oSN\u0004\u0018M\u001c\u0006\u0002\u0017\u0005\u0019qN]4\u0004\u0001M\u0011\u0001A\u0004\t\u0003\u001fMi\u0011\u0001\u0005\u0006\u0003\u0007EQ!A\u0005\u0004\u0002\t\r|'/Z\u0005\u0003)A\u0011qCT3uif\u001c\u0005.\u00198oK2Le.\u001b;jC2L'0\u001a:\t\u0011\u001d\u0001!Q1A\u0005\u0002Y)\u0012a\u0006\t\u00031ei\u0011\u0001B\u0005\u00035\u0011\u0011A\u0002S8u%>$7+\u001a:wKJD\u0001\u0002\b\u0001\u0003\u0002\u0003\u0006IaF\u0001\bg\u0016\u0014h/\u001a:!\u0011!\u0019\u0001A!A%\u0002\u0013q\u0002cA\u0010#I5\t\u0001EC\u0001\"\u0003\u0015\u00198-\u00197b\u0013\t\u0019\u0003E\u0001\u0005=Eft\u0017-\\3?!\tyQ%\u0003\u0002'!\tqa*\u001a;usR\u0013\u0018M\\:q_J$\b\u0002\u0003\u0015\u0001\u0005\u000b\u0007I\u0011A\u0015\u0002\u000f\u0015t7m\u001c3feV\t!\u0006\u0005\u0002,e5\tAF\u0003\u0002.]\u000591\r[1o]\u0016d'BA\u00181\u0003\u0015qW\r\u001e;z\u0015\u0005\t\u0014AA5p\u0013\t\u0019DF\u0001\fDQ\u0006tg.\u001a7PkR\u0014w.\u001e8e\u0011\u0006tG\r\\3s\u0011!)\u0004A!A!\u0002\u0013Q\u0013\u0001C3oG>$WM\u001d\u0011\t\u0011]\u0002!\u0011!Q\u0001\na\n\u0001\"\u001a=fGV$xN\u001d\t\u0003s\u0001k\u0011A\u000f\u0006\u0003wq\n!bY8oGV\u0014(/\u001a8u\u0015\tid(\u0001\u0003vi&d'\"A \u0002\t)\fg/Y\u0005\u0003\u0003j\u0012q\"\u0012=fGV$xN]*feZL7-\u001a\u0005\u0006\u0007\u0002!\t\u0001R\u0001\u0007y%t\u0017\u000e\u001e \u0015\u000b\u0015;\u0005*\u0013&\u0011\u0005\u0019\u0003Q\"\u0001\u0002\t\u000b\u001d\u0011\u0005\u0019A\f\t\r\r\u0011E\u00111\u0001\u001f\u0011\u0015A#\t1\u0001+\u0011\u00159$\t1\u00019\u0011\u0015a\u0005\u0001\"\u0011N\u0003-Ig.\u001b;DQ\u0006tg.\u001a7\u0015\u00059\u000b\u0006CA\u0010P\u0013\t\u0001\u0006E\u0001\u0003V]&$\b\"\u0002*L\u0001\u0004\u0019\u0016AA2i!\tYC+\u0003\u0002VY\t91\t[1o]\u0016d\u0007")
public class HotRodChannelInitializer
extends NettyChannelInitializer {
    private final HotRodServer server;
    private final Function0<NettyTransport> transport;
    private final ChannelOutboundHandler encoder;
    private final ExecutorService executor;

    public HotRodServer server() {
        return this.server;
    }

    public ChannelOutboundHandler encoder() {
        return this.encoder;
    }

    public void initChannel(Channel ch) {
        super.initChannel(ch);
        AuthenticationHandler authHandler = ((HotRodServerConfiguration)this.server().getConfiguration()).authentication().enabled() ? new AuthenticationHandler(this.server()) : null;
        Object object = authHandler == null ? BoxedUnit.UNIT : ch.pipeline().addLast("authentication-1", (ChannelHandler)authHandler);
        ch.pipeline().addLast("local-handler", (ChannelHandler)new LocalContextHandler((NettyTransport)this.transport.apply()));
        ch.pipeline().addLast("handler", (ChannelHandler)new ContextHandler(this.server(), (NettyTransport)this.transport.apply(), this.executor));
        ch.pipeline().addLast("exception", (ChannelHandler)new HotRodExceptionHandler());
        if (((BasicLogger)LogFactory.getLog(HotRodAccessLoggingHandler.class, JavaLog.class)).isTraceEnabled()) {
            ch.pipeline().addBefore("decoder", "logging", (ChannelHandler)new HotRodAccessLoggingHandler());
            ch.pipeline().addAfter("encoder", "logging-context", (ChannelHandler)LoggingContextHandler.getInstance());
        }
    }

    public HotRodChannelInitializer(HotRodServer server, Function0<NettyTransport> transport, ChannelOutboundHandler encoder, ExecutorService executor) {
        this.server = server;
        this.transport = transport;
        this.encoder = encoder;
        this.executor = executor;
        super((ProtocolServer)server, transport, encoder);
    }
}

