/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.core.configuration;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.net.ssl.SSLContext;
import org.infinispan.commons.configuration.Builder;
import org.infinispan.server.core.configuration.ProtocolServerConfiguration;
import org.infinispan.server.core.configuration.ProtocolServerConfigurationChildBuilder;
import org.infinispan.server.core.configuration.SslConfiguration;
import org.infinispan.server.core.configuration.SslEngineConfiguration;
import org.infinispan.server.core.configuration.SslEngineConfigurationBuilder;
import org.infinispan.server.core.logging.JavaLog;
import org.infinispan.util.logging.LogFactory;

public class SslConfigurationBuilder<T extends ProtocolServerConfiguration, S extends ProtocolServerConfigurationChildBuilder<T, S>>
implements Builder<SslConfiguration>,
ProtocolServerConfigurationChildBuilder<T, S> {
    private static final JavaLog log = (JavaLog)LogFactory.getLog(SslConfigurationBuilder.class, JavaLog.class);
    private final ProtocolServerConfigurationChildBuilder<T, S> parentConfigurationBuilder;
    private boolean enabled = false;
    private boolean requireClientAuth = false;
    private SslEngineConfigurationBuilder defaultDomainConfigurationBuilder = new SslEngineConfigurationBuilder(this);
    private Map<String, SslEngineConfigurationBuilder> sniDomains;

    SslConfigurationBuilder(ProtocolServerConfigurationChildBuilder<T, S> parentConfigurationBuilder) {
        this.parentConfigurationBuilder = parentConfigurationBuilder;
        this.sniDomains = new HashMap<String, SslEngineConfigurationBuilder>();
        this.defaultDomainConfigurationBuilder = new SslEngineConfigurationBuilder(this);
        this.sniDomains.put("*", this.defaultDomainConfigurationBuilder);
    }

    public SslConfigurationBuilder disable() {
        this.enabled = false;
        return this;
    }

    public SslConfigurationBuilder enable() {
        this.enabled = true;
        return this;
    }

    public SslConfigurationBuilder enabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public SslConfigurationBuilder requireClientAuth(boolean requireClientAuth) {
        this.requireClientAuth = requireClientAuth;
        return this;
    }

    public SslEngineConfigurationBuilder sniHostName(String domain) {
        return this.sniDomains.computeIfAbsent(domain, v -> new SslEngineConfigurationBuilder(this));
    }

    public SslConfigurationBuilder sslContext(SSLContext sslContext) {
        this.defaultDomainConfigurationBuilder.sslContext(sslContext);
        return this;
    }

    public SslConfigurationBuilder keyStoreFileName(String keyStoreFileName) {
        this.defaultDomainConfigurationBuilder.keyStoreFileName(keyStoreFileName);
        return this;
    }

    public SslConfigurationBuilder keyStorePassword(char[] keyStorePassword) {
        this.defaultDomainConfigurationBuilder.keyStorePassword(keyStorePassword);
        return this;
    }

    public SslConfigurationBuilder keyStoreCertificatePassword(char[] keyStoreCertificatePassword) {
        this.defaultDomainConfigurationBuilder.keyStoreCertificatePassword(keyStoreCertificatePassword);
        return this;
    }

    public SslConfigurationBuilder trustStoreFileName(String trustStoreFileName) {
        this.defaultDomainConfigurationBuilder.trustStoreFileName(trustStoreFileName);
        return this;
    }

    public SslConfigurationBuilder trustStorePassword(char[] trustStorePassword) {
        this.defaultDomainConfigurationBuilder.trustStorePassword(trustStorePassword);
        return this;
    }

    public void validate() {
        if (this.enabled) {
            this.sniDomains.forEach((domainName, config) -> config.validate());
        }
    }

    public SslConfiguration create() {
        Map<String, SslEngineConfiguration> producedSniConfigurations = this.sniDomains.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((SslEngineConfigurationBuilder)e.getValue()).create()));
        return new SslConfiguration(this.enabled, this.requireClientAuth, producedSniConfigurations);
    }

    public SslConfigurationBuilder read(SslConfiguration template) {
        this.enabled = template.enabled();
        this.requireClientAuth = template.requireClientAuth();
        this.sniDomains = new HashMap<String, SslEngineConfigurationBuilder>();
        template.sniDomainsConfiguration().entrySet().forEach(e -> this.sniDomains.put((String)e.getKey(), new SslEngineConfigurationBuilder(this).read((SslEngineConfiguration)e.getValue())));
        this.defaultDomainConfigurationBuilder = this.sniDomains.computeIfAbsent("*", v -> new SslEngineConfigurationBuilder(this));
        return this;
    }

    @Override
    public S defaultCacheName(String defaultCacheName) {
        return this.parentConfigurationBuilder.defaultCacheName(defaultCacheName);
    }

    @Override
    public S name(String name) {
        return this.parentConfigurationBuilder.name(name);
    }

    @Override
    public S host(String host) {
        return this.parentConfigurationBuilder.host(host);
    }

    @Override
    public S port(int port) {
        return this.parentConfigurationBuilder.port(port);
    }

    @Override
    public S idleTimeout(int idleTimeout) {
        return this.parentConfigurationBuilder.idleTimeout(idleTimeout);
    }

    @Override
    public S tcpNoDelay(boolean tcpNoDelay) {
        return this.parentConfigurationBuilder.tcpNoDelay(tcpNoDelay);
    }

    @Override
    public S recvBufSize(int recvBufSize) {
        return this.parentConfigurationBuilder.recvBufSize(recvBufSize);
    }

    @Override
    public S sendBufSize(int sendBufSize) {
        return this.parentConfigurationBuilder.sendBufSize(sendBufSize);
    }

    @Override
    public SslConfigurationBuilder ssl() {
        return this.parentConfigurationBuilder.ssl();
    }

    @Override
    public S workerThreads(int workerThreads) {
        return this.parentConfigurationBuilder.workerThreads(workerThreads);
    }

    @Override
    public S ignoredCaches(Set<String> ignoredCaches) {
        return this.parentConfigurationBuilder.ignoredCaches(ignoredCaches);
    }

    @Override
    public T build() {
        return this.parentConfigurationBuilder.build();
    }

    public S self() {
        return (S)((ProtocolServerConfigurationChildBuilder)this.parentConfigurationBuilder.self());
    }
}

