/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.core.transport;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOutboundHandler;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.logging.LogLevel;
import io.netty.handler.logging.LoggingHandler;
import io.netty.handler.ssl.CipherSuiteFilter;
import io.netty.handler.ssl.ClientAuth;
import io.netty.handler.ssl.IdentityCipherSuiteFilter;
import io.netty.handler.ssl.JdkSslContext;
import io.netty.handler.ssl.SniHandler;
import io.netty.util.DomainMappingBuilder;
import javax.net.ssl.SSLContext;
import org.infinispan.commons.util.SslContextFactory;
import org.infinispan.server.core.ProtocolServer;
import org.infinispan.server.core.configuration.SslConfiguration;
import org.infinispan.server.core.configuration.SslEngineConfiguration;
import org.infinispan.server.core.transport.NettyTransport;
import org.infinispan.server.core.transport.StatsChannelHandler;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.MapLike;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001=4A!\u0001\u0002\u0001\u001b\t9b*\u001a;us\u000eC\u0017M\u001c8fY&s\u0017\u000e^5bY&TXM\u001d\u0006\u0003\u0007\u0011\t\u0011\u0002\u001e:b]N\u0004xN\u001d;\u000b\u0005\u00151\u0011\u0001B2pe\u0016T!a\u0002\u0005\u0002\rM,'O^3s\u0015\tI!\"\u0001\u0006j]\u001aLg.[:qC:T\u0011aC\u0001\u0004_J<7\u0001A\n\u0003\u00019\u00012a\u0004\f\u0019\u001b\u0005\u0001\"BA\t\u0013\u0003\u001d\u0019\u0007.\u00198oK2T!a\u0005\u000b\u0002\u000b9,G\u000f^=\u000b\u0003U\t!![8\n\u0005]\u0001\"AE\"iC:tW\r\\%oSRL\u0017\r\\5{KJ\u0004\"aD\r\n\u0005i\u0001\"aB\"iC:tW\r\u001c\u0005\t\u000f\u0001\u0011\t\u0011)A\u00059A\u0011QDH\u0007\u0002\t%\u0011q\u0004\u0002\u0002\u000f!J|Go\\2pYN+'O^3s\u0011!\u0019\u0001A!A%\u0002\u0013\t\u0003c\u0001\u0012&O5\t1EC\u0001%\u0003\u0015\u00198-\u00197b\u0013\t13E\u0001\u0005=Eft\u0017-\\3?!\tA\u0013&D\u0001\u0003\u0013\tQ#A\u0001\bOKR$\u0018\u0010\u0016:b]N\u0004xN\u001d;\t\u00111\u0002!\u0011!Q\u0001\n5\nq!\u001a8d_\u0012,'\u000f\u0005\u0002\u0010]%\u0011q\u0006\u0005\u0002\u0017\u0007\"\fgN\\3m\u001fV$(m\\;oI\"\u000bg\u000e\u001a7fe\")\u0011\u0007\u0001C\u0001e\u00051A(\u001b8jiz\"Ba\r\u001b6mA\u0011\u0001\u0006\u0001\u0005\u0006\u000fA\u0002\r\u0001\b\u0005\u0007\u0007A\"\t\u0019A\u0011\t\u000b1\u0002\u0004\u0019A\u0017\t\u000ba\u0002A\u0011I\u001d\u0002\u0017%t\u0017\u000e^\"iC:tW\r\u001c\u000b\u0003uu\u0002\"AI\u001e\n\u0005q\u001a#\u0001B+oSRDQAP\u001cA\u0002a\t!a\u00195\t\u000b\u0001\u0003A\u0011B!\u0002+\r\u0014X-\u0019;f\u001d\u0016$H/_*tY\u000e{g\u000e^3yiR\u0019!I\u0013*\u0011\u0005\rCU\"\u0001#\u000b\u0005\u00153\u0015aA:tY*\u0011qIE\u0001\bQ\u0006tG\r\\3s\u0013\tIEIA\u0007KI.\u001c6\u000f\\\"p]R,\u0007\u0010\u001e\u0005\u0006\u0017~\u0002\r\u0001T\u0001\u0011gNd7i\u001c8gS\u001e,(/\u0019;j_:\u0004\"!\u0014)\u000e\u00039S!a\u0014\u0003\u0002\u001b\r|gNZ5hkJ\fG/[8o\u0013\t\tfJ\u0001\tTg2\u001cuN\u001c4jOV\u0014\u0018\r^5p]\")1k\u0010a\u0001)\u000612o\u001d7F]\u001eLg.Z\"p]\u001aLw-\u001e:bi&|g\u000e\u0005\u0002N+&\u0011aK\u0014\u0002\u0017'NdWI\\4j]\u0016\u001cuN\u001c4jOV\u0014\u0018\r^5p]\")\u0001\f\u0001C\u00053\u0006\u00012M]3bi\u0016\u001c6\u000f\\\"p]R,\u0007\u0010\u001e\u000b\u0004\u0005j+\u0007\"B.X\u0001\u0004a\u0016AC:tY\u000e{g\u000e^3yiB\u0011QlY\u0007\u0002=*\u0011Qi\u0018\u0006\u0003A\u0006\f1A\\3u\u0015\u0005\u0011\u0017!\u00026bm\u0006D\u0018B\u00013_\u0005)\u00196\u000bT\"p]R,\u0007\u0010\u001e\u0005\u0006M^\u0003\raZ\u0001\u000bG2LWM\u001c;BkRD\u0007CA\"i\u0013\tIGI\u0001\u0006DY&,g\u000e^!vi\"DQa\u001b\u0001\u0005\n1\f\u0011C]3rk&\u0014Xm\u00117jK:$\u0018)\u001e;i)\t9W\u000eC\u0003oU\u0002\u0007A*A\u0005tg2\u001cuN\u001c4jO\u0002")
public class NettyChannelInitializer
extends ChannelInitializer<Channel> {
    private final ProtocolServer server;
    private final Function0<NettyTransport> transport;
    private final ChannelOutboundHandler encoder;

    public void initChannel(Channel ch) {
        BoxedUnit boxedUnit;
        ChannelPipeline pipeline = ch.pipeline();
        pipeline.addLast("stats", (ChannelHandler)new StatsChannelHandler((NettyTransport)this.transport.apply()));
        SslConfiguration ssl = this.server.getConfiguration().ssl();
        if (ssl.enabled()) {
            JdkSslContext defaultNettySslContext = this.org$infinispan$server$core$transport$NettyChannelInitializer$$createNettySslContext(ssl, ssl.sniDomainsConfiguration().get("*"));
            DomainMappingBuilder domainMappingBuilder = new DomainMappingBuilder((Object)defaultNettySslContext);
            ((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(ssl.sniDomainsConfiguration()).asScala()).filterKeys((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final boolean apply(String key) {
                    return !"*".equals(key);
                }
            }).foreach((Function1)new Serializable(this, ssl, domainMappingBuilder){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ NettyChannelInitializer $outer;
                private final SslConfiguration ssl$1;
                private final DomainMappingBuilder domainMappingBuilder$1;

                public final DomainMappingBuilder<JdkSslContext> apply(Tuple2<String, SslEngineConfiguration> e) {
                    return this.domainMappingBuilder$1.add((String)e._1(), (Object)this.$outer.org$infinispan$server$core$transport$NettyChannelInitializer$$createNettySslContext(this.ssl$1, (SslEngineConfiguration)e._2()));
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.ssl$1 = ssl$1;
                    this.domainMappingBuilder$1 = domainMappingBuilder$1;
                }
            });
            boxedUnit = pipeline.addLast("sni", (ChannelHandler)new SniHandler(domainMappingBuilder.build()));
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        pipeline.addLast("decoder", (ChannelHandler)this.server.getDecoder());
        Object object = this.encoder == null ? BoxedUnit.UNIT : pipeline.addLast("encoder", (ChannelHandler)this.encoder);
        pipeline.addLast(new ChannelHandler[]{new LoggingHandler(LogLevel.DEBUG)});
    }

    public JdkSslContext org$infinispan$server$core$transport$NettyChannelInitializer$$createNettySslContext(SslConfiguration sslConfiguration, SslEngineConfiguration sslEngineConfiguration) {
        SSLContext sslContext = sslEngineConfiguration.sslContext() == null ? SslContextFactory.getContext((String)sslEngineConfiguration.keyStoreFileName(), (char[])sslEngineConfiguration.keyStorePassword(), (char[])sslEngineConfiguration.keyStoreCertificatePassword(), (String)sslEngineConfiguration.trustStoreFileName(), (char[])sslEngineConfiguration.trustStorePassword()) : sslEngineConfiguration.sslContext();
        return this.createSslContext(sslContext, this.requireClientAuth(sslConfiguration));
    }

    private JdkSslContext createSslContext(SSLContext sslContext, ClientAuth clientAuth) {
        String[] ciphers = SslContextFactory.getEngine((SSLContext)sslContext, (boolean)false, (boolean)false).getSupportedCipherSuites();
        JdkSslContext context = new JdkSslContext(sslContext, false, (Iterable)JavaConverters$.MODULE$.asJavaIterableConverter(Predef$.MODULE$.refArrayOps((Object[])ciphers).toIterable()).asJava(), (CipherSuiteFilter)IdentityCipherSuiteFilter.INSTANCE, null, clientAuth);
        return context;
    }

    private ClientAuth requireClientAuth(SslConfiguration sslConfig) {
        boolean bl = sslConfig.requireClientAuth();
        ClientAuth clientAuth = true == bl ? ClientAuth.REQUIRE : ClientAuth.NONE;
        return clientAuth;
    }

    public NettyChannelInitializer(ProtocolServer server, Function0<NettyTransport> transport, ChannelOutboundHandler encoder) {
        this.server = server;
        this.transport = transport;
        this.encoder = encoder;
    }
}

