/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.scripting.impl;

import java.util.concurrent.CompletableFuture;
import org.infinispan.commands.write.ClearCommand;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.commands.write.RemoveCommand;
import org.infinispan.commands.write.ReplaceCommand;
import org.infinispan.context.InvocationContext;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.interceptors.BaseCustomSequentialInterceptor;
import org.infinispan.metadata.Metadata;
import org.infinispan.scripting.ScriptingManager;
import org.infinispan.scripting.impl.ScriptingManagerImpl;

public final class ScriptingInterceptor
extends BaseCustomSequentialInterceptor {
    private ScriptingManagerImpl scriptingManager;

    @Inject
    public void init(ScriptingManager scriptingManager) {
        this.scriptingManager = (ScriptingManagerImpl)scriptingManager;
    }

    public CompletableFuture<Void> visitPutKeyValueCommand(InvocationContext ctx, PutKeyValueCommand command) throws Throwable {
        String name = (String)command.getKey();
        String script = (String)command.getValue();
        command.setMetadata((Metadata)this.scriptingManager.compileScript(name, script));
        return ctx.continueInvocation();
    }

    public CompletableFuture<Void> visitClearCommand(InvocationContext ctx, ClearCommand command) throws Throwable {
        this.scriptingManager.compiledScripts.clear();
        return ctx.continueInvocation();
    }

    public CompletableFuture<Void> visitRemoveCommand(InvocationContext ctx, RemoveCommand command) throws Throwable {
        this.scriptingManager.compiledScripts.remove(command.getKey());
        return ctx.continueInvocation();
    }

    public CompletableFuture<Void> visitReplaceCommand(InvocationContext ctx, ReplaceCommand command) throws Throwable {
        String name = (String)command.getKey();
        String script = (String)command.getNewValue();
        command.setMetadata((Metadata)this.scriptingManager.compileScript(name, script));
        return ctx.continueInvocation();
    }
}

