/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.interceptors.distribution;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import org.infinispan.commands.FlagAffectedCommand;
import org.infinispan.commands.ReplicableCommand;
import org.infinispan.commands.functional.ReadOnlyManyCommand;
import org.infinispan.commands.read.AbstractDataCommand;
import org.infinispan.commands.read.GetAllCommand;
import org.infinispan.commands.remote.ClusteredGetAllCommand;
import org.infinispan.commands.remote.ClusteredGetCommand;
import org.infinispan.commands.remote.GetKeysInGroupCommand;
import org.infinispan.commands.write.ClearCommand;
import org.infinispan.commands.write.DataWriteCommand;
import org.infinispan.commands.write.ValueMatcher;
import org.infinispan.commands.write.WriteCommand;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.util.Util;
import org.infinispan.container.EntryFactory;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.container.entries.InternalCacheValue;
import org.infinispan.context.Flag;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.impl.TxInvocationContext;
import org.infinispan.distribution.DistributionManager;
import org.infinispan.distribution.RemoteValueRetrievedListener;
import org.infinispan.distribution.ch.ConsistentHash;
import org.infinispan.distribution.group.GroupManager;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.interceptors.impl.ClusteringInterceptor;
import org.infinispan.interceptors.locking.ClusteringDependentLogic;
import org.infinispan.remoting.inboundhandler.DeliverOrder;
import org.infinispan.remoting.responses.CacheNotFoundResponse;
import org.infinispan.remoting.responses.ClusteredGetResponseValidityFilter;
import org.infinispan.remoting.responses.ExceptionResponse;
import org.infinispan.remoting.responses.Response;
import org.infinispan.remoting.responses.SuccessfulResponse;
import org.infinispan.remoting.rpc.ResponseMode;
import org.infinispan.remoting.rpc.RpcManager;
import org.infinispan.remoting.rpc.RpcOptions;
import org.infinispan.remoting.rpc.RpcOptionsBuilder;
import org.infinispan.remoting.transport.Address;
import org.infinispan.statetransfer.OutdatedTopologyException;
import org.infinispan.topology.CacheTopology;
import org.infinispan.transaction.xa.GlobalTransaction;
import org.infinispan.util.concurrent.CompletableFutures;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public abstract class BaseDistributionInterceptor
extends ClusteringInterceptor {
    protected DistributionManager dm;
    protected ClusteringDependentLogic cdl;
    protected RemoteValueRetrievedListener rvrl;
    protected boolean isL1Enabled;
    private GroupManager groupManager;
    private static final Log log = LogFactory.getLog(BaseDistributionInterceptor.class);
    private static final boolean trace = log.isTraceEnabled();

    @Override
    protected Log getLog() {
        return log;
    }

    @Inject
    public void injectDependencies(DistributionManager distributionManager, ClusteringDependentLogic cdl, RemoteValueRetrievedListener rvrl, GroupManager groupManager) {
        this.dm = distributionManager;
        this.cdl = cdl;
        this.rvrl = rvrl;
        this.groupManager = groupManager;
    }

    @Start
    public void configure() {
        this.isL1Enabled = this.cacheConfiguration.clustering().l1().enabled();
    }

    @Override
    public final CompletableFuture<Void> visitGetKeysInGroupCommand(InvocationContext ctx, GetKeysInGroupCommand command) throws Throwable {
        String groupName = command.getGroupName();
        if (command.isGroupOwner()) {
            return ctx.continueInvocation();
        }
        CompletableFuture<Map<Address, Response>> future = this.rpcManager.invokeRemotelyAsync(Collections.singleton(this.groupManager.getPrimaryOwner(groupName)), command, this.rpcManager.getDefaultRpcOptions(true));
        return future.thenCompose(responses -> {
            Response response;
            if (!responses.isEmpty() && (response = (Response)responses.values().iterator().next()) instanceof SuccessfulResponse) {
                List cacheEntries = (List)((SuccessfulResponse)response).getResponseValue();
                for (CacheEntry entry : cacheEntries) {
                    this.entryFactory.wrapExternalEntry(ctx, entry.getKey(), entry, EntryFactory.Wrap.STORE, false);
                }
            }
            return ctx.continueInvocation();
        });
    }

    @Override
    public final CompletableFuture<Void> visitClearCommand(InvocationContext ctx, ClearCommand command) throws Throwable {
        if (ctx.isOriginLocal() && !this.isLocalModeForced(command)) {
            RpcOptions rpcOptions = this.rpcManager.getRpcOptionsBuilder(this.isSynchronous(command) ? ResponseMode.SYNCHRONOUS_IGNORE_LEAVERS : ResponseMode.ASYNCHRONOUS).build();
            return this.rpcManager.invokeRemotelyAsync(null, command, rpcOptions).thenCompose(responses -> ctx.continueInvocation());
        }
        return ctx.continueInvocation();
    }

    protected final CompletableFuture<InternalCacheEntry> retrieveFromProperSource(Object key, InvocationContext ctx, boolean acquireRemoteLock, FlagAffectedCommand command, boolean isWrite) throws Exception {
        return this.doRetrieveFromProperSource(key, null, -1, ctx, command, acquireRemoteLock, isWrite);
    }

    private CompletableFuture<InternalCacheEntry> doRetrieveFromProperSource(Object key, InternalCacheEntry value, int lastTopologyId, InvocationContext ctx, FlagAffectedCommand command, boolean acquireRemoteLock, boolean isWrite) {
        ArrayList<Address> targets;
        int newTopologyId;
        if (value != null) {
            return CompletableFuture.completedFuture(value);
        }
        CacheTopology cacheTopology = this.stateTransferManager.getCacheTopology();
        int currentTopologyId = cacheTopology.getTopologyId();
        if (trace) {
            log.tracef("Perform remote get for key %s. topologyId=%s, currentTopologyId=%s", key, lastTopologyId, currentTopologyId);
        }
        if (lastTopologyId < currentTopologyId) {
            List<Address> owners;
            boolean isLocal;
            newTopologyId = currentTopologyId;
            ConsistentHash readCH = cacheTopology.getReadConsistentHash();
            if (readCH.isReplicated()) {
                isLocal = readCH.isSegmentLocalToNode(this.rpcManager.getAddress(), 0);
                owners = readCH.getMembers();
            } else {
                owners = readCH.locateOwners(key);
                isLocal = owners.contains(this.rpcManager.getAddress());
            }
            if (isLocal) {
                return CompletableFuture.completedFuture(this.dataContainer.get(key));
            }
            targets = new ArrayList<Address>(owners);
        } else if (lastTopologyId == currentTopologyId && cacheTopology.getPendingCH() != null) {
            newTopologyId = currentTopologyId + 1;
            targets = new ArrayList<Address>(cacheTopology.getPendingCH().locateOwners(key));
            targets.removeAll(cacheTopology.getReadConsistentHash().locateOwners(key));
            if (targets.isEmpty()) {
                if (trace) {
                    log.tracef("No valid values found for key '%s' (topologyId=%s).", key, currentTopologyId);
                }
                return CompletableFutures.completedNull();
            }
        } else {
            if (trace) {
                log.tracef("No valid values found for key '%s' (topologyId=%s).", key, currentTopologyId);
            }
            return CompletableFutures.completedNull();
        }
        GlobalTransaction gtx = ctx.isInTxScope() ? ((TxInvocationContext)ctx).getGlobalTransaction() : null;
        ClusteredGetCommand getCommand = this.cf.buildClusteredGetCommand(key, command.getFlagsBitSet(), acquireRemoteLock, gtx);
        getCommand.setWrite(isWrite);
        RpcOptionsBuilder rpcOptionsBuilder = this.rpcManager.getRpcOptionsBuilder(ResponseMode.WAIT_FOR_VALID_RESPONSE, DeliverOrder.NONE);
        return this.invokeClusterGetCommandRemotely(targets, rpcOptionsBuilder, getCommand, key).thenCompose(newValue -> this.doRetrieveFromProperSource(key, (InternalCacheEntry)newValue, newTopologyId, ctx, command, acquireRemoteLock, isWrite));
    }

    private CompletableFuture<InternalCacheEntry> invokeClusterGetCommandRemotely(List<Address> targets, RpcOptionsBuilder rpcOptionsBuilder, ClusteredGetCommand get, Object key) {
        ClusteredGetResponseValidityFilter filter = new ClusteredGetResponseValidityFilter(targets, this.rpcManager.getAddress());
        RpcOptions options = rpcOptionsBuilder.responseFilter(filter).build();
        return this.rpcManager.invokeRemotelyAsync(targets, get, options).thenApply(responses -> {
            if (!responses.isEmpty()) {
                for (Response r : responses.values()) {
                    SuccessfulResponse response;
                    Object responseValue;
                    if (!(r instanceof SuccessfulResponse) || (responseValue = (response = (SuccessfulResponse)r).getResponseValue()) == null) continue;
                    InternalCacheValue cacheValue = (InternalCacheValue)responseValue;
                    InternalCacheEntry ice = cacheValue.toInternalCacheEntry(key);
                    if (this.rvrl != null) {
                        this.rvrl.remoteValueFound(ice);
                    }
                    return ice;
                }
            }
            if (this.rvrl != null) {
                this.rvrl.remoteValueNotFound(key);
            }
            return null;
        });
    }

    protected Map<Object, InternalCacheEntry> retrieveFromRemoteSources(Set<?> requestedKeys, InvocationContext ctx, long flagsBitSet) throws Throwable {
        GlobalTransaction gtx = ctx.isInTxScope() ? ((TxInvocationContext)ctx).getGlobalTransaction() : null;
        CacheTopology cacheTopology = this.stateTransferManager.getCacheTopology();
        ConsistentHash ch = cacheTopology.getReadConsistentHash();
        HashMap<Address, ArrayList<Object>> ownerKeys = new HashMap<Address, ArrayList<Object>>();
        for (Object key : requestedKeys) {
            Address address = ch.locatePrimaryOwner(key);
            ArrayList<Object> requestedKeysFromNode = (ArrayList<Object>)ownerKeys.get(address);
            if (requestedKeysFromNode == null) {
                requestedKeysFromNode = new ArrayList<Object>();
                ownerKeys.put(address, requestedKeysFromNode);
            }
            requestedKeysFromNode.add(key);
        }
        HashMap<Address, ReplicableCommand> commands = new HashMap<Address, ReplicableCommand>();
        for (Map.Entry entry : ownerKeys.entrySet()) {
            List keys = (List)entry.getValue();
            ClusteredGetAllCommand remoteGetAll = this.cf.buildClusteredGetAllCommand(keys, flagsBitSet, gtx);
            commands.put((Address)entry.getKey(), remoteGetAll);
        }
        RpcOptionsBuilder rpcOptionsBuilder = this.rpcManager.getRpcOptionsBuilder(ResponseMode.SYNCHRONOUS_IGNORE_LEAVERS, DeliverOrder.NONE);
        RpcOptions rpcOptions = rpcOptionsBuilder.build();
        Map<Address, Response> responses = this.rpcManager.invokeRemotely(commands, rpcOptions);
        HashMap<Object, InternalCacheEntry> entries = new HashMap<Object, InternalCacheEntry>();
        for (Map.Entry<Address, Response> entry : responses.entrySet()) {
            this.updateWithValues(((ClusteredGetAllCommand)commands.get(entry.getKey())).getKeys(), entry.getValue(), entries);
        }
        return entries;
    }

    private void updateWithValues(List<?> keys, Response r, Map<Object, InternalCacheEntry> entries) {
        SuccessfulResponse response;
        List values;
        if (r instanceof SuccessfulResponse && (values = (List)(response = (SuccessfulResponse)r).getResponseValue()) != null) {
            for (int i = 0; i < keys.size(); ++i) {
                InternalCacheValue icv = (InternalCacheValue)values.get(i);
                if (icv == null) continue;
                Object key = keys.get(i);
                Object value = icv.getValue();
                if (value == null) {
                    entries.put(key, null);
                    continue;
                }
                InternalCacheEntry ice = icv.toInternalCacheEntry(key);
                entries.put(key, ice);
            }
        }
    }

    protected final CompletableFuture<Void> handleNonTxWriteCommand(InvocationContext ctx, DataWriteCommand command) throws Throwable {
        if (ctx.isInTxScope()) {
            throw new CacheException("Attempted execution of non-transactional write command in a transactional invocation context");
        }
        ctx.onReturn((rCtx, rCommand, rv, throwable) -> {
            if (throwable != null) {
                throw throwable;
            }
            return this.handleLocalResult(ctx, command, rv);
        });
        return this.remoteGetBeforeWrite(ctx, command, command.getKey());
    }

    private CompletableFuture<Object> handleLocalResult(InvocationContext ctx, DataWriteCommand command, Object localResult) {
        if (this.isLocalModeForced(command)) {
            return CompletableFuture.completedFuture(localResult);
        }
        return this.invokeRemotelyIfNeeded(ctx, command, localResult);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CompletableFuture<Object> invokeRemotelyIfNeeded(InvocationContext ctx, DataWriteCommand command, Object localResult) {
        Map<Address, Response> addressResponseMap;
        boolean topologyChanged;
        boolean isSync = this.isSynchronous(command);
        Address primaryOwner = this.cdl.getPrimaryOwner(command.getKey());
        int commandTopologyId = command.getTopologyId();
        int currentTopologyId = this.stateTransferManager.getCacheTopology().getTopologyId();
        boolean bl = topologyChanged = isSync && currentTopologyId != commandTopologyId && commandTopologyId != -1;
        if (trace) {
            log.tracef("Command topology id is %d, current topology id is %d, successful? %s", commandTopologyId, currentTopologyId, command.isSuccessful());
        }
        if (topologyChanged) {
            throw new OutdatedTopologyException("Cache topology changed while the command was executing: expected " + commandTopologyId + ", got " + currentTopologyId);
        }
        ValueMatcher valueMatcher = command.getValueMatcher();
        if (!ctx.isOriginLocal()) {
            if (primaryOwner.equals(this.rpcManager.getAddress())) {
                if (!command.isSuccessful()) {
                    if (trace) {
                        log.tracef("Skipping the replication of the conditional command as it did not succeed on primary owner (%s).", command);
                    }
                    return CompletableFuture.completedFuture(localResult);
                }
                List<Address> recipients = this.cdl.getOwners(command.getKey());
                command.setValueMatcher(ValueMatcher.MATCH_ALWAYS);
                try {
                    this.rpcManager.invokeRemotely(recipients, command, this.determineRpcOptionsForBackupReplication(this.rpcManager, isSync, recipients));
                }
                finally {
                    command.setValueMatcher(valueMatcher.matcherForRetry());
                }
            }
            return CompletableFuture.completedFuture(localResult);
        }
        if (primaryOwner.equals(this.rpcManager.getAddress())) {
            boolean isSingleOwnerAndLocal;
            if (!command.isSuccessful()) {
                if (trace) {
                    log.tracef("Skipping the replication of the command as it did not succeed on primary owner (%s).", command);
                }
                return CompletableFuture.completedFuture(localResult);
            }
            List<Address> recipients = this.cdl.getOwners(command.getKey());
            if (trace) {
                log.tracef("I'm the primary owner, sending the command to all the backups (%s) in order to be applied.", recipients);
            }
            boolean bl2 = isSingleOwnerAndLocal = this.cacheConfiguration.clustering().hash().numOwners() == 1;
            if (!isSingleOwnerAndLocal) {
                command.setValueMatcher(ValueMatcher.MATCH_ALWAYS);
                try {
                    this.rpcManager.invokeRemotely(recipients, command, this.determineRpcOptionsForBackupReplication(this.rpcManager, isSync, recipients));
                }
                finally {
                    command.setValueMatcher(valueMatcher.matcherForRetry());
                }
            }
            return CompletableFuture.completedFuture(localResult);
        }
        if (trace) {
            log.tracef("I'm not the primary owner, so sending the command to the primary owner(%s) in order to be forwarded", primaryOwner);
        }
        boolean isSyncForwarding = isSync || command.isReturnValueExpected();
        try {
            addressResponseMap = this.rpcManager.invokeRemotely(Collections.singletonList(primaryOwner), command, this.rpcManager.getDefaultRpcOptions(isSyncForwarding));
        }
        finally {
            command.setValueMatcher(valueMatcher.matcherForRetry());
        }
        if (!isSyncForwarding) {
            return CompletableFuture.completedFuture(localResult);
        }
        Object primaryResult = this.getResponseFromPrimaryOwner(primaryOwner, addressResponseMap);
        command.updateStatusFromRemoteResponse(primaryResult);
        return CompletableFuture.completedFuture(primaryResult);
    }

    private RpcOptions determineRpcOptionsForBackupReplication(RpcManager rpc, boolean isSync, List<Address> recipients) {
        RpcOptions options = isSync ? (recipients == null ? rpc.getRpcOptionsBuilder(ResponseMode.SYNCHRONOUS_IGNORE_LEAVERS).build() : rpc.getDefaultRpcOptions(true)) : rpc.getDefaultRpcOptions(false);
        return options;
    }

    private Object getResponseFromPrimaryOwner(Address primaryOwner, Map<Address, Response> addressResponseMap) {
        Response fromPrimaryOwner = addressResponseMap.get(primaryOwner);
        if (fromPrimaryOwner == null) {
            if (trace) {
                log.tracef("Primary owner %s returned null", primaryOwner);
            }
            return null;
        }
        if (fromPrimaryOwner.isSuccessful()) {
            return ((SuccessfulResponse)fromPrimaryOwner).getResponseValue();
        }
        if (addressResponseMap.get(primaryOwner) instanceof CacheNotFoundResponse) {
            throw new OutdatedTopologyException("Cache is no longer running on primary owner " + primaryOwner);
        }
        Exception cause = fromPrimaryOwner instanceof ExceptionResponse ? ((ExceptionResponse)fromPrimaryOwner).getException() : null;
        throw new CacheException("Got unsuccessful response from primary owner: " + fromPrimaryOwner, (Throwable)cause);
    }

    @Override
    public CompletableFuture<Void> visitGetAllCommand(InvocationContext ctx, GetAllCommand command) throws Throwable {
        if (command.hasFlag(Flag.CACHE_MODE_LOCAL) || command.hasFlag(Flag.SKIP_REMOTE_LOOKUP)) {
            return ctx.continueInvocation();
        }
        int commandTopologyId = command.getTopologyId();
        if (ctx.isOriginLocal()) {
            boolean topologyChanged;
            int currentTopologyId = this.stateTransferManager.getCacheTopology().getTopologyId();
            boolean bl = topologyChanged = currentTopologyId != commandTopologyId && commandTopologyId != -1;
            if (trace) {
                log.tracef("Command topology id is %d, current topology id is %d", commandTopologyId, currentTopologyId);
            }
            if (topologyChanged) {
                throw new OutdatedTopologyException("Cache topology changed while the command was executing: expected " + commandTopologyId + ", got " + currentTopologyId);
            }
            ConsistentHash ch = command.getConsistentHash();
            HashSet requestedKeys = new HashSet();
            for (Object key : command.getKeys()) {
                CacheEntry entry = ctx.lookupEntry(key);
                if (entry != null) continue;
                if (!ch.isKeyLocalToNode(this.rpcManager.getAddress(), key)) {
                    requestedKeys.add(key);
                    continue;
                }
                if (trace) {
                    log.tracef("Not doing a remote get for missing key %s since entry is mapped to current node (%s). Owners are %s", Util.toStr(key), this.rpcManager.getAddress(), ch.locateOwners(key));
                }
                this.entryFactory.wrapExternalEntry(ctx, key, null, EntryFactory.Wrap.WRAP_ALL, false);
            }
            boolean missingRemoteValues = false;
            if (!requestedKeys.isEmpty()) {
                if (trace) {
                    log.tracef("Fetching entries for keys %s from remote nodes", requestedKeys);
                }
                Map<Object, InternalCacheEntry> justRetrieved = this.retrieveFromRemoteSources(requestedKeys, ctx, command.getFlagsBitSet());
                Map<Object, InternalCacheEntry> previouslyFetched = command.getRemotelyFetched();
                if (previouslyFetched != null) {
                    previouslyFetched.putAll(justRetrieved);
                } else {
                    command.setRemotelyFetched(justRetrieved);
                }
                for (Object key : requestedKeys) {
                    if (!justRetrieved.containsKey(key)) {
                        missingRemoteValues = true;
                        continue;
                    }
                    InternalCacheEntry remoteEntry = justRetrieved.get(key);
                    this.entryFactory.wrapExternalEntry(ctx, key, remoteEntry, EntryFactory.Wrap.WRAP_NON_NULL, false);
                }
            }
            if (missingRemoteValues) {
                throw new OutdatedTopologyException("Remote values are missing because of a topology change");
            }
            return ctx.continueInvocation();
        }
        int currentTopologyId = this.stateTransferManager.getCacheTopology().getTopologyId();
        boolean topologyChanged = currentTopologyId != commandTopologyId && commandTopologyId != -1;
        ConsistentHash ch = command.getConsistentHash();
        for (Object key : command.getKeys()) {
            CacheEntry entry = ctx.lookupEntry(key);
            if (entry != null && !entry.isNull() || !ch.isKeyLocalToNode(this.rpcManager.getAddress(), key) || topologyChanged) continue;
            if (trace) {
                log.tracef("Not doing a remote get for missing key %s since entry is mapped to current node (%s). Owners are %s", Util.toStr(key), this.rpcManager.getAddress(), ch.locateOwners(key));
            }
            this.entryFactory.wrapExternalEntry(ctx, key, null, EntryFactory.Wrap.WRAP_ALL, false);
        }
        return ctx.continueInvocation();
    }

    @Override
    public CompletableFuture<Void> visitReadOnlyManyCommand(InvocationContext ctx, ReadOnlyManyCommand command) throws Throwable {
        if (command.hasFlag(Flag.CACHE_MODE_LOCAL) || command.hasFlag(Flag.SKIP_REMOTE_LOOKUP)) {
            return ctx.continueInvocation();
        }
        int commandTopologyId = command.getTopologyId();
        if (ctx.isOriginLocal()) {
            boolean topologyChanged;
            int currentTopologyId = this.stateTransferManager.getCacheTopology().getTopologyId();
            boolean bl = topologyChanged = currentTopologyId != commandTopologyId && commandTopologyId != -1;
            if (trace) {
                log.tracef("Command topology id is %d, current topology id is %d", commandTopologyId, currentTopologyId);
            }
            if (topologyChanged) {
                throw new OutdatedTopologyException("Cache topology changed while the command was executing: expected " + commandTopologyId + ", got " + currentTopologyId);
            }
            ConsistentHash ch = command.getConsistentHash();
            HashSet requestedKeys = new HashSet();
            for (Object key : command.getKeys()) {
                CacheEntry entry = ctx.lookupEntry(key);
                if (entry != null) continue;
                if (!ch.isKeyLocalToNode(this.rpcManager.getAddress(), key)) {
                    requestedKeys.add(key);
                    continue;
                }
                if (trace) {
                    log.tracef("Not doing a remote get for missing key %s since entry is mapped to current node (%s). Owners are %s", Util.toStr(key), this.rpcManager.getAddress(), ch.locateOwners(key));
                }
                this.entryFactory.wrapExternalEntry(ctx, key, null, EntryFactory.Wrap.WRAP_ALL, false);
            }
            boolean missingRemoteValues = false;
            if (!requestedKeys.isEmpty()) {
                if (trace) {
                    log.tracef("Fetching entries for keys %s from remote nodes", requestedKeys);
                }
                Map<Object, InternalCacheEntry> justRetrieved = this.retrieveFromRemoteSources(requestedKeys, ctx, command.getFlagsBitSet());
                Map<Object, InternalCacheEntry> previouslyFetched = command.getRemotelyFetched();
                if (previouslyFetched != null) {
                    previouslyFetched.putAll(justRetrieved);
                } else {
                    command.setRemotelyFetched(justRetrieved);
                }
                for (Object key : requestedKeys) {
                    if (!justRetrieved.containsKey(key)) {
                        missingRemoteValues = true;
                        continue;
                    }
                    InternalCacheEntry remoteEntry = justRetrieved.get(key);
                    this.entryFactory.wrapExternalEntry(ctx, key, remoteEntry, EntryFactory.Wrap.WRAP_NON_NULL, false);
                }
            }
            if (missingRemoteValues) {
                throw new OutdatedTopologyException("Remote values are missing because of a topology change");
            }
            return ctx.continueInvocation();
        }
        int currentTopologyId = this.stateTransferManager.getCacheTopology().getTopologyId();
        boolean topologyChanged = currentTopologyId != commandTopologyId && commandTopologyId != -1;
        ConsistentHash ch = command.getConsistentHash();
        for (Object key : command.getKeys()) {
            CacheEntry entry = ctx.lookupEntry(key);
            if (entry != null && !entry.isNull() || !ch.isKeyLocalToNode(this.rpcManager.getAddress(), key) || topologyChanged) continue;
            if (trace) {
                log.tracef("Not doing a remote get for missing key %s since entry is mapped to current node (%s). Owners are %s", Util.toStr(key), this.rpcManager.getAddress(), ch.locateOwners(key));
            }
            this.entryFactory.wrapExternalEntry(ctx, key, null, EntryFactory.Wrap.WRAP_ALL, false);
        }
        return ctx.continueInvocation();
    }

    protected abstract boolean writeNeedsRemoteValue(InvocationContext var1, WriteCommand var2, Object var3);

    protected boolean valueIsMissing(CacheEntry entry) {
        return entry == null || entry.isNull() && !entry.isRemoved() && !entry.skipLookup();
    }

    protected abstract CompletableFuture<Void> remoteGetBeforeWrite(InvocationContext var1, WriteCommand var2, Object var3) throws Throwable;

    protected boolean readNeedsRemoteValue(InvocationContext ctx, AbstractDataCommand command) {
        return ctx.isOriginLocal() && !command.hasFlag(Flag.CACHE_MODE_LOCAL) && !command.hasFlag(Flag.SKIP_REMOTE_LOOKUP);
    }
}

