/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.jdbc.configuration;

import org.infinispan.commons.configuration.BuiltBy;
import org.infinispan.commons.configuration.ConfigurationFor;
import org.infinispan.commons.configuration.attributes.Attribute;
import org.infinispan.commons.configuration.attributes.AttributeDefinition;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.configuration.cache.AsyncStoreConfiguration;
import org.infinispan.configuration.cache.SingletonStoreConfiguration;
import org.infinispan.configuration.serializing.SerializedWith;
import org.infinispan.persistence.jdbc.configuration.AbstractJdbcStoreConfiguration;
import org.infinispan.persistence.jdbc.configuration.ConnectionFactoryConfiguration;
import org.infinispan.persistence.jdbc.configuration.JdbcMixedStoreConfigurationBuilder;
import org.infinispan.persistence.jdbc.configuration.JdbcMixedStoreConfigurationSerializer;
import org.infinispan.persistence.jdbc.configuration.TableManipulationConfiguration;
import org.infinispan.persistence.jdbc.mixed.JdbcMixedStore;
import org.infinispan.persistence.keymappers.DefaultTwoWayKey2StringMapper;

@BuiltBy(value=JdbcMixedStoreConfigurationBuilder.class)
@ConfigurationFor(value=JdbcMixedStore.class)
@SerializedWith(value=JdbcMixedStoreConfigurationSerializer.class)
public class JdbcMixedStoreConfiguration
extends AbstractJdbcStoreConfiguration {
    static final AttributeDefinition<Integer> BATCH_SIZE = AttributeDefinition.builder((String)"batchSize", (Object)128).immutable().build();
    static final AttributeDefinition<Integer> FETCH_SIZE = AttributeDefinition.builder((String)"fetchSize", (Object)100).immutable().build();
    static final AttributeDefinition<String> KEY2STRING_MAPPER = AttributeDefinition.builder((String)"key2StringMapper", (Object)DefaultTwoWayKey2StringMapper.class.getName()).immutable().xmlName("key-to-string-mapper").build();
    static final AttributeDefinition<Integer> CONCURRENCY_LEVEL = AttributeDefinition.builder((String)"concurrencyLevel", (Object)2048).immutable().build();
    static final AttributeDefinition<Long> LOCK_ACQUISITION_TIMEOUT = AttributeDefinition.builder((String)"lockAcquisitionTimeout", (Object)60000L).immutable().build();
    private final Attribute<Integer> batchSize;
    private final Attribute<Integer> fetchSize;
    private final Attribute<String> key2StringMapper;
    private final Attribute<Integer> concurrencyLevel;
    private final Attribute<Long> lockAcquisitionTimeout;
    private final TableManipulationConfiguration binaryTable;
    private final TableManipulationConfiguration stringTable;

    public static AttributeSet attributeDefinitionSet() {
        return new AttributeSet(JdbcMixedStoreConfiguration.class, AbstractJdbcStoreConfiguration.attributeDefinitionSet(), new AttributeDefinition[]{BATCH_SIZE, FETCH_SIZE, KEY2STRING_MAPPER, CONCURRENCY_LEVEL, LOCK_ACQUISITION_TIMEOUT});
    }

    public JdbcMixedStoreConfiguration(AttributeSet attributes, AsyncStoreConfiguration async, SingletonStoreConfiguration singletonStore, ConnectionFactoryConfiguration connectionFactory, TableManipulationConfiguration binaryTable, TableManipulationConfiguration stringTable) {
        super(attributes, async, singletonStore, connectionFactory);
        this.binaryTable = binaryTable;
        this.stringTable = stringTable;
        this.batchSize = attributes.attribute(BATCH_SIZE);
        this.fetchSize = attributes.attribute(FETCH_SIZE);
        this.key2StringMapper = attributes.attribute(KEY2STRING_MAPPER);
        this.concurrencyLevel = attributes.attribute(CONCURRENCY_LEVEL);
        this.lockAcquisitionTimeout = attributes.attribute(LOCK_ACQUISITION_TIMEOUT);
    }

    public String key2StringMapper() {
        return (String)this.key2StringMapper.get();
    }

    public TableManipulationConfiguration binaryTable() {
        return this.binaryTable;
    }

    public TableManipulationConfiguration stringTable() {
        return this.stringTable;
    }

    public int batchSize() {
        return (Integer)this.batchSize.get();
    }

    public int fetchSize() {
        return (Integer)this.fetchSize.get();
    }

    public int lockConcurrencyLevel() {
        return (Integer)this.concurrencyLevel.get();
    }

    public long lockAcquisitionTimeout() {
        return (Long)this.lockAcquisitionTimeout.get();
    }

    @Override
    public String toString() {
        return "JdbcMixedStoreConfiguration [binaryTable=" + this.binaryTable + ", stringTable=" + this.stringTable + ", attributes=" + this.attributes + ", connectionFactory()=" + this.connectionFactory() + ", async()=" + this.async() + ", singletonStore()=" + this.singletonStore() + "]";
    }
}

