/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.embedded;

import org.jboss.as.cli.embedded.Contexts;
import org.jboss.logmanager.LogContext;
import org.jboss.logmanager.LogContextSelector;
import org.jboss.stdio.StdioContext;
import org.jboss.stdio.StdioContextSelector;

class ThreadLocalContextSelector
implements LogContextSelector,
StdioContextSelector {
    private final InheritableThreadLocal<Contexts> threadLocal = new InheritableThreadLocal();
    private final Contexts localContexts;
    private final Contexts defaultContexts;

    ThreadLocalContextSelector(Contexts local, Contexts defaults) {
        assert (local != null);
        assert (local.getLogContext() != null);
        assert (defaults != null);
        assert (defaults.getStdioContext() != null);
        assert (defaults.getLogContext() != null);
        this.localContexts = local;
        this.defaultContexts = defaults;
    }

    Contexts pushLocal() {
        Contexts result = (Contexts)this.threadLocal.get();
        this.threadLocal.set(this.localContexts);
        return result;
    }

    void restore(Contexts toRestore) {
        this.threadLocal.set(toRestore);
    }

    @Override
    public StdioContext getStdioContext() {
        Contexts threadContext = (Contexts)this.threadLocal.get();
        StdioContext local = threadContext != null ? threadContext.getStdioContext() : null;
        return local == null ? this.defaultContexts.getStdioContext() : local;
    }

    @Override
    public LogContext getLogContext() {
        Contexts threadContext = (Contexts)this.threadLocal.get();
        LogContext local = threadContext != null ? threadContext.getLogContext() : null;
        return local == null ? this.defaultContexts.getLogContext() : local;
    }
}

