/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.undertow;

import io.undertow.predicate.Predicate;
import io.undertow.predicate.Predicates;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.services.path.PathManager;
import org.jboss.as.controller.services.path.PathManagerService;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.wildfly.extension.io.IOServices;
import org.wildfly.extension.undertow.AccessLogDefinition;
import org.wildfly.extension.undertow.AccessLogService;
import org.wildfly.extension.undertow.Host;
import org.wildfly.extension.undertow.UndertowService;
import org.xnio.XnioWorker;

class AccessLogAdd
extends AbstractAddStepHandler {
    static final AccessLogAdd INSTANCE = new AccessLogAdd();

    AccessLogAdd() {
        super(AccessLogDefinition.ATTRIBUTES);
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        PathAddress address = context.getCurrentAddress();
        PathAddress hostAddress = address.getParent();
        PathAddress serverAddress = hostAddress.getParent();
        String worker = AccessLogDefinition.WORKER.resolveModelAttribute(context, model).asString();
        String pattern = AccessLogDefinition.PATTERN.resolveModelAttribute(context, model).asString();
        String directory = AccessLogDefinition.DIRECTORY.resolveModelAttribute(context, model).asString();
        String filePrefix = AccessLogDefinition.PREFIX.resolveModelAttribute(context, model).asString();
        String fileSuffix = AccessLogDefinition.SUFFIX.resolveModelAttribute(context, model).asString();
        boolean useServerLog = AccessLogDefinition.USE_SERVER_LOG.resolveModelAttribute(context, model).asBoolean();
        boolean rotate = AccessLogDefinition.ROTATE.resolveModelAttribute(context, model).asBoolean();
        boolean extended = AccessLogDefinition.EXTENDED.resolveModelAttribute(context, model).asBoolean();
        ModelNode relativeToNode = AccessLogDefinition.RELATIVE_TO.resolveModelAttribute(context, model);
        String relativeTo = relativeToNode.isDefined() ? relativeToNode.asString() : null;
        Predicate predicate = null;
        ModelNode predicateNode = AccessLogDefinition.PREDICATE.resolveModelAttribute(context, model);
        if (predicateNode.isDefined()) {
            predicate = Predicates.parse((String)predicateNode.asString(), (ClassLoader)((Object)((Object)this)).getClass().getClassLoader());
        }
        AccessLogService service = useServerLog ? new AccessLogService(pattern, extended, predicate) : new AccessLogService(pattern, directory, relativeTo, filePrefix, fileSuffix, rotate, extended, predicate);
        String serverName = serverAddress.getLastElement().getValue();
        String hostName = hostAddress.getLastElement().getValue();
        ServiceName serviceName = UndertowService.accessLogServiceName(serverName, hostName);
        ServiceBuilder builder = context.getServiceTarget().addService(serviceName, (Service)service).addDependency(IOServices.WORKER.append(new String[]{worker}), XnioWorker.class, service.getWorker()).addDependency(PathManagerService.SERVICE_NAME, PathManager.class, service.getPathManager()).addDependency(UndertowService.virtualHostName(serverName, hostName), Host.class, service.getHost());
        builder.setInitialMode(ServiceController.Mode.ACTIVE).install();
    }
}

