/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ee.component.deployers;

import java.io.File;
import java.io.FilePermission;
import java.io.IOException;
import java.security.Permission;
import java.security.Permissions;
import java.util.Enumeration;
import java.util.List;
import org.jboss.as.naming.JndiPermission;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.module.ModuleSpecification;
import org.jboss.as.server.deployment.module.ResourceRoot;
import org.jboss.modules.security.ImmediatePermissionFactory;

public final class EEDefaultPermissionsProcessor
implements DeploymentUnitProcessor {
    private static final Permissions DEFAULT_PERMISSIONS;

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        ModuleSpecification attachment = (ModuleSpecification)deploymentUnit.getAttachment(Attachments.MODULE_SPECIFICATION);
        if (attachment == null) {
            return;
        }
        List permissions = attachment.getPermissionFactories();
        Enumeration<Permission> e = DEFAULT_PERMISSIONS.elements();
        while (e.hasMoreElements()) {
            permissions.add(new ImmediatePermissionFactory(e.nextElement()));
        }
        ResourceRoot root = (ResourceRoot)deploymentUnit.getAttachment(Attachments.DEPLOYMENT_ROOT);
        try {
            File file = root.getRoot().getPhysicalFile();
            if (file != null && file.isDirectory()) {
                FilePermission permission = new FilePermission(file.getAbsolutePath() + File.separatorChar + "-", "read");
                permissions.add(new ImmediatePermissionFactory((Permission)permission));
            }
        }
        catch (IOException ex) {
            throw new DeploymentUnitProcessingException((Throwable)ex);
        }
    }

    public void undeploy(DeploymentUnit context) {
    }

    static {
        Permissions permissions = new Permissions();
        permissions.add((Permission)new JndiPermission("java:comp", new JndiPermission.Action[]{JndiPermission.Action.LOOKUP, JndiPermission.Action.LIST, JndiPermission.Action.LIST_BINDINGS}));
        permissions.add((Permission)new JndiPermission("java:comp/-", new JndiPermission.Action[]{JndiPermission.Action.LOOKUP, JndiPermission.Action.LIST, JndiPermission.Action.LIST_BINDINGS}));
        permissions.add((Permission)new JndiPermission("java:module", new JndiPermission.Action[]{JndiPermission.Action.LOOKUP, JndiPermission.Action.LIST, JndiPermission.Action.LIST_BINDINGS}));
        permissions.add((Permission)new JndiPermission("java:module/-", new JndiPermission.Action[]{JndiPermission.Action.LOOKUP, JndiPermission.Action.LIST, JndiPermission.Action.LIST_BINDINGS}));
        permissions.add((Permission)new JndiPermission("java:app", new JndiPermission.Action[]{JndiPermission.Action.LOOKUP, JndiPermission.Action.LIST, JndiPermission.Action.LIST_BINDINGS}));
        permissions.add((Permission)new JndiPermission("java:app/-", new JndiPermission.Action[]{JndiPermission.Action.LOOKUP, JndiPermission.Action.LIST, JndiPermission.Action.LIST_BINDINGS}));
        permissions.add((Permission)new JndiPermission("java:global", new JndiPermission.Action[]{JndiPermission.Action.LOOKUP}));
        permissions.add((Permission)new JndiPermission("java:global/-", new JndiPermission.Action[]{JndiPermission.Action.LOOKUP}));
        permissions.add((Permission)new JndiPermission("java:jboss", new JndiPermission.Action[]{JndiPermission.Action.LOOKUP}));
        permissions.add((Permission)new JndiPermission("java:jboss/-", new JndiPermission.Action[]{JndiPermission.Action.LOOKUP}));
        permissions.add((Permission)new JndiPermission("java:/-", new JndiPermission.Action[]{JndiPermission.Action.LOOKUP}));
        DEFAULT_PERMISSIONS = permissions;
    }
}

