/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.objectfilter.impl;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.infinispan.objectfilter.FilterCallback;
import org.infinispan.objectfilter.FilterSubscription;
import org.infinispan.objectfilter.Matcher;
import org.infinispan.objectfilter.ObjectFilter;
import org.infinispan.objectfilter.impl.AcceptObjectFilter;
import org.infinispan.objectfilter.impl.FilterRegistry;
import org.infinispan.objectfilter.impl.FilterSubscriptionImpl;
import org.infinispan.objectfilter.impl.MetadataAdapter;
import org.infinispan.objectfilter.impl.ObjectFilterImpl;
import org.infinispan.objectfilter.impl.RejectObjectFilter;
import org.infinispan.objectfilter.impl.aggregation.FieldAccumulator;
import org.infinispan.objectfilter.impl.hql.FilterParsingResult;
import org.infinispan.objectfilter.impl.hql.JPQLParser;
import org.infinispan.objectfilter.impl.hql.ObjectPropertyHelper;
import org.infinispan.objectfilter.impl.logging.Log;
import org.infinispan.objectfilter.impl.predicateindex.MatcherEvalContext;
import org.infinispan.objectfilter.impl.syntax.ConstantBooleanExpr;
import org.infinispan.query.dsl.Query;
import org.infinispan.query.dsl.impl.BaseQuery;
import org.jboss.logging.Logger;

public abstract class BaseMatcher<TypeMetadata, AttributeMetadata, AttributeId extends Comparable<AttributeId>>
implements Matcher {
    private static final Log log = (Log)Logger.getMessageLogger(Log.class, (String)BaseMatcher.class.getName());
    private final ReentrantReadWriteLock readWriteLock = new ReentrantReadWriteLock();
    private final Lock read = this.readWriteLock.readLock();
    private final Lock write = this.readWriteLock.writeLock();
    protected final Map<TypeMetadata, FilterRegistry<TypeMetadata, AttributeMetadata, AttributeId>> filtersByType = new HashMap<TypeMetadata, FilterRegistry<TypeMetadata, AttributeMetadata, AttributeId>>();
    protected final ObjectPropertyHelper<TypeMetadata> propertyHelper;
    protected final JPQLParser<TypeMetadata> parser = new JPQLParser();

    protected BaseMatcher(ObjectPropertyHelper<TypeMetadata> propertyHelper) {
        this.propertyHelper = propertyHelper;
    }

    public ObjectPropertyHelper<TypeMetadata> getPropertyHelper() {
        return this.propertyHelper;
    }

    public JPQLParser<TypeMetadata> getParser() {
        return this.parser;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void match(Object userContext, Object eventType, Object instance) {
        if (instance == null) {
            throw new IllegalArgumentException("instance cannot be null");
        }
        this.read.lock();
        try {
            MatcherEvalContext<TypeMetadata, AttributeMetadata, AttributeId> ctx = this.startMultiTypeContext(userContext, eventType, instance);
            if (ctx != null) {
                ctx.process(ctx.getRootNode());
                ctx.notifySubscribers();
            }
        }
        finally {
            this.read.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void matchDelta(Object userContext, Object eventType, Object instanceOld, Object instanceNew, Object joiningEvent, Object updatedEvent, Object leavingEvent) {
        if (instanceOld == null && instanceNew == null) {
            throw new IllegalArgumentException("instances cannot be both null");
        }
        this.read.lock();
        try {
            MatcherEvalContext<TypeMetadata, AttributeMetadata, AttributeId> ctx1 = null;
            MatcherEvalContext<TypeMetadata, AttributeMetadata, AttributeId> ctx2 = null;
            if (instanceOld != null && (ctx1 = this.startMultiTypeContext(userContext, eventType, instanceOld)) != null) {
                ctx1.process(ctx1.getRootNode());
            }
            if (instanceNew != null && (ctx2 = this.startMultiTypeContext(userContext, eventType, instanceNew)) != null) {
                ctx2.process(ctx2.getRootNode());
            }
            if (ctx1 != null) {
                ctx1.notifyDeltaSubscribers(ctx2, joiningEvent, updatedEvent, leavingEvent);
            } else if (ctx2 != null) {
                ctx2.notifyDeltaSubscribers(null, leavingEvent, updatedEvent, joiningEvent);
            }
        }
        finally {
            this.read.unlock();
        }
    }

    @Override
    public ObjectFilter getObjectFilter(Query query) {
        return this.getObjectFilter(((BaseQuery)query).getJPAQuery(), null);
    }

    @Override
    public ObjectFilter getObjectFilter(String jpaQuery) {
        return this.getObjectFilter(jpaQuery, null);
    }

    @Override
    public ObjectFilter getObjectFilter(String jpaQuery, List<FieldAccumulator> acc) {
        FilterParsingResult<TypeMetadata> parsingResult = this.getParser().parse(jpaQuery, this.getPropertyHelper());
        this.disallowGroupingAndAggregations(parsingResult);
        if (parsingResult.getWhereClause() == ConstantBooleanExpr.FALSE) {
            return new RejectObjectFilter<TypeMetadata>(null, parsingResult);
        }
        MetadataAdapter<TypeMetadata, AttributeMetadata, AttributeId> metadataAdapter = this.createMetadataAdapter(parsingResult.getTargetEntityMetadata());
        if ((parsingResult.getWhereClause() == null || parsingResult.getWhereClause() == ConstantBooleanExpr.TRUE) && parsingResult.getSortFields() == null && parsingResult.getProjectedPaths() == null) {
            return new AcceptObjectFilter<TypeMetadata, AttributeMetadata, AttributeId>(null, this, metadataAdapter, parsingResult);
        }
        FieldAccumulator[] accumulators = acc != null ? acc.toArray(new FieldAccumulator[acc.size()]) : null;
        return new ObjectFilterImpl<TypeMetadata, AttributeMetadata, AttributeId>(this, metadataAdapter, parsingResult, accumulators);
    }

    @Override
    public ObjectFilter getObjectFilter(FilterSubscription filterSubscription) {
        FilterSubscriptionImpl filterSubscriptionImpl = (FilterSubscriptionImpl)filterSubscription;
        ObjectFilter objectFilter = this.getObjectFilter(filterSubscriptionImpl.getQueryString());
        return filterSubscriptionImpl.getNamedParameters() != null ? objectFilter.withParameters(filterSubscriptionImpl.getNamedParameters()) : objectFilter;
    }

    @Override
    public FilterSubscription registerFilter(Query query, FilterCallback callback, Object ... eventType) {
        BaseQuery baseQuery = (BaseQuery)query;
        return this.registerFilter(baseQuery.getJPAQuery(), baseQuery.getNamedParameters(), callback, eventType);
    }

    @Override
    public FilterSubscription registerFilter(String jpaQuery, FilterCallback callback, Object ... eventType) {
        return this.registerFilter(jpaQuery, null, callback, eventType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FilterSubscription registerFilter(String jpaQuery, Map<String, Object> namedParameters, FilterCallback callback, Object ... eventType) {
        FilterParsingResult<TypeMetadata> parsingResult = this.getParser().parse(jpaQuery, this.getPropertyHelper());
        this.disallowGroupingAndAggregations(parsingResult);
        this.write.lock();
        try {
            FilterRegistry<TypeMetadata, AttributeMetadata, AttributeId> filterRegistry = this.filtersByType.get(parsingResult.getTargetEntityMetadata());
            if (filterRegistry == null) {
                filterRegistry = new FilterRegistry<TypeMetadata, AttributeMetadata, AttributeId>(this.createMetadataAdapter(parsingResult.getTargetEntityMetadata()), true);
                this.filtersByType.put(filterRegistry.getMetadataAdapter().getTypeMetadata(), filterRegistry);
            }
            FilterSubscriptionImpl<TypeMetadata, AttributeMetadata, AttributeId> filterSubscriptionImpl = filterRegistry.addFilter(jpaQuery, namedParameters, parsingResult.getWhereClause(), parsingResult.getProjections(), parsingResult.getProjectedTypes(), parsingResult.getSortFields(), callback, eventType);
            return filterSubscriptionImpl;
        }
        finally {
            this.write.unlock();
        }
    }

    private void disallowGroupingAndAggregations(FilterParsingResult<TypeMetadata> parsingResult) {
        if (parsingResult.hasGroupingOrAggregations()) {
            throw log.getFiltersCannotUseGroupingOrAggregationException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterFilter(FilterSubscription filterSubscription) {
        FilterSubscriptionImpl filterSubscriptionImpl = (FilterSubscriptionImpl)filterSubscription;
        this.write.lock();
        try {
            FilterRegistry<TypeMetadata, AttributeMetadata, AttributeId> filterRegistry = this.filtersByType.get(filterSubscriptionImpl.getMetadataAdapter().getTypeMetadata());
            if (filterRegistry == null) {
                throw new IllegalStateException("Reached illegal state");
            }
            filterRegistry.removeFilter(filterSubscription);
            if (filterRegistry.getFilterSubscriptions().isEmpty()) {
                this.filtersByType.remove(filterRegistry.getMetadataAdapter().getTypeMetadata());
            }
        }
        finally {
            this.write.unlock();
        }
    }

    protected abstract MatcherEvalContext<TypeMetadata, AttributeMetadata, AttributeId> startMultiTypeContext(Object var1, Object var2, Object var3);

    protected abstract MatcherEvalContext<TypeMetadata, AttributeMetadata, AttributeId> startSingleTypeContext(Object var1, Object var2, Object var3, MetadataAdapter<TypeMetadata, AttributeMetadata, AttributeId> var4);

    protected abstract MetadataAdapter<TypeMetadata, AttributeMetadata, AttributeId> createMetadataAdapter(TypeMetadata var1);

    protected abstract FilterRegistry<TypeMetadata, AttributeMetadata, AttributeId> getFilterRegistryForType(TypeMetadata var1);

    protected Object convert(Object instance) {
        return instance;
    }
}

