/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.core.configuration;

import java.util.Collections;
import java.util.Set;
import org.infinispan.commons.configuration.Builder;
import org.infinispan.server.core.configuration.ProtocolServerConfiguration;
import org.infinispan.server.core.configuration.ProtocolServerConfigurationChildBuilder;
import org.infinispan.server.core.configuration.SslConfigurationBuilder;
import org.infinispan.server.core.logging.JavaLog;
import org.infinispan.util.logging.LogFactory;

public abstract class ProtocolServerConfigurationBuilder<T extends ProtocolServerConfiguration, S extends ProtocolServerConfigurationChildBuilder<T, S>>
implements ProtocolServerConfigurationChildBuilder<T, S>,
Builder<T> {
    private static final JavaLog log = (JavaLog)LogFactory.getLog(ProtocolServerConfigurationBuilder.class, JavaLog.class);
    protected String defaultCacheName = "___defaultcache";
    protected String name = "";
    protected String host = "127.0.0.1";
    protected int port = -1;
    protected int idleTimeout = -1;
    protected int recvBufSize = 0;
    protected int sendBufSize = 0;
    protected final SslConfigurationBuilder ssl;
    protected boolean tcpNoDelay = true;
    protected int workerThreads = 2 * Runtime.getRuntime().availableProcessors();
    protected Set<String> ignoredCaches = Collections.EMPTY_SET;

    protected ProtocolServerConfigurationBuilder(int port) {
        this.port = port;
        this.ssl = new SslConfigurationBuilder(this);
    }

    @Override
    public S ignoredCaches(Set<String> ignoredCaches) {
        this.ignoredCaches = ignoredCaches;
        return (S)((ProtocolServerConfigurationChildBuilder)this.self());
    }

    @Override
    public S defaultCacheName(String defaultCacheName) {
        this.defaultCacheName = defaultCacheName;
        return (S)((ProtocolServerConfigurationChildBuilder)this.self());
    }

    @Override
    public S name(String name) {
        this.name = name;
        return (S)((ProtocolServerConfigurationChildBuilder)this.self());
    }

    @Override
    public S host(String host) {
        this.host = host;
        return (S)((ProtocolServerConfigurationChildBuilder)this.self());
    }

    @Override
    public S port(int port) {
        this.port = port;
        return (S)((ProtocolServerConfigurationChildBuilder)this.self());
    }

    @Override
    public S idleTimeout(int idleTimeout) {
        this.idleTimeout = idleTimeout;
        return (S)((ProtocolServerConfigurationChildBuilder)this.self());
    }

    @Override
    public S tcpNoDelay(boolean tcpNoDelay) {
        this.tcpNoDelay = tcpNoDelay;
        return (S)((ProtocolServerConfigurationChildBuilder)this.self());
    }

    @Override
    public S recvBufSize(int recvBufSize) {
        this.recvBufSize = recvBufSize;
        return (S)((ProtocolServerConfigurationChildBuilder)this.self());
    }

    @Override
    public S sendBufSize(int sendBufSize) {
        this.sendBufSize = sendBufSize;
        return (S)((ProtocolServerConfigurationChildBuilder)this.self());
    }

    @Override
    public SslConfigurationBuilder ssl() {
        return this.ssl;
    }

    @Override
    public S workerThreads(int workerThreads) {
        this.workerThreads = workerThreads;
        return (S)((ProtocolServerConfigurationChildBuilder)this.self());
    }

    public void validate() {
        this.ssl.validate();
        if (this.idleTimeout < -1) {
            throw log.illegalIdleTimeout(this.idleTimeout);
        }
        if (this.sendBufSize < 0) {
            throw log.illegalSendBufferSize(this.sendBufSize);
        }
        if (this.recvBufSize < 0) {
            throw log.illegalReceiveBufferSize(this.recvBufSize);
        }
        if (this.workerThreads < 0) {
            throw log.illegalWorkerThreads(this.workerThreads);
        }
    }

    public Builder<?> read(T template) {
        this.defaultCacheName = ((ProtocolServerConfiguration)template).defaultCacheName();
        this.name = ((ProtocolServerConfiguration)template).name();
        this.host = ((ProtocolServerConfiguration)template).host();
        this.port = ((ProtocolServerConfiguration)template).port();
        this.idleTimeout = ((ProtocolServerConfiguration)template).idleTimeout();
        this.recvBufSize = ((ProtocolServerConfiguration)template).recvBufSize();
        this.sendBufSize = ((ProtocolServerConfiguration)template).sendBufSize();
        this.tcpNoDelay = ((ProtocolServerConfiguration)template).tcpNoDelay();
        this.workerThreads = ((ProtocolServerConfiguration)template).workerThreads();
        this.ssl.read(((ProtocolServerConfiguration)template).ssl());
        this.ignoredCaches = ((ProtocolServerConfiguration)template).ignoredCaches();
        return this;
    }
}

