/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http2;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.DefaultByteBufHolder;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.http2.Http2Error;
import io.netty.handler.codec.http2.Http2GoAwayFrame;

public final class DefaultHttp2GoAwayFrame
extends DefaultByteBufHolder
implements Http2GoAwayFrame {
    private final long errorCode;
    private int extraStreamIds;

    public DefaultHttp2GoAwayFrame(Http2Error error) {
        this(error.code());
    }

    public DefaultHttp2GoAwayFrame(long errorCode) {
        this(errorCode, Unpooled.EMPTY_BUFFER);
    }

    public DefaultHttp2GoAwayFrame(Http2Error error, ByteBuf content) {
        this(error.code(), content);
    }

    public DefaultHttp2GoAwayFrame(long errorCode, ByteBuf content) {
        super(content);
        this.errorCode = errorCode;
    }

    @Override
    public long errorCode() {
        return this.errorCode;
    }

    @Override
    public int extraStreamIds() {
        return this.extraStreamIds;
    }

    @Override
    public DefaultHttp2GoAwayFrame setExtraStreamIds(int extraStreamIds) {
        if (extraStreamIds < 0) {
            throw new IllegalArgumentException("extraStreamIds must be non-negative");
        }
        this.extraStreamIds = extraStreamIds;
        return this;
    }

    @Override
    public DefaultHttp2GoAwayFrame copy() {
        return new DefaultHttp2GoAwayFrame(this.errorCode, this.content().copy()).setExtraStreamIds(this.extraStreamIds);
    }

    @Override
    public DefaultHttp2GoAwayFrame duplicate() {
        return new DefaultHttp2GoAwayFrame(this.errorCode, this.content().duplicate()).setExtraStreamIds(this.extraStreamIds);
    }

    @Override
    public DefaultHttp2GoAwayFrame retain() {
        super.retain();
        return this;
    }

    @Override
    public DefaultHttp2GoAwayFrame retain(int increment) {
        super.retain(increment);
        return this;
    }

    @Override
    public String toString() {
        return "DefaultHttp2GoAwayFrame(errorCode=" + this.errorCode + ", content=" + this.content() + ", extraStreamIds=" + this.extraStreamIds + ")";
    }

    @Override
    public DefaultHttp2GoAwayFrame touch() {
        super.touch();
        return this;
    }

    @Override
    public DefaultHttp2GoAwayFrame touch(Object hint) {
        super.touch(hint);
        return this;
    }

    public boolean equals(Object o) {
        if (!(o instanceof DefaultHttp2GoAwayFrame)) {
            return false;
        }
        DefaultHttp2GoAwayFrame other = (DefaultHttp2GoAwayFrame)o;
        return super.equals(o) && this.errorCode == other.errorCode && this.content().equals(other.content()) && this.extraStreamIds == other.extraStreamIds;
    }

    public int hashCode() {
        int hash = 237395317;
        hash = hash * 31 + (int)(this.errorCode ^ this.errorCode >>> 32);
        hash = hash * 31 + this.content().hashCode();
        hash = hash * 31 + this.extraStreamIds;
        return hash;
    }
}

