/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.jpa.internal.enhance;

import java.lang.instrument.IllegalClassFormatException;
import java.security.ProtectionDomain;
import javassist.CtClass;
import javassist.CtField;
import javax.persistence.spi.ClassTransformer;
import org.hibernate.bytecode.enhance.spi.EnhancementContext;
import org.hibernate.bytecode.enhance.spi.Enhancer;

public class EnhancingClassTransformerImpl
implements ClassTransformer {
    private final EnhancementContext enhancementContext;

    public EnhancingClassTransformerImpl(EnhancementContext enhancementContext) {
        this.enhancementContext = enhancementContext;
    }

    public byte[] transform(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws IllegalClassFormatException {
        try {
            Enhancer enhancer = new Enhancer((EnhancementContext)new EnhancementContextWrapper(this.enhancementContext, loader));
            return enhancer.enhance(className, classfileBuffer);
        }
        catch (Exception e) {
            throw new IllegalClassFormatException("Error performing enhancement of " + className){

                @Override
                public synchronized Throwable getCause() {
                    return e;
                }
            };
        }
    }

    private class EnhancementContextWrapper
    implements EnhancementContext {
        private final ClassLoader loadingClassloader;
        private final EnhancementContext wrappedContext;

        private EnhancementContextWrapper(EnhancementContext wrappedContext, ClassLoader loadingClassloader) {
            this.wrappedContext = wrappedContext;
            this.loadingClassloader = loadingClassloader;
        }

        public ClassLoader getLoadingClassLoader() {
            return this.loadingClassloader;
        }

        public boolean isEntityClass(CtClass classDescriptor) {
            return this.wrappedContext.isEntityClass(classDescriptor);
        }

        public boolean isCompositeClass(CtClass classDescriptor) {
            return this.wrappedContext.isCompositeClass(classDescriptor);
        }

        public boolean doBiDirectionalAssociationManagement(CtField field) {
            return this.wrappedContext.doBiDirectionalAssociationManagement(field);
        }

        public boolean doDirtyCheckingInline(CtClass classDescriptor) {
            return this.wrappedContext.doDirtyCheckingInline(classDescriptor);
        }

        public boolean doExtendedEnhancement(CtClass classDescriptor) {
            return this.wrappedContext.doExtendedEnhancement(classDescriptor);
        }

        public boolean hasLazyLoadableAttributes(CtClass classDescriptor) {
            return this.wrappedContext.hasLazyLoadableAttributes(classDescriptor);
        }

        public boolean isPersistentField(CtField ctField) {
            return this.wrappedContext.isPersistentField(ctField);
        }

        public CtField[] order(CtField[] persistentFields) {
            return this.wrappedContext.order(persistentFields);
        }

        public boolean isLazyLoadable(CtField field) {
            return this.wrappedContext.isLazyLoadable(field);
        }

        public boolean isMappedCollection(CtField field) {
            return this.wrappedContext.isMappedCollection(field);
        }
    }
}

