/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend;

import java.io.Serializable;
import java.util.Map;
import org.apache.lucene.document.Document;
import org.hibernate.search.backend.IndexWorkVisitor;

public abstract class LuceneWork {
    private final Document document;
    private final Class<?> entityClass;
    private final String tenantId;
    private final Serializable id;
    private final String idInString;

    public LuceneWork(String tenantId, Serializable id, String idInString, Class<?> entity) {
        this(tenantId, id, idInString, entity, null);
    }

    public LuceneWork(String tenantId, Serializable id, String idInString, Class<?> entity, Document document) {
        this.tenantId = tenantId;
        this.id = id;
        this.idInString = idInString;
        this.entityClass = entity;
        this.document = document;
    }

    public Document getDocument() {
        return this.document;
    }

    public Class<?> getEntityClass() {
        return this.entityClass;
    }

    public Serializable getId() {
        return this.id;
    }

    public String getIdInString() {
        return this.idInString;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public abstract <P, R> R acceptIndexWorkVisitor(IndexWorkVisitor<P, R> var1, P var2);

    public Map<String, String> getFieldToAnalyzerMap() {
        return null;
    }
}

