/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.query.dsl.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.FuzzyQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.WildcardQuery;
import org.hibernate.search.analyzer.impl.LuceneAnalyzerReference;
import org.hibernate.search.analyzer.impl.RemoteAnalyzerReference;
import org.hibernate.search.bridge.FieldBridge;
import org.hibernate.search.bridge.builtin.impl.NullEncodingTwoWayFieldBridge;
import org.hibernate.search.bridge.spi.ConversionContext;
import org.hibernate.search.bridge.spi.IgnoreAnalyzerBridge;
import org.hibernate.search.bridge.util.impl.ContextualExceptionBridgeHelper;
import org.hibernate.search.bridge.util.impl.NumericFieldUtils;
import org.hibernate.search.engine.spi.DocumentBuilderIndexedEntity;
import org.hibernate.search.exception.AssertionFailure;
import org.hibernate.search.exception.SearchException;
import org.hibernate.search.query.dsl.TermTermination;
import org.hibernate.search.query.dsl.impl.FieldContext;
import org.hibernate.search.query.dsl.impl.FieldsContext;
import org.hibernate.search.query.dsl.impl.Helper;
import org.hibernate.search.query.dsl.impl.QueryBuildingContext;
import org.hibernate.search.query.dsl.impl.QueryCustomizer;
import org.hibernate.search.query.dsl.impl.RemoteMatchQuery;
import org.hibernate.search.query.dsl.impl.TermQueryContext;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public class ConnectedMultiFieldsTermQueryBuilder
implements TermTermination {
    private static final Log log = LoggerFactory.make();
    private final Object value;
    private final QueryCustomizer queryCustomizer;
    private final TermQueryContext termContext;
    private final FieldsContext fieldsContext;
    private final QueryBuildingContext queryContext;

    public ConnectedMultiFieldsTermQueryBuilder(TermQueryContext termContext, Object value, FieldsContext fieldsContext, QueryCustomizer queryCustomizer, QueryBuildingContext queryContext) {
        this.termContext = termContext;
        this.value = value;
        this.queryContext = queryContext;
        this.queryCustomizer = queryCustomizer;
        this.fieldsContext = fieldsContext;
    }

    @Override
    public Query createQuery() {
        int size = this.fieldsContext.size();
        ContextualExceptionBridgeHelper conversionContext = new ContextualExceptionBridgeHelper();
        if (size == 1) {
            return this.queryCustomizer.setWrappedQuery(this.createQuery(this.fieldsContext.getFirst(), conversionContext)).createQuery();
        }
        BooleanQuery.Builder aggregatedFieldsQueryBuilder = new BooleanQuery.Builder();
        for (FieldContext fieldContext : this.fieldsContext) {
            aggregatedFieldsQueryBuilder.add(this.createQuery(fieldContext, conversionContext), BooleanClause.Occur.SHOULD);
        }
        BooleanQuery aggregatedFieldsQuery = aggregatedFieldsQueryBuilder.build();
        return this.queryCustomizer.setWrappedQuery((Query)aggregatedFieldsQuery).createQuery();
    }

    private Query createQuery(FieldContext fieldContext, ConversionContext conversionContext) {
        boolean applyTokenization;
        FieldBridge fieldBridge;
        DocumentBuilderIndexedEntity documentBuilder = this.queryContext.getDocumentBuilder();
        FieldBridge fieldBridge2 = fieldBridge = fieldContext.getFieldBridge() != null ? fieldContext.getFieldBridge() : documentBuilder.getBridge(fieldContext.getField());
        if (this.value != null) {
            applyTokenization = fieldContext.applyAnalyzer();
            if (NumericFieldUtils.isNumericFieldBridge(fieldBridge)) {
                return NumericFieldUtils.createExactMatchQuery(fieldContext.getField(), this.value);
            }
        } else {
            applyTokenization = false;
            if (fieldBridge instanceof NullEncodingTwoWayFieldBridge) {
                NullEncodingTwoWayFieldBridge nullEncodingBridge = (NullEncodingTwoWayFieldBridge)fieldBridge;
                this.validateNullValueIsSearchable(fieldContext);
                return nullEncodingBridge.buildNullQuery(fieldContext.getField());
            }
        }
        this.validateNullValueIsSearchable(fieldContext);
        String searchTerm = this.buildSearchTerm(fieldContext, documentBuilder, conversionContext);
        Query perFieldQuery = !applyTokenization || fieldBridge instanceof IgnoreAnalyzerBridge || fieldBridge instanceof NullEncodingTwoWayFieldBridge && ((NullEncodingTwoWayFieldBridge)fieldBridge).unwrap() instanceof IgnoreAnalyzerBridge ? this.createTermQuery(fieldContext, searchTerm) : (this.queryContext.getQueryAnalyzerReference().is(RemoteAnalyzerReference.class) ? this.createRemoteQuery(fieldContext, searchTerm) : this.createLuceneQuery(fieldContext, searchTerm));
        return fieldContext.getFieldCustomizer().setWrappedQuery(perFieldQuery).createQuery();
    }

    private void validateNullValueIsSearchable(FieldContext fieldContext) {
        if (fieldContext.isIgnoreFieldBridge() && this.value == null) {
            throw log.unableToSearchOnNullValueWithoutFieldBridge(fieldContext.getField());
        }
    }

    private String buildSearchTerm(FieldContext fieldContext, DocumentBuilderIndexedEntity documentBuilder, ConversionContext conversionContext) {
        if (fieldContext.isIgnoreFieldBridge()) {
            String stringform = this.value.toString();
            if (stringform == null) {
                throw new SearchException("When ignoreFieldBridge() is enabled, toString() on the value is used: the returned string must not be null: on field " + fieldContext.getField());
            }
            return stringform;
        }
        return fieldContext.objectToString(documentBuilder, this.value, conversionContext);
    }

    private Query createTermQuery(FieldContext fieldContext, String term) {
        TermQuery query;
        String fieldName = fieldContext.getField();
        switch (this.termContext.getApproximation()) {
            case EXACT: {
                query = new TermQuery(new Term(fieldName, term));
                break;
            }
            case WILDCARD: {
                query = new WildcardQuery(new Term(fieldName, term));
                break;
            }
            case FUZZY: {
                int maxEditDistance = this.getMaxEditDistance(term);
                query = new FuzzyQuery(new Term(fieldName, term), maxEditDistance, this.termContext.getPrefixLength());
                break;
            }
            default: {
                throw new AssertionFailure("Unknown approximation: " + (Object)((Object)this.termContext.getApproximation()));
            }
        }
        return query;
    }

    private int getMaxEditDistance(String term) {
        int maxEditDistance = this.termContext.getThreshold() != null ? FuzzyQuery.floatToEdits((float)this.termContext.getThreshold().floatValue(), (int)term.length()) : this.termContext.getMaxEditDistance();
        return maxEditDistance;
    }

    private Query createLuceneQuery(FieldContext fieldContext, String searchTerm) {
        Query query;
        List<String> terms = this.getAllTermsFromText(fieldContext.getField(), searchTerm, this.queryContext.getQueryAnalyzerReference().unwrap(LuceneAnalyzerReference.class).getAnalyzer());
        if (terms.size() == 0) {
            throw log.queryWithNoTermsAfterAnalysis(fieldContext.getField(), searchTerm);
        }
        if (terms.size() == 1) {
            query = this.createTermQuery(fieldContext, terms.get(0));
        } else {
            BooleanQuery.Builder booleanQueryBuilder = new BooleanQuery.Builder();
            for (String localTerm : terms) {
                Query termQuery = this.createTermQuery(fieldContext, localTerm);
                booleanQueryBuilder.add(termQuery, BooleanClause.Occur.SHOULD);
            }
            query = booleanQueryBuilder.build();
        }
        return query;
    }

    private Query createRemoteQuery(FieldContext fieldContext, String searchTerm) {
        if (this.termContext.getApproximation() == TermQueryContext.Approximation.WILDCARD) {
            return new WildcardQuery(new Term(fieldContext.getField(), searchTerm));
        }
        RemoteMatchQuery.Builder queryBuilder = new RemoteMatchQuery.Builder();
        queryBuilder.field(fieldContext.getField()).searchTerms(searchTerm);
        RemoteAnalyzerReference analyzerReference = this.queryContext.getQueryAnalyzerReference().unwrap(RemoteAnalyzerReference.class);
        if (analyzerReference != null) {
            queryBuilder.analyzerReference(analyzerReference);
        }
        if (this.termContext.getApproximation() == TermQueryContext.Approximation.FUZZY) {
            queryBuilder.maxEditDistance(this.getMaxEditDistance(searchTerm));
        }
        return queryBuilder.build();
    }

    private List<String> getAllTermsFromText(String fieldName, String localText, Analyzer analyzer) {
        List<String> terms = new ArrayList<String>();
        if (this.termContext.getApproximation() == TermQueryContext.Approximation.WILDCARD) {
            terms.add(localText);
        } else {
            try {
                terms = Helper.getAllTermsFromText(fieldName, localText, analyzer);
            }
            catch (IOException e) {
                throw new AssertionFailure("IO exception while reading String stream??", e);
            }
        }
        return terms;
    }
}

