/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.hotrod.logging;

import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.util.AttributeKey;
import org.infinispan.server.hotrod.CacheDecodeContext;
import org.infinispan.server.hotrod.ErrorResponse;
import org.infinispan.server.hotrod.HotRodOperation;
import org.infinispan.server.hotrod.OperationResponse;

@ChannelHandler.Sharable
public class LoggingContextHandler
extends ChannelDuplexHandler {
    private static final LoggingContextHandler INSTANCE = new LoggingContextHandler();
    public static final AttributeKey<CacheDecodeContext> DECODE_CONTEXT_KEY = AttributeKey.newInstance((String)"__decodeContextKey");
    public static final AttributeKey<HotRodOperation> OPERATION_KEY = AttributeKey.newInstance((String)"__operationKey");
    public static final AttributeKey<String> CACHE_NAME_KEY = AttributeKey.newInstance((String)"__cacheNameKey");
    public static final AttributeKey<String> EXCEPTION_MESSAGE_KEY = AttributeKey.newInstance((String)"__exceptionMessageKey");

    public static final LoggingContextHandler getInstance() {
        return INSTANCE;
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (msg instanceof CacheDecodeContext) {
            ctx.channel().attr(DECODE_CONTEXT_KEY).set((Object)((CacheDecodeContext)msg));
            ctx.channel().attr(EXCEPTION_MESSAGE_KEY).remove();
        }
        super.channelRead(ctx, msg);
    }

    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        if (msg instanceof ErrorResponse) {
            ErrorResponse errorResponse = (ErrorResponse)msg;
            ctx.channel().attr(OPERATION_KEY).set((Object)OperationResponse.fromResponse(errorResponse.operation()));
            ctx.channel().attr(CACHE_NAME_KEY).set((Object)errorResponse.cacheName());
            ctx.channel().attr(EXCEPTION_MESSAGE_KEY).set((Object)errorResponse.msg());
        }
        super.write(ctx, msg, promise);
    }
}

