/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.hotrod.transport;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOutboundHandler;
import java.util.concurrent.ExecutorService;
import org.infinispan.commons.logging.LogFactory;
import org.infinispan.server.core.ProtocolServer;
import org.infinispan.server.core.transport.NettyChannelInitializer;
import org.infinispan.server.core.transport.NettyTransport;
import org.infinispan.server.hotrod.AuthenticationHandler;
import org.infinispan.server.hotrod.ContextHandler;
import org.infinispan.server.hotrod.HotRodExceptionHandler;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.server.hotrod.LocalContextHandler;
import org.infinispan.server.hotrod.configuration.HotRodServerConfiguration;
import org.infinispan.server.hotrod.logging.HotRodAccessLoggingHandler;
import org.infinispan.server.hotrod.logging.JavaLog;
import org.infinispan.server.hotrod.logging.LoggingContextHandler;
import org.jboss.logging.BasicLogger;
import scala.Function0;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001i3A!\u0001\u0002\u0001\u001b\tA\u0002j\u001c;S_\u0012\u001c\u0005.\u00198oK2Le.\u001b;jC2L'0\u001a:\u000b\u0005\r!\u0011!\u0003;sC:\u001c\bo\u001c:u\u0015\t)a!\u0001\u0004i_R\u0014x\u000e\u001a\u0006\u0003\u000f!\taa]3sm\u0016\u0014(BA\u0005\u000b\u0003)IgNZ5oSN\u0004\u0018M\u001c\u0006\u0002\u0017\u0005\u0019qN]4\u0004\u0001M\u0011\u0001A\u0004\t\u0004\u001fM)R\"\u0001\t\u000b\u0005\r\t\"B\u0001\n\u0007\u0003\u0011\u0019wN]3\n\u0005Q\u0001\"a\u0006(fiRL8\t[1o]\u0016d\u0017J\\5uS\u0006d\u0017N_3s!\t1\u0012$D\u0001\u0018\u0015\tAB!A\u0007d_:4\u0017nZ;sCRLwN\\\u0005\u00035]\u0011\u0011\u0004S8u%>$7+\u001a:wKJ\u001cuN\u001c4jOV\u0014\u0018\r^5p]\"AA\u0004\u0001BC\u0002\u0013\u0005Q$\u0001\u0007i_R\u0014v\u000eZ*feZ,'/F\u0001\u001f!\ty\u0002%D\u0001\u0005\u0013\t\tCA\u0001\u0007I_R\u0014v\u000eZ*feZ,'\u000f\u0003\u0005$\u0001\t\u0005\t\u0015!\u0003\u001f\u00035Aw\u000e\u001e*pIN+'O^3sA!A1\u0001\u0001B\u0001J\u0003%Q\u0005E\u0002'S-j\u0011a\n\u0006\u0002Q\u0005)1oY1mC&\u0011!f\n\u0002\ty\tLh.Y7f}A\u0011q\u0002L\u0005\u0003[A\u0011aBT3uif$&/\u00198ta>\u0014H\u000f\u0003\u00050\u0001\t\u0005\t\u0015!\u00031\u0003\u001d)gnY8eKJ\u0004\"!\r\u001d\u000e\u0003IR!a\r\u001b\u0002\u000f\rD\u0017M\u001c8fY*\u0011QGN\u0001\u0006]\u0016$H/\u001f\u0006\u0002o\u0005\u0011\u0011n\\\u0005\u0003sI\u0012ac\u00115b]:,GnT;uE>,h\u000e\u001a%b]\u0012dWM\u001d\u0005\tw\u0001\u0011\t\u0011)A\u0005y\u0005AQ\r_3dkR|'\u000f\u0005\u0002>\t6\taH\u0003\u0002@\u0001\u0006Q1m\u001c8dkJ\u0014XM\u001c;\u000b\u0005\u0005\u0013\u0015\u0001B;uS2T\u0011aQ\u0001\u0005U\u00064\u0018-\u0003\u0002F}\tyQ\t_3dkR|'oU3sm&\u001cW\rC\u0003H\u0001\u0011\u0005\u0001*\u0001\u0004=S:LGO\u0010\u000b\u0006\u0013.cUJ\u0014\t\u0003\u0015\u0002i\u0011A\u0001\u0005\u00069\u0019\u0003\rA\b\u0005\u0007\u0007\u0019#\t\u0019A\u0013\t\u000b=2\u0005\u0019\u0001\u0019\t\u000bm2\u0005\u0019\u0001\u001f\t\u000bA\u0003A\u0011I)\u0002\u0017%t\u0017\u000e^\"iC:tW\r\u001c\u000b\u0003%V\u0003\"AJ*\n\u0005Q;#\u0001B+oSRDQAV(A\u0002]\u000b!a\u00195\u0011\u0005EB\u0016BA-3\u0005\u001d\u0019\u0005.\u00198oK2\u0004")
public class HotRodChannelInitializer
extends NettyChannelInitializer<HotRodServerConfiguration> {
    private final HotRodServer hotRodServer;
    private final ExecutorService executor;

    public HotRodServer hotRodServer() {
        return this.hotRodServer;
    }

    public void initChannel(Channel ch) {
        super.initChannel(ch);
        AuthenticationHandler authHandler = ((HotRodServerConfiguration)this.server.getConfiguration()).authentication().enabled() ? new AuthenticationHandler(this.hotRodServer()) : null;
        Object object = authHandler == null ? BoxedUnit.UNIT : ch.pipeline().addLast("authentication-1", (ChannelHandler)authHandler);
        ch.pipeline().addLast("local-handler", (ChannelHandler)new LocalContextHandler(this.transport));
        ch.pipeline().addLast("handler", (ChannelHandler)new ContextHandler(this.hotRodServer(), this.transport, this.executor));
        ch.pipeline().addLast("exception", (ChannelHandler)new HotRodExceptionHandler());
        if (((BasicLogger)LogFactory.getLog(HotRodAccessLoggingHandler.class, JavaLog.class)).isTraceEnabled()) {
            ch.pipeline().addBefore("decoder", "logging", (ChannelHandler)new HotRodAccessLoggingHandler());
            ch.pipeline().addAfter("encoder", "logging-context", (ChannelHandler)LoggingContextHandler.getInstance());
        }
    }

    public HotRodChannelInitializer(HotRodServer hotRodServer, Function0<NettyTransport> transport, ChannelOutboundHandler encoder, ExecutorService executor) {
        this.hotRodServer = hotRodServer;
        this.executor = executor;
        super((ProtocolServer)hotRodServer, (NettyTransport)transport.apply(), encoder);
    }
}

