/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.core;

import java.net.InetSocketAddress;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.logging.LogFactory;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.factories.components.ManageableComponentMetadata;
import org.infinispan.jmx.JmxUtil;
import org.infinispan.jmx.ResourceDMBean;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.server.core.AbstractCacheIgnoreAware;
import org.infinispan.server.core.LifecycleCallbacks;
import org.infinispan.server.core.ProtocolServer;
import org.infinispan.server.core.configuration.ProtocolServerConfiguration;
import org.infinispan.server.core.logging.Log;
import org.infinispan.server.core.transport.NettyTransport;

public abstract class AbstractProtocolServer<A extends ProtocolServerConfiguration>
extends AbstractCacheIgnoreAware
implements ProtocolServer<A> {
    private final Log log = (Log)LogFactory.getLog(this.getClass(), Log.class);
    private final String protocolName;
    protected NettyTransport transport;
    protected EmbeddedCacheManager cacheManager;
    protected A configuration;
    private ObjectName transportObjName;
    private MBeanServer mbeanServer;

    protected AbstractProtocolServer(String protocolName) {
        this.protocolName = protocolName;
    }

    protected void startInternal(A configuration, EmbeddedCacheManager cacheManager) {
        this.configuration = configuration;
        this.cacheManager = cacheManager;
        if (this.log.isDebugEnabled()) {
            this.log.debugf("Starting server with configuration: %s", configuration);
        }
        this.startDefaultCache();
        this.startTransport();
    }

    @Override
    public final void start(A configuration, EmbeddedCacheManager cacheManager) {
        try {
            ((ProtocolServerConfiguration)configuration).ignoredCaches().forEach(this::ignoreCache);
            this.startInternal(configuration, cacheManager);
        }
        catch (RuntimeException t) {
            this.stop();
            throw t;
        }
    }

    protected void startTransport() {
        InetSocketAddress address = new InetSocketAddress(((ProtocolServerConfiguration)this.configuration).host(), ((ProtocolServerConfiguration)this.configuration).port());
        this.transport = new NettyTransport(address, (ProtocolServerConfiguration)this.configuration, this.getQualifiedName(), this.cacheManager);
        this.transport.initializeHandler(this.getInitializer());
        this.registerTransportMBean();
        this.transport.start();
    }

    protected void registerTransportMBean() {
        GlobalConfiguration globalCfg = this.cacheManager.getCacheManagerConfiguration();
        this.mbeanServer = JmxUtil.lookupMBeanServer((GlobalConfiguration)globalCfg);
        String groupName = String.format("type=Server,name=%s", this.getQualifiedName());
        String jmxDomain = JmxUtil.buildJmxDomain((GlobalConfiguration)globalCfg, (MBeanServer)this.mbeanServer, (String)groupName);
        ManageableComponentMetadata meta = LifecycleCallbacks.componentMetadataRepo.findComponentMetadata(this.transport.getClass()).toManageableComponentMetadata();
        try {
            ResourceDMBean dynamicMBean = new ResourceDMBean((Object)this.transport, meta);
            this.transportObjName = new ObjectName(String.format("%s:%s,component=%s", jmxDomain, groupName, meta.getJmxObjectName()));
            JmxUtil.registerMBean((Object)dynamicMBean, (ObjectName)this.transportObjName, (MBeanServer)this.mbeanServer);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected void unregisterTransportMBean() throws Exception {
        if (this.mbeanServer != null && this.transportObjName != null) {
            JmxUtil.unregisterMBean((ObjectName)this.transportObjName, (MBeanServer)this.mbeanServer);
        }
    }

    protected String getQualifiedName() {
        return this.protocolName + (((ProtocolServerConfiguration)this.configuration).name().length() > 0 ? "-" : "") + ((ProtocolServerConfiguration)this.configuration).name();
    }

    @Override
    public void stop() {
        boolean isDebug = this.log.isDebugEnabled();
        if (isDebug && this.configuration != null) {
            this.log.debugf("Stopping server listening in %s:%d", ((ProtocolServerConfiguration)this.configuration).host(), ((ProtocolServerConfiguration)this.configuration).port());
        }
        if (this.transport != null) {
            this.transport.stop();
        }
        try {
            this.unregisterTransportMBean();
        }
        catch (Exception e) {
            throw new CacheException((Throwable)e);
        }
        if (isDebug) {
            this.log.debug("Server stopped");
        }
    }

    public EmbeddedCacheManager getCacheManager() {
        return this.cacheManager;
    }

    public String getHost() {
        return ((ProtocolServerConfiguration)this.configuration).host();
    }

    public int getPort() {
        return ((ProtocolServerConfiguration)this.configuration).port();
    }

    @Override
    public A getConfiguration() {
        return this.configuration;
    }

    protected void startDefaultCache() {
        this.cacheManager.getCache(((ProtocolServerConfiguration)this.configuration).defaultCacheName());
    }
}

