/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.core.transport;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOutboundHandler;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.ssl.CipherSuiteFilter;
import io.netty.handler.ssl.ClientAuth;
import io.netty.handler.ssl.IdentityCipherSuiteFilter;
import io.netty.handler.ssl.JdkSslContext;
import io.netty.handler.ssl.SniHandler;
import io.netty.util.DomainMappingBuilder;
import java.util.Arrays;
import javax.net.ssl.SSLContext;
import org.infinispan.commons.util.SslContextFactory;
import org.infinispan.server.core.ProtocolServer;
import org.infinispan.server.core.configuration.ProtocolServerConfiguration;
import org.infinispan.server.core.configuration.SslConfiguration;
import org.infinispan.server.core.configuration.SslEngineConfiguration;
import org.infinispan.server.core.transport.NettyTransport;
import org.infinispan.server.core.transport.StatsChannelHandler;

public class NettyChannelInitializer<A extends ProtocolServerConfiguration>
extends ChannelInitializer<Channel> {
    protected final ProtocolServer<A> server;
    protected final NettyTransport transport;
    protected final ChannelOutboundHandler encoder;

    public NettyChannelInitializer(ProtocolServer<A> server, NettyTransport transport, ChannelOutboundHandler encoder) {
        this.server = server;
        this.transport = transport;
        this.encoder = encoder;
    }

    protected void initChannel(Channel ch) throws Exception {
        ChannelPipeline pipeline = ch.pipeline();
        pipeline.addLast("stats", (ChannelHandler)new StatsChannelHandler(this.transport));
        SslConfiguration ssl = ((ProtocolServerConfiguration)this.server.getConfiguration()).ssl();
        if (ssl.enabled()) {
            JdkSslContext defaultNettySslContext = this.createNettySslContext(ssl, ssl.sniDomainsConfiguration().get("*"));
            DomainMappingBuilder domainMappingBuilder = new DomainMappingBuilder((Object)defaultNettySslContext);
            ssl.sniDomainsConfiguration().forEach((k, v) -> {
                if (!"*".equals(k)) {
                    domainMappingBuilder.add(k, (Object)this.createNettySslContext(ssl, (SslEngineConfiguration)v));
                }
            });
            pipeline.addLast("sni", (ChannelHandler)new SniHandler(domainMappingBuilder.build()));
        }
        pipeline.addLast("decoder", (ChannelHandler)this.server.getDecoder());
        if (this.encoder != null) {
            pipeline.addLast("encoder", (ChannelHandler)this.encoder);
        }
    }

    private JdkSslContext createNettySslContext(SslConfiguration sslConfiguration, SslEngineConfiguration sslEngineConfiguration) {
        SSLContext sslContext = sslEngineConfiguration.sslContext() != null ? sslEngineConfiguration.sslContext() : SslContextFactory.getContext((String)sslEngineConfiguration.keyStoreFileName(), (char[])sslEngineConfiguration.keyStorePassword(), (char[])sslEngineConfiguration.keyStoreCertificatePassword(), (String)sslEngineConfiguration.trustStoreFileName(), (char[])sslEngineConfiguration.trustStorePassword());
        return this.createSslContext(sslContext, this.requireClientAuth(sslConfiguration));
    }

    private JdkSslContext createSslContext(SSLContext sslContext, ClientAuth clientAuth) {
        String[] ciphers = SslContextFactory.getEngine((SSLContext)sslContext, (boolean)false, (boolean)false).getSupportedCipherSuites();
        return new JdkSslContext(sslContext, false, Arrays.asList(ciphers), (CipherSuiteFilter)IdentityCipherSuiteFilter.INSTANCE, null, clientAuth);
    }

    private ClientAuth requireClientAuth(SslConfiguration sslConfig) {
        return sslConfig.requireClientAuth() ? ClientAuth.REQUIRE : ClientAuth.NONE;
    }
}

