/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.interceptors.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.CompletableFuture;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.infinispan.InvalidCacheUsageException;
import org.infinispan.commands.FlagAffectedCommand;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commands.control.LockControlCommand;
import org.infinispan.commands.tx.TransactionBoundaryCommand;
import org.infinispan.commands.write.WriteCommand;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.util.Util;
import org.infinispan.context.Flag;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.impl.TxInvocationContext;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.factories.annotations.Stop;
import org.infinispan.interceptors.AsyncInterceptor;
import org.infinispan.interceptors.BaseAsyncInterceptor;
import org.infinispan.interceptors.totalorder.RetryPrepareException;
import org.infinispan.lifecycle.ComponentStatus;
import org.infinispan.statetransfer.OutdatedTopologyException;
import org.infinispan.transaction.WriteSkewException;
import org.infinispan.transaction.impl.TransactionTable;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class InvocationContextInterceptor
extends BaseAsyncInterceptor {
    private TransactionManager tm;
    private ComponentRegistry componentRegistry;
    private TransactionTable txTable;
    private static final Log log = LogFactory.getLog(InvocationContextInterceptor.class);
    private static final boolean trace = log.isTraceEnabled();
    private volatile boolean shuttingDown = false;
    private final AsyncInterceptor.ReturnHandler defaultReturnHandler = new AsyncInterceptor.ReturnHandler(){

        @Override
        public CompletableFuture<Object> handle(InvocationContext rCtx, VisitableCommand rCommand, Object rv, Throwable throwable) throws Throwable {
            if (throwable == null) {
                return null;
            }
            if (throwable instanceof InvalidCacheUsageException || throwable instanceof InterruptedException) {
                throw throwable;
            }
            InvocationContextInterceptor.this.rethrowException(rCtx, rCommand, throwable);
            if (rCommand instanceof LockControlCommand) {
                return rv != null ? null : CompletableFuture.completedFuture(Boolean.FALSE);
            }
            return CompletableFuture.completedFuture(rv);
        }
    };

    @Start(priority=1)
    private void setStartStatus() {
        this.shuttingDown = false;
    }

    @Stop(priority=1)
    private void setStopStatus() {
        this.shuttingDown = true;
    }

    @Inject
    public void init(TransactionManager tm, ComponentRegistry componentRegistry, TransactionTable txTable) {
        this.tm = tm;
        this.componentRegistry = componentRegistry;
        this.txTable = txTable;
    }

    @Override
    public CompletableFuture<Void> visitCommand(InvocationContext ctx, VisitableCommand command) throws Throwable {
        if (trace) {
            log.tracef("Invoked with command %s and InvocationContext [%s]", command, ctx);
        }
        if (ctx == null) {
            throw new IllegalStateException("Null context not allowed!!");
        }
        ComponentStatus status = this.componentRegistry.getStatus();
        if (command.ignoreCommandOnStatus(status)) {
            log.debugf("Status: %s : Ignoring %s command", (Object)status, command);
            return ctx.shortCircuit(null);
        }
        if (status.isTerminated()) {
            throw log.cacheIsTerminated(this.getCacheNamePrefix());
        }
        if (this.stoppingAndNotAllowed(status, ctx)) {
            throw log.cacheIsStopping(this.getCacheNamePrefix());
        }
        return ctx.onReturn(this.defaultReturnHandler);
    }

    private void rethrowException(InvocationContext ctx, VisitableCommand command, Throwable th) throws Throwable {
        boolean suppressExceptions = command instanceof FlagAffectedCommand && ((FlagAffectedCommand)command).hasFlag(Flag.FAIL_SILENTLY);
        boolean bl = suppressExceptions = suppressExceptions || this.shuttingDown;
        if (suppressExceptions) {
            if (this.shuttingDown) {
                log.trace("Exception while executing code, but we're shutting down so failing silently.", th);
            } else {
                log.trace("Exception while executing code, failing silently...", th);
            }
        } else {
            if (th instanceof WriteSkewException) {
                log.debug("Exception executing call", th);
            } else if (th instanceof OutdatedTopologyException) {
                log.outdatedTopology(th);
            } else if (th instanceof RetryPrepareException) {
                log.debugf("Retrying total order prepare command for transaction %s, affected keys %s", ctx.getLockOwner(), Util.toStr(this.extractWrittenKeys(ctx, command)));
            } else {
                Collection<Object> affectedKeys = this.extractWrittenKeys(ctx, command);
                log.executionError(command.getClass().getSimpleName(), Util.toStr(affectedKeys), th);
            }
            if (ctx.isInTxScope() && ctx.isOriginLocal()) {
                if (trace) {
                    log.trace("Transaction marked for rollback as exception was received.");
                }
                this.markTxForRollbackAndRethrow(ctx, th);
                throw new IllegalStateException("This should not be reached");
            }
            throw th;
        }
    }

    private Collection<Object> extractWrittenKeys(InvocationContext ctx, VisitableCommand command) {
        if (command instanceof WriteCommand) {
            return ((WriteCommand)command).getAffectedKeys();
        }
        if (command instanceof LockControlCommand) {
            return Collections.emptyList();
        }
        if (command instanceof TransactionBoundaryCommand) {
            return ((TxInvocationContext)ctx).getAffectedKeys();
        }
        return Collections.emptyList();
    }

    private String getCacheNamePrefix() {
        String cacheName = this.componentRegistry.getCacheName();
        String prefix = "Cache '" + cacheName + "'";
        if (cacheName.equals("___defaultcache")) {
            prefix = "Default cache";
        }
        return prefix;
    }

    private boolean stoppingAndNotAllowed(ComponentStatus status, InvocationContext ctx) throws Exception {
        return status.isStopping() && (!ctx.isInTxScope() || !this.isOngoingTransaction(ctx));
    }

    private Object markTxForRollbackAndRethrow(InvocationContext ctx, Throwable te) throws Throwable {
        Transaction transaction;
        if (ctx.isOriginLocal() && ctx.isInTxScope() && (transaction = this.tm.getTransaction()) != null && this.isValidRunningTx(transaction)) {
            transaction.setRollbackOnly();
        }
        throw te;
    }

    private boolean isValidRunningTx(Transaction tx) throws Exception {
        int status;
        try {
            status = tx.getStatus();
        }
        catch (SystemException e) {
            throw new CacheException("Unexpected!", (Throwable)e);
        }
        return status == 0;
    }

    private boolean isOngoingTransaction(InvocationContext ctx) throws SystemException {
        if (!ctx.isInTxScope()) {
            return false;
        }
        if (ctx.isOriginLocal()) {
            return this.txTable.containsLocalTx(this.tm.getTransaction());
        }
        return this.txTable.containRemoteTx(((TxInvocationContext)ctx).getGlobalTransaction());
    }
}

