/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.interceptors.impl;

import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.infinispan.commands.FlagAffectedCommand;
import org.infinispan.commands.control.LockControlCommand;
import org.infinispan.commands.read.GetAllCommand;
import org.infinispan.commands.read.GetCacheEntryCommand;
import org.infinispan.commands.read.GetKeyValueCommand;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.commands.write.PutMapCommand;
import org.infinispan.commands.write.RemoveCommand;
import org.infinispan.commands.write.ReplaceCommand;
import org.infinispan.commons.marshall.NotSerializableException;
import org.infinispan.commons.marshall.StreamingMarshaller;
import org.infinispan.context.Flag;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.impl.TxInvocationContext;
import org.infinispan.distribution.DistributionManager;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.interceptors.DDAsyncInterceptor;

public class IsMarshallableInterceptor
extends DDAsyncInterceptor {
    private StreamingMarshaller marshaller;
    private DistributionManager distManager;
    private boolean storeAsBinary;

    @Inject
    protected void injectMarshaller(StreamingMarshaller marshaller, DistributionManager distManager) {
        this.marshaller = marshaller;
        this.distManager = distManager;
    }

    @Start
    protected void start() {
        this.storeAsBinary = this.cacheConfiguration.storeAsBinary().enabled() && (this.cacheConfiguration.storeAsBinary().storeKeysAsBinary() || this.cacheConfiguration.storeAsBinary().storeValuesAsBinary());
    }

    @Override
    public CompletableFuture<Void> visitGetKeyValueCommand(InvocationContext ctx, GetKeyValueCommand command) throws Throwable {
        Object key = command.getKey();
        if (this.isStoreAsBinary() || this.getMightGoRemote(ctx, key, command)) {
            this.checkMarshallable(key);
        }
        return ctx.continueInvocation();
    }

    @Override
    public CompletableFuture<Void> visitGetCacheEntryCommand(InvocationContext ctx, GetCacheEntryCommand command) throws Throwable {
        Object key = command.getKey();
        if (this.isStoreAsBinary() || this.getMightGoRemote(ctx, key, command)) {
            this.checkMarshallable(key);
        }
        return ctx.continueInvocation();
    }

    @Override
    public CompletableFuture<Void> visitGetAllCommand(InvocationContext ctx, GetAllCommand command) throws Throwable {
        for (Object key : command.getKeys()) {
            if (!this.isStoreAsBinary() && !this.getMightGoRemote(ctx, key, command)) continue;
            this.checkMarshallable(key);
        }
        return ctx.continueInvocation();
    }

    @Override
    public CompletableFuture<Void> visitLockControlCommand(TxInvocationContext ctx, LockControlCommand command) throws Throwable {
        if (this.isStoreAsBinary() || this.isClusterInvocation(ctx, command)) {
            for (Object key : command.getKeys()) {
                this.checkMarshallable(key);
            }
        }
        return ctx.continueInvocation();
    }

    @Override
    public CompletableFuture<Void> visitPutKeyValueCommand(InvocationContext ctx, PutKeyValueCommand command) throws Throwable {
        if (this.isStoreAsBinary() || this.isClusterInvocation(ctx, command) || this.isStoreInvocation(command)) {
            this.checkMarshallable(command.getKey());
            this.checkMarshallable(command.getValue());
        }
        return ctx.continueInvocation();
    }

    @Override
    public CompletableFuture<Void> visitPutMapCommand(InvocationContext ctx, PutMapCommand command) throws Throwable {
        if (this.isStoreAsBinary() || this.isClusterInvocation(ctx, command) || this.isStoreInvocation(command)) {
            this.checkMarshallable(command.getMap());
        }
        return ctx.continueInvocation();
    }

    @Override
    public CompletableFuture<Void> visitRemoveCommand(InvocationContext ctx, RemoveCommand command) throws Throwable {
        if (this.isStoreAsBinary() || this.isClusterInvocation(ctx, command) || this.isStoreInvocation(command)) {
            this.checkMarshallable(command.getKey());
        }
        return ctx.continueInvocation();
    }

    @Override
    public CompletableFuture<Void> visitReplaceCommand(InvocationContext ctx, ReplaceCommand command) throws Throwable {
        if (this.isStoreAsBinary() || this.isClusterInvocation(ctx, command) || this.isStoreInvocation(command)) {
            this.checkMarshallable(command.getKey());
            this.checkMarshallable(command.getNewValue());
        }
        return ctx.continueInvocation();
    }

    private boolean isClusterInvocation(InvocationContext ctx, FlagAffectedCommand command) {
        return ctx.isOriginLocal() && this.cacheConfiguration.clustering().cacheMode().isClustered() && !command.hasFlag(Flag.CACHE_MODE_LOCAL);
    }

    private boolean isStoreInvocation(FlagAffectedCommand command) {
        return !this.cacheConfiguration.clustering().cacheMode().isClustered() && !this.cacheConfiguration.persistence().stores().isEmpty() && !command.hasFlag(Flag.SKIP_CACHE_STORE);
    }

    private boolean isStoreAsBinary() {
        return this.storeAsBinary;
    }

    private boolean getMightGoRemote(InvocationContext ctx, Object key, FlagAffectedCommand command) {
        return ctx.isOriginLocal() && this.cacheConfiguration.clustering().cacheMode().isDistributed() && !command.hasFlag(Flag.SKIP_REMOTE_LOOKUP) && !command.hasFlag(Flag.CACHE_MODE_LOCAL) && !this.distManager.getLocality(key).isLocal();
    }

    private void checkMarshallable(Object o) throws NotSerializableException {
        boolean marshallable = false;
        try {
            marshallable = this.marshaller.isMarshallable(o);
        }
        catch (Exception e) {
            this.throwNotSerializable(o, e);
        }
        if (!marshallable) {
            this.throwNotSerializable(o, null);
        }
    }

    private void throwNotSerializable(Object o, Throwable t) {
        String msg = String.format("Object of type %s expected to be marshallable", o.getClass());
        if (t == null) {
            throw new NotSerializableException(msg);
        }
        throw new NotSerializableException(msg, t);
    }

    private void checkMarshallable(Map<Object, Object> objs) throws NotSerializableException {
        for (Map.Entry<Object, Object> entry : objs.entrySet()) {
            this.checkMarshallable(entry.getKey());
            this.checkMarshallable(entry.getValue());
        }
    }
}

