/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.marshall.core;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.NotSerializableException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import org.infinispan.commons.io.ByteBuffer;
import org.infinispan.commons.io.ByteBufferImpl;
import org.infinispan.commons.io.ExposedByteArrayOutputStream;
import org.infinispan.commons.marshall.AbstractMarshaller;
import org.infinispan.commons.marshall.StreamingMarshaller;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.factories.annotations.Stop;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.marshall.core.ExternalizerTable;
import org.infinispan.marshall.core.JBossMarshaller;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

@Scope(value=Scopes.GLOBAL)
public class GlobalMarshaller
extends AbstractMarshaller
implements StreamingMarshaller {
    private static final Log log = LogFactory.getLog(GlobalMarshaller.class);
    private final boolean trace = log.isTraceEnabled();
    private JBossMarshaller defaultMarshaller;
    private ExternalizerTable extTable;
    private GlobalConfiguration globalCfg;

    @Inject
    public void inject(ExternalizerTable extTable, GlobalConfiguration globalCfg) {
        this.extTable = extTable;
        this.globalCfg = globalCfg;
    }

    @Start(priority=8)
    public void start() {
        this.defaultMarshaller = new JBossMarshaller(this.extTable, this.globalCfg);
        this.defaultMarshaller.start();
    }

    @Stop(priority=11)
    public void stop() {
        this.defaultMarshaller.stop();
    }

    protected ByteBuffer objectToBuffer(Object obj, int estimatedSize) throws IOException, InterruptedException {
        ExposedByteArrayOutputStream baos = new ExposedByteArrayOutputStream(estimatedSize);
        ObjectOutput out = this.startObjectOutput((OutputStream)baos, false, estimatedSize);
        try {
            this.defaultMarshaller.objectToObjectStream(obj, out);
        }
        catch (NotSerializableException nse) {
            if (log.isDebugEnabled()) {
                log.debug("Object is not serializable", nse);
            }
            throw new org.infinispan.commons.marshall.NotSerializableException(nse.getMessage(), nse.getCause());
        }
        catch (IOException ioe) {
            if (ioe.getCause() instanceof InterruptedException) {
                if (this.trace) {
                    log.trace("Interrupted exception while marshalling", ioe.getCause());
                }
                throw (InterruptedException)ioe.getCause();
            }
            log.errorMarshallingObject(ioe, obj);
            throw ioe;
        }
        finally {
            this.finishObjectOutput(out);
        }
        return new ByteBufferImpl(baos.getRawBuffer(), 0, baos.size());
    }

    public Object objectFromByteBuffer(byte[] bytes, int offset, int len) throws IOException, ClassNotFoundException {
        return this.defaultMarshaller.objectFromByteBuffer(bytes, offset, len);
    }

    public ObjectOutput startObjectOutput(OutputStream os, boolean isReentrant, int estimatedSize) throws IOException {
        return this.defaultMarshaller.startObjectOutput(os, isReentrant, estimatedSize);
    }

    public void finishObjectOutput(ObjectOutput oo) {
        this.defaultMarshaller.finishObjectOutput(oo);
    }

    public void objectToObjectStream(Object obj, ObjectOutput out) throws IOException {
        this.defaultMarshaller.objectToObjectStream(obj, out);
    }

    public ObjectInput startObjectInput(InputStream is, boolean isReentrant) throws IOException {
        return this.defaultMarshaller.startObjectInput(is, isReentrant);
    }

    public void finishObjectInput(ObjectInput oi) {
        this.defaultMarshaller.finishObjectInput(oi);
    }

    public Object objectFromObjectStream(ObjectInput in) throws IOException, ClassNotFoundException, InterruptedException {
        try {
            return this.defaultMarshaller.objectFromObjectStream(in);
        }
        catch (EOFException e) {
            EOFException ee = new EOFException("The stream ended unexpectedly.  Please check whether the source of the stream encountered any issues generating the stream.");
            ee.initCause(e);
            throw ee;
        }
        catch (IOException ioe) {
            if (this.trace) {
                log.trace("Log exception reported", ioe);
            }
            if (ioe.getCause() instanceof InterruptedException) {
                throw (InterruptedException)ioe.getCause();
            }
            throw ioe;
        }
    }

    public boolean isMarshallable(Object o) throws Exception {
        return this.defaultMarshaller.isMarshallable(o);
    }
}

