/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.marshall.core;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.util.Set;
import org.infinispan.commands.ReplicableCommand;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.io.UnsignedNumeric;
import org.infinispan.commons.marshall.AbstractExternalizer;
import org.infinispan.commons.marshall.StreamingMarshaller;
import org.infinispan.commons.marshall.jboss.GenericJBossMarshaller;
import org.infinispan.commons.util.Util;
import org.infinispan.io.ExpandableMarshalledValueByteStream;
import org.infinispan.io.ImmutableMarshalledValueByteStream;
import org.infinispan.io.MarshalledValueByteStream;
import org.infinispan.remoting.transport.Address;
import org.infinispan.transaction.xa.GlobalTransaction;

public final class MarshalledValue
implements Externalizable {
    private MarshalledValueByteStream raw;
    private int serialisedSize;
    private int cachedHashCode;
    private transient StreamingMarshaller marshaller;

    public MarshalledValue() {
    }

    public MarshalledValue(byte[] bytes, int hashCode, StreamingMarshaller marshaller) {
        this.marshaller = marshaller;
        this.raw = new ImmutableMarshalledValueByteStream(bytes);
        this.cachedHashCode = hashCode;
        this.serialisedSize = bytes.length;
    }

    public MarshalledValue(Object instance, StreamingMarshaller marshaller) {
        this.marshaller = marshaller;
        this.raw = this.serialize(instance);
        this.serialisedSize = this.raw.size();
        this.cachedHashCode = instance.hashCode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MarshalledValueByteStream serialize(Object instance) {
        try {
            ExpandableMarshalledValueByteStream baos = new ExpandableMarshalledValueByteStream(this.serialisedSize);
            ObjectOutput out = this.marshaller.startObjectOutput((OutputStream)baos, true, this.serialisedSize);
            try {
                this.marshaller.objectToObjectStream(instance, out);
            }
            finally {
                this.marshaller.finishObjectOutput(out);
            }
            return baos;
        }
        catch (Exception e) {
            throw new CacheException("Unable to marshall value " + instance, (Throwable)e);
        }
    }

    private Object deserialize() {
        try {
            return this.marshaller.objectFromByteBuffer(this.raw.getRaw(), 0, this.raw.size());
        }
        catch (Exception e) {
            throw new CacheException("Unable to unmarshall value", (Throwable)e);
        }
    }

    public MarshalledValueByteStream getRaw() {
        return this.raw;
    }

    public Object get() {
        return this.deserialize();
    }

    public StreamingMarshaller getMarshaller() {
        return this.marshaller;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || MarshalledValue.class != o.getClass()) {
            return false;
        }
        MarshalledValue that = (MarshalledValue)o;
        MarshalledValueByteStream thisRaw = this.raw;
        MarshalledValueByteStream thatRaw = that.raw;
        if (thisRaw != null && thatRaw != null) {
            return thisRaw.equals(thatRaw);
        }
        return false;
    }

    public int hashCode() {
        return this.cachedHashCode;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder().append("MarshalledValue{").append("serialized=").append(Util.printArray((byte[])this.raw.getRaw(), (boolean)false)).append("}@").append(Util.hexIdHashCode((Object)this));
        return sb.toString();
    }

    public static boolean isTypeExcluded(Class<?> type) {
        return type.equals(String.class) || type.isPrimitive() || type.equals(Void.class) || type.equals(Boolean.class) || type.equals(Character.class) || type.equals(Byte.class) || type.equals(Short.class) || type.equals(Integer.class) || type.equals(Long.class) || type.equals(Float.class) || type.equals(Double.class) || type.isArray() && MarshalledValue.isTypeExcluded(type.getComponentType()) || type.equals(GlobalTransaction.class) || Address.class.isAssignableFrom(type) || ReplicableCommand.class.isAssignableFrom(type) || type.equals(MarshalledValue.class);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.serialisedSize);
        out.write(this.raw.getRaw());
        out.writeInt(this.cachedHashCode);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.serialisedSize = in.readInt();
        byte[] bytes = new byte[this.serialisedSize];
        in.readFully(bytes);
        this.raw = new ImmutableMarshalledValueByteStream(bytes);
        this.cachedHashCode = in.readInt();
        this.marshaller = new GenericJBossMarshaller();
    }

    public static class Externalizer
    extends AbstractExternalizer<MarshalledValue> {
        private final StreamingMarshaller globalMarshaller;

        public Externalizer(StreamingMarshaller globalMarshaller) {
            this.globalMarshaller = globalMarshaller;
        }

        public void writeObject(ObjectOutput output, MarshalledValue mv) throws IOException {
            int hashCode = mv.hashCode();
            MarshalledValueByteStream raw = mv.getRaw();
            int rawLength = raw.size();
            UnsignedNumeric.writeUnsignedInt((ObjectOutput)output, (int)rawLength);
            output.write(raw.getRaw(), 0, rawLength);
            output.writeInt(hashCode);
        }

        public MarshalledValue readObject(ObjectInput input) throws IOException {
            int length = UnsignedNumeric.readUnsignedInt((ObjectInput)input);
            byte[] raw = new byte[length];
            input.readFully(raw);
            int hc = input.readInt();
            return new MarshalledValue(raw, hc, this.globalMarshaller);
        }

        public Integer getId() {
            return 40;
        }

        public Set<Class<? extends MarshalledValue>> getTypeClasses() {
            return Util.asSet((Object[])new Class[]{MarshalledValue.class});
        }
    }
}

