/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.messaging.activemq.deployment.injection;

import java.io.Serializable;
import java.util.UUID;
import javax.annotation.PreDestroy;
import javax.enterprise.context.ContextNotActiveException;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.inject.Inject;
import javax.jms.ConnectionFactory;
import javax.jms.JMSConnectionFactory;
import javax.jms.JMSContext;
import javax.jms.JMSPasswordCredential;
import javax.jms.JMSSessionMode;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.transaction.TransactionSynchronizationRegistry;
import org.wildfly.extension.messaging.activemq.deployment.injection.AbstractJMSContext;
import org.wildfly.extension.messaging.activemq.deployment.injection.JMSContextWrapper;
import org.wildfly.extension.messaging.activemq.deployment.injection.JMSInfo;
import org.wildfly.extension.messaging.activemq.deployment.injection.RequestedJMSContext;
import org.wildfly.extension.messaging.activemq.deployment.injection.TransactedJMSContext;
import org.wildfly.extension.messaging.activemq.logging.MessagingLogger;

class InjectedJMSContext
extends JMSContextWrapper
implements Serializable {
    private static final String TRANSACTION_SYNCHRONIZATION_REGISTRY_LOOKUP = "java:comp/TransactionSynchronizationRegistry";
    private final JMSInfo info;
    private final RequestedJMSContext requestedJMSContext;
    private final String id = UUID.randomUUID().toString();
    private transient Instance<TransactedJMSContext> transactedJMSContext;
    private transient ConnectionFactory connectionFactory;
    private transient TransactionSynchronizationRegistry transactionSynchronizationRegistry;

    @Inject
    InjectedJMSContext(InjectionPoint ip, RequestedJMSContext requestedJMSContext, Instance<TransactedJMSContext> transactedJMSContext) {
        this.requestedJMSContext = requestedJMSContext;
        this.transactedJMSContext = transactedJMSContext;
        JMSConnectionFactory connectionFactory = (JMSConnectionFactory)ip.getAnnotated().getAnnotation(JMSConnectionFactory.class);
        JMSPasswordCredential credential = (JMSPasswordCredential)ip.getAnnotated().getAnnotation(JMSPasswordCredential.class);
        JMSSessionMode sessionMode = (JMSSessionMode)ip.getAnnotated().getAnnotation(JMSSessionMode.class);
        this.info = new JMSInfo(connectionFactory, credential, sessionMode);
    }

    @PreDestroy
    private void cleanUp() {
        MessagingLogger.ROOT_LOGGER.debugf("Cleaning up injected JMSContext %s", this.id);
        this.cleanUpContext(this.requestedJMSContext);
        this.cleanUpContext((AbstractJMSContext)this.transactedJMSContext.get());
    }

    private void cleanUpContext(AbstractJMSContext context) {
        try {
            context.cleanUp();
        }
        catch (ContextNotActiveException contextNotActiveException) {
            // empty catch block
        }
    }

    @Override
    JMSContext getDelegate() {
        boolean inTx = this.isInTransaction();
        RequestedJMSContext jmsContext = inTx ? (AbstractJMSContext)this.transactedJMSContext.get() : this.requestedJMSContext;
        MessagingLogger.ROOT_LOGGER.debugf("using %s to create the injected JMSContext", jmsContext, this.id);
        ConnectionFactory connectionFactory = this.getConnectionFactory();
        return jmsContext.getContext(this.id, this.info, connectionFactory);
    }

    private boolean isInTransaction() {
        TransactionSynchronizationRegistry tsr = this.getTransactionSynchronizationRegistry();
        boolean inTx = tsr.getTransactionStatus() == 0;
        return inTx;
    }

    private TransactionSynchronizationRegistry getTransactionSynchronizationRegistry() {
        TransactionSynchronizationRegistry cachedTSR = this.transactionSynchronizationRegistry;
        if (cachedTSR == null) {
            this.transactionSynchronizationRegistry = cachedTSR = (TransactionSynchronizationRegistry)this.lookup(TRANSACTION_SYNCHRONIZATION_REGISTRY_LOOKUP);
        }
        return cachedTSR;
    }

    private ConnectionFactory getConnectionFactory() {
        ConnectionFactory cachedCF = this.connectionFactory;
        if (cachedCF == null) {
            this.connectionFactory = cachedCF = (ConnectionFactory)this.lookup(this.info.getConnectionFactoryLookup());
        }
        return cachedCF;
    }

    private Object lookup(String name) {
        InitialContext ctx = null;
        try {
            ctx = new InitialContext();
            Object object = ctx.lookup(name);
            return object;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            if (ctx != null) {
                try {
                    ctx.close();
                }
                catch (NamingException namingException) {}
            }
        }
    }
}

