/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.rest.configuration;

import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.infinispan.configuration.cache.StoreConfiguration;
import org.infinispan.configuration.serializing.AbstractStoreSerializer;
import org.infinispan.configuration.serializing.ConfigurationSerializer;
import org.infinispan.configuration.serializing.XMLExtendedStreamWriter;
import org.infinispan.persistence.rest.configuration.Attribute;
import org.infinispan.persistence.rest.configuration.ConnectionPoolConfiguration;
import org.infinispan.persistence.rest.configuration.Element;
import org.infinispan.persistence.rest.configuration.RestStoreConfiguration;

public class RestStoreConfigurationSerializer
extends AbstractStoreSerializer
implements ConfigurationSerializer<RestStoreConfiguration> {
    public void serialize(XMLExtendedStreamWriter writer, RestStoreConfiguration configuration) throws XMLStreamException {
        writer.writeStartElement((Enum)Element.REST_STORE);
        configuration.attributes().write((XMLStreamWriter)writer);
        this.writeCommonStoreSubAttributes(writer, configuration);
        this.writeServer(writer, configuration);
        this.writeConnectionPool(writer, configuration.connectionPool());
        this.writeCommonStoreElements(writer, (StoreConfiguration)configuration);
        writer.writeEndElement();
    }

    private void writeConnectionPool(XMLExtendedStreamWriter writer, ConnectionPoolConfiguration configuration) throws XMLStreamException {
        writer.writeStartElement((Enum)Element.CONNECTION_POOL);
        writer.writeAttribute((Enum)Attribute.BUFFER_SIZE, Integer.toString(configuration.bufferSize()));
        writer.writeAttribute((Enum)Attribute.MAX_CONNECTIONS_PER_HOST, Integer.toString(configuration.maxConnectionsPerHost()));
        writer.writeAttribute((Enum)Attribute.MAX_TOTAL_CONNECTIONS, Integer.toString(configuration.maxTotalConnections()));
        writer.writeAttribute((Enum)Attribute.CONNECTION_TIMEOUT, Integer.toString(configuration.connectionTimeout()));
        writer.writeAttribute((Enum)Attribute.SOCKET_TIMEOUT, Integer.toString(configuration.socketTimeout()));
        writer.writeAttribute((Enum)Attribute.TCP_NO_DELAY, Boolean.toString(configuration.tcpNoDelay()));
        writer.writeEndElement();
    }

    private void writeServer(XMLExtendedStreamWriter writer, RestStoreConfiguration configuration) throws XMLStreamException {
        writer.writeStartElement((Enum)Element.SERVER);
        writer.writeAttribute((Enum)Attribute.HOST, configuration.host());
        writer.writeAttribute((Enum)Attribute.PORT, Integer.toString(configuration.port()));
        writer.writeEndElement();
    }
}

