/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.io.DataInput;
import java.io.DataOutput;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.Header;
import org.jgroups.Message;
import org.jgroups.View;
import org.jgroups.annotations.Experimental;
import org.jgroups.annotations.MBean;
import org.jgroups.annotations.Property;
import org.jgroups.annotations.Unsupported;
import org.jgroups.stack.Protocol;
import org.jgroups.util.ConcurrentLinkedBlockingQueue;
import org.jgroups.util.TimeScheduler;
import org.jgroups.util.Util;

@Experimental
@Unsupported
@MBean(description="Alternating Bit Protocol, for reliable p2p unicasts")
public class ABP
extends Protocol {
    @Property(description="Interval (in ms) at which a sent msg is resent")
    protected long resend_interval = 1000L;
    protected final ConcurrentHashMap<Address, Entry> send_map = new ConcurrentHashMap();
    protected final ConcurrentHashMap<Address, Entry> recv_map = new ConcurrentHashMap();
    protected TimeScheduler timer;
    protected Address local_addr;

    @Override
    public void init() throws Exception {
        super.init();
        this.timer = this.getTransport().getTimer();
    }

    @Override
    public Object down(Event evt) {
        switch (evt.getType()) {
            case 1: {
                Message msg = (Message)evt.getArg();
                Address dest = msg.dest();
                if (dest == null) break;
                Entry entry = this.getEntry(this.send_map, dest);
                entry.send(msg);
                return null;
            }
            case 6: {
                View view = (View)evt.getArg();
                ((ConcurrentHashMap.CollectionView)((Object)this.send_map.keySet())).retainAll(view.getMembers());
                ((ConcurrentHashMap.CollectionView)((Object)this.recv_map.keySet())).retainAll(view.getMembers());
                break;
            }
            case 8: {
                this.local_addr = (Address)evt.getArg();
            }
        }
        return this.down_prot.down(evt);
    }

    @Override
    public Object up(Event evt) {
        switch (evt.getType()) {
            case 1: {
                ABPHeader hdr;
                Message msg = (Message)evt.getArg();
                Address dest = msg.dest();
                Address sender = msg.src();
                if (dest == null || (hdr = (ABPHeader)msg.getHeader(this.id)) == null) break;
                switch (hdr.type) {
                    case data: {
                        Entry entry = this.getEntry(this.recv_map, sender);
                        this.log.trace("%s: <-- %s.msg(%d)", this.local_addr, sender, hdr.bit);
                        if (!entry.handleMessage(sender, hdr.bit)) break;
                        return this.up_prot.up(evt);
                    }
                    case ack: {
                        this.log.trace("%s: <-- %s.ack(%d)", this.local_addr, sender, hdr.bit);
                        Entry entry = this.getEntry(this.send_map, sender);
                        entry.handleAck(hdr.bit);
                    }
                }
                return null;
            }
        }
        return this.up_prot.up(evt);
    }

    protected Entry getEntry(ConcurrentMap<Address, Entry> map, Address dest) {
        Entry existing;
        Entry entry = (Entry)map.get(dest);
        if (entry == null && (existing = map.putIfAbsent(dest, entry = new Entry())) != null) {
            entry = existing;
        }
        return entry;
    }

    protected static class ABPHeader
    extends Header {
        protected Type type;
        protected byte bit;

        public ABPHeader() {
        }

        public ABPHeader(Type type, byte bit) {
            this.type = type;
            this.bit = bit;
        }

        @Override
        public int size() {
            return 2;
        }

        @Override
        public void writeTo(DataOutput out) throws Exception {
            out.writeByte(this.type.ordinal());
            out.writeByte(this.bit);
        }

        @Override
        public void readFrom(DataInput in) throws Exception {
            this.type = Type.values()[in.readByte()];
            this.bit = in.readByte();
        }

        @Override
        public String toString() {
            return "ABP (" + this.bit + ")";
        }
    }

    protected class Entry
    implements Runnable {
        protected byte bit = 0;
        protected final BlockingQueue<Message> send_queue = new ConcurrentLinkedBlockingQueue<Message>(500);
        protected Thread xmit_task;

        protected Entry() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void send(Message msg) {
            BlockingQueue<Message> blockingQueue = this.send_queue;
            synchronized (blockingQueue) {
                this.send_queue.add(msg);
            }
            this.startTask();
        }

        protected synchronized boolean handleMessage(Address sender, byte msg_bit) {
            boolean retval = false;
            if (this.bit == msg_bit) {
                this.bit = (byte)(this.bit ^ 1);
                retval = true;
            }
            byte ack_bit = (byte)(this.bit ^ 1);
            Message ack = new Message(sender).putHeader(ABP.this.id, new ABPHeader(Type.ack, ack_bit));
            ABP.this.log.trace("%s: --> %s.ack(%d)", ABP.this.local_addr, sender, ack_bit);
            ABP.this.down_prot.down(new Event(1, ack));
            return retval;
        }

        protected synchronized void handleAck(byte ack_bit) {
            if (this.bit == ack_bit) {
                this.bit = (byte)(this.bit ^ 1);
                if (!this.send_queue.isEmpty()) {
                    this.send_queue.remove(0);
                }
            }
        }

        protected synchronized void startTask() {
            if (this.xmit_task == null || !this.xmit_task.isAlive()) {
                this.xmit_task = new Thread((Runnable)this, "ABP.XmitTask");
                this.xmit_task.setDaemon(true);
                this.xmit_task.start();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Message msg = null;
            while (true) {
                Message copy;
                Entry entry = this;
                synchronized (entry) {
                    try {
                        msg = this.send_queue.poll(1000L, TimeUnit.MILLISECONDS);
                        if (msg == null) {
                            Util.sleep(1000L);
                            continue;
                        }
                    }
                    catch (InterruptedException e) {
                        return;
                    }
                    copy = msg.copy().putHeader(ABP.this.id, new ABPHeader(Type.data, this.bit));
                }
                ABP.this.log.trace("%s: --> %s.msg(%d). Msg: %s", ABP.this.local_addr, copy.dest(), this.bit, copy.printHeaders());
                ABP.this.down_prot.down(new Event(1, copy));
            }
        }
    }

    protected static enum Type {
        data,
        ack;

    }
}

